/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta.propertypage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Namespace;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.module.IPropertyPagesProvider;
import org.mule.tooling.model.module.PropertyPageDefinition;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeCategory;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.ChildManagingAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.propertypage.ContributionHandlerPropertyPageDefinition;

public final class ContributionHandlerPropertyPageProvider
implements IPropertyPagesProvider {
    public static final String GENERAL_ATTR_CATEGORY = "General";
    private final AbstractComponentMeta componentMeta;

    public ContributionHandlerPropertyPageProvider(AbstractComponentMeta cmp) {
        this.componentMeta = cmp;
    }

    public List<PropertyPageDefinition> getPropertyPages(Object ct) {
        if (ct instanceof IMuleProject) {
            ct = new AttributeContext((IMuleProject)ct);
        }
        AttributeContext ctx = (AttributeContext)ct;
        Map<String, AttributeCategory> attributeCategoryMap = this.componentMeta.getAttributeCategoryMap();
        LinkedHashMap newMap = Maps.newLinkedHashMap();
        this.putWrapInAttributes(newMap);
        newMap.putAll(attributeCategoryMap);
        this.replaceNullAttributeCategoryCaptions(newMap);
        ArrayList result = Lists.newArrayList();
        Collection<String> filteredCategoryNames = this.getFilteredCategoryNames(attributeCategoryMap.keySet(), newMap, ctx);
        for (String attrCategoryName : filteredCategoryNames) {
            AttributeCategory attributeCategory = (AttributeCategory)newMap.get(attrCategoryName);
            PropertyPageDefinition page = this.createPageDefinition(attrCategoryName, attributeCategory);
            if (attrCategoryName.equals(GENERAL_ATTR_CATEGORY)) {
                result.add(0, page);
                continue;
            }
            result.add(page);
        }
        return result;
    }

    protected PropertyPageDefinition createPageDefinition(String attrCategoryName, AttributeCategory attributeCategory) {
        ContributionHandlerPropertyPageDefinition page = new ContributionHandlerPropertyPageDefinition(this.getComponentMeta(), attributeCategory);
        page.setName(attrCategoryName);
        this.setPageDirection(attributeCategory.getMode(), page);
        page.setDescription(attributeCategory.getDescription());
        return page;
    }

    private void putWrapInAttributes(Map<String, AttributeCategory> newMap) {
        AttributeCategory wrapAttributes = this.componentMeta.getWrapAttributes();
        if (wrapAttributes != null) {
            AttributeCategory attributeCategory = new AttributeCategory("", null, new Namespace[0]);
            AttributeGroup group = attributeCategory.newGroup("");
            group.setMode("");
            group.setId("");
            ChildManagingAttributeHelper hp = new ChildManagingAttributeHelper(wrapAttributes);
            group.add(hp);
            newMap.put(this.componentMeta.getDefinition().getName() + " Properties", attributeCategory);
        }
    }

    private void setPageDirection(String mode, PropertyPageDefinition page) {
        if (StringUtils.isNotBlank((String)mode)) {
            if (mode.equals("inbound")) {
                page.setDirection(EndpointDirection.INBOUND);
            } else if (mode.equals("outbound")) {
                page.setDirection(EndpointDirection.OUTBOUND);
            }
        }
    }

    private Collection<String> getFilteredCategoryNames(Collection<String> attributeCategoryNames, Map<String, AttributeCategory> newMap, AttributeContext ctx) {
        ArrayList result = Lists.newArrayList();
        for (String attrCategoryName : attributeCategoryNames) {
            AttributeCategory attributeCategory = newMap.get(attrCategoryName);
            if (ctx != null && ctx.getVersion() != null && (!attributeCategory.matches(ctx.getVersion()) || !ctx.getVersion().endsWith(";") && attributeCategory.isEEOnly()) || !attrCategoryName.equals(GENERAL_ATTR_CATEGORY) && attributeCategory.isEmpty()) continue;
            result.add(attrCategoryName);
        }
        return result;
    }

    private void replaceNullAttributeCategoryCaptions(Map<String, AttributeCategory> attrCategoriesMap) {
        for (String attrCategoryName : attrCategoriesMap.keySet()) {
            AttributeCategory attributeCategory = attrCategoriesMap.get(attrCategoryName);
            if (attributeCategory.getCaption() != null) continue;
            attributeCategory.setCaption(attrCategoryName);
        }
    }

    public AbstractComponentMeta getComponentMeta() {
        return this.componentMeta;
    }
}

