/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta.propertypage;

import java.util.Arrays;
import java.util.Optional;
import org.eclipse.swt.widgets.Composite;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.util.IMuleConfigurationProvider;
import org.mule.tooling.model.module.PropertyPageDefinition;
import org.mule.tooling.ui.modules.core.widgets.FixedAttributeCategoryProvider;
import org.mule.tooling.ui.modules.core.widgets.RecalcWhenConfigurerUtils;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeCategory;
import org.mule.tooling.ui.modules.core.widgets.meta.propertypage.PageWithControlsProvider;

public final class ContributionHandlerPropertyPageDefinition
extends PropertyPageDefinition {
    private final AbstractComponentMeta componentMeta;
    private final AttributeCategory attributes;

    public ContributionHandlerPropertyPageDefinition(AbstractComponentMeta componentMeta, AttributeCategory attributes) {
        this.componentMeta = componentMeta;
        this.attributes = attributes;
    }

    public Composite create(EndpointDirection direction, Object project, Composite scrolledComposite) throws Exception {
        IMuleProject muleProject = (IMuleProject)project;
        FixedAttributeCategoryProvider provider = new FixedAttributeCategoryProvider(this.attributes);
        Optional<IMuleConfigurationProvider> configProvider = Optional.ofNullable(this.getMuleConfigurationProvider());
        MuleConfiguration config = configProvider.map(x -> x.getMuleConfiguration()).orElse(null);
        PageWithControlsProvider pageWithControlsProvider = new PageWithControlsProvider(direction, muleProject, scrolledComposite, config, provider, this.componentMeta);
        this.configureRecalcWhen(pageWithControlsProvider);
        return pageWithControlsProvider;
    }

    private void configureRecalcWhen(PageWithControlsProvider pageWithControlsProvider) {
        RecalcWhenConfigurerUtils.configureRecalcWhenFor(Arrays.asList(pageWithControlsProvider));
    }
}

