/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta.creators;

import java.util.ArrayList;
import java.util.List;
import org.mule.tooling.core.module.Artifact;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;
import org.mule.tooling.ui.modules.core.widgets.meta.SetAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.Sort;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.AttributeCreator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SetAttributeCreator
implements AttributeCreator {
    @Override
    public AttributeHelper create(String name, String description, boolean required, String type, AttributeGroup gr, Element element, Artifact muleArtifact) {
        String sort = element.getAttribute("sort");
        Sort sortMethod = sort.equals("asc") ? Sort.ASC : (sort.equals("desc") ? Sort.DESC : Sort.NONE);
        String delimiterAttr = element.getAttribute("delimiter");
        String delimiter = delimiterAttr.length() == 0 ? "," : delimiterAttr;
        NodeList children = element.getChildNodes();
        List<EnumOption> options = this.createOptionsList(children);
        SetAttributeHelper setAttribute = gr.addSetHelper(name, element.getAttribute("caption"), required, description, options, sortMethod, delimiter);
        return setAttribute;
    }

    private List<EnumOption> createOptionsList(NodeList children) {
        ArrayList<EnumOption> options = new ArrayList<EnumOption>();
        int i = 0;
        while (i < children.getLength()) {
            Node childNode = children.item(i);
            if (childNode instanceof Element) {
                Element child = (Element)childNode;
                EnumOption option = this.createOption(child);
                options.add(option);
            }
            ++i;
        }
        return options;
    }

    private EnumOption createOption(Element child) {
        String value = child.getAttribute("value");
        String captionAttr = child.getAttribute("caption");
        String caption = captionAttr.length() != 0 ? captionAttr : value;
        return new EnumOption(value, caption);
    }
}

