/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta.creators;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.mule.tooling.core.module.Artifact;
import org.mule.tooling.ui.modules.core.metadata.multilevel.MultiTypeChooserOptionsCalculator;
import org.mule.tooling.ui.modules.core.widgets.editors.IOptionsCalculator;
import org.mule.tooling.ui.modules.core.widgets.editors.RefreshTypesAction;
import org.mule.tooling.ui.modules.core.widgets.editors.RefreshTypesButtonEnablement;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.MultiTypeChooserControlHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.AttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.EnumAttributeCreator;
import org.w3c.dom.Element;

public class MultiTypeChooserAttributeCreator
implements AttributeCreator {
    @Override
    public AttributeHelper create(String name, String description, boolean required, String type, AttributeGroup group, Element element, Artifact muleArtifact) {
        MultiTypeChooserControlHelper helper = new MultiTypeChooserControlHelper(name, element.getAttribute("editorClass"), muleArtifact);
        helper.setSeparator(element.getAttribute("keySeparator"));
        String captions = element.getAttribute("captions");
        List<String> captionList = Arrays.asList(captions.split(","));
        helper.setCaptions(captionList);
        helper.setAttributeName(element.getAttribute("name"));
        helper.setAlwaysFillSimple(true);
        this.createEnumHelpers(type, element, muleArtifact, helper, captionList);
        group.add(helper);
        return helper;
    }

    private void createEnumHelpers(String type, Element element, Artifact muleArtifact, MultiTypeChooserControlHelper helper, List<String> captionList) {
        EnumAttributeCreator enumAttributeCreator = new EnumAttributeCreator();
        ArrayList<AttributeHelper> helpers = new ArrayList<AttributeHelper>();
        int currentLevel = 0;
        for (String caption : captionList) {
            EnumHelper enumHelper = (EnumHelper)enumAttributeCreator.create(caption, caption, true, type, new AttributeGroup(""), element, muleArtifact);
            enumHelper.setCaption(caption);
            enumHelper.setAllowsCustom(true);
            enumHelper.setAcceptsEmptyValue(false);
            this.configureCalculator(helper, currentLevel, enumHelper);
            helpers.add(enumHelper);
            ++currentLevel;
        }
        if (!helpers.isEmpty()) {
            EnumHelper firstEnumHelper = (EnumHelper)helpers.get(0);
            String buttonImagePath = "/icons/refresh_types.gif";
            String key = "org.mule.tooling.ui.modules.core:" + buttonImagePath;
            ImageDescriptor imageDescriptor = JFaceResources.getImageRegistry().getDescriptor(key);
            if (imageDescriptor == null) {
                imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.mule.tooling.ui.modules.core", (String)buttonImagePath);
                JFaceResources.getImageRegistry().put(key, imageDescriptor);
            }
            firstEnumHelper.setButtonImageDescriptor(imageDescriptor);
            firstEnumHelper.setButtonDisabledImageDescriptor(ImageDescriptor.createWithFlags((ImageDescriptor)imageDescriptor, (int)1));
            firstEnumHelper.setButtonClass(RefreshTypesAction.class.getName());
            firstEnumHelper.setButtonEnablementClass(RefreshTypesButtonEnablement.class.getName());
        }
        helper.setInnerAttributeHelpers(helpers);
    }

    private void configureCalculator(MultiTypeChooserControlHelper helper, int currentLevel, EnumHelper enumHelper) {
        IOptionsCalculator optionsCalculator = enumHelper.getOptionsCalculator();
        if (!(optionsCalculator instanceof MultiTypeChooserOptionsCalculator)) {
            throw new RuntimeException(MessageFormat.format("Options calculator for multi-type-chooser must have [{0}] as calculator class.", MultiTypeChooserOptionsCalculator.class.getName()));
        }
        MultiTypeChooserOptionsCalculator calculator = (MultiTypeChooserOptionsCalculator)optionsCalculator;
        calculator.setSeparator(helper.getSeparator());
        calculator.setFilterLevel(currentLevel);
    }
}

