/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta.creators;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.mule.tooling.core.module.Artifact;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IContentProposalProviderFactory;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.GlobalRefAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.AttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.AttributeReader;
import org.w3c.dom.Element;

public class GlobalRefAttributeCreator
implements AttributeCreator {
    @Override
    public AttributeHelper create(String name, String decription, boolean required, String type, AttributeGroup gr, Element element, Artifact muleArtifact) {
        final GlobalRefAttributeHelper hp = new GlobalRefAttributeHelper(name, String.class, required);
        String additionalCheckbox = element.getAttribute("additionalCheckbox");
        if (additionalCheckbox != null && additionalCheckbox.length() > 0) {
            hp.setAdditionalCheckbox(additionalCheckbox);
        }
        hp.setCaption(element.getAttribute("caption"));
        String attribute = element.getAttribute("requiredType");
        if (attribute.length() > 0) {
            hp.setRequiredType(attribute);
        }
        String allowSubtypes = element.getAttribute("allowSubTypes");
        hp.setAllowsSubTypes(Boolean.valueOf(allowSubtypes));
        String attrName = element.getAttribute("attrName");
        if (attrName != null && attrName.length() > 0) {
            hp.setAttrName(attrName);
        }
        hp.setDescription(decription);
        hp.setValidator(new AttributeReader.XMLAwareGlobalRefValidator(hp));
        hp.setProposalProvider(new IContentProposalProviderFactory(){

            @Override
            public int getProposalAcceptanceStyle() {
                return 2;
            }

            @Override
            public IContentProposalProvider getContentProposalProvider(AttributeContext context) {
                MuleConfiguration muleConfiguration = context.getMuleConfiguration();
                List globalEntries = muleConfiguration.getGlobalEntries();
                final ArrayList<String> strs = new ArrayList<String>();
                for (IMessageFlowEntity value : globalEntries) {
                    PropertyCollectionMap propertyCollectionMap;
                    String property;
                    if (!(value instanceof GlobalElement) || (property = (propertyCollectionMap = new PropertyCollectionMap(((GlobalElement)value).getProperties())).getProperty(hp.getAttrName(), null)) == null) continue;
                    strs.add(property);
                }
                return new IContentProposalProvider(){

                    public IContentProposal[] getProposals(String contents, int position) {
                        ArrayList<ContentProposal> pm = new ArrayList<ContentProposal>();
                        for (String s : strs) {
                            if (!s.startsWith(contents)) continue;
                            pm.add(new ContentProposal(s, ""));
                        }
                        return pm.toArray(new IContentProposal[pm.size()]);
                    }
                };
            }
        });
        gr.add(hp);
        GlobalRefAttributeHelper addStringHelper = hp;
        addStringHelper.setHyperLinkProvider(new AttributeReader.GlobalRefHyperlinkProvider());
        addStringHelper.setType(type);
        addStringHelper.setImage(AttributeReader.idAtr);
        return addStringHelper;
    }
}

