/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta.creators;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.contribution.ErrorModel;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.ErrorTypesProvider;
import org.mule.tooling.ui.modules.core.widgets.editors.IOptionsCalculator;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;

public class ErrorTypeOptionsCalculator
implements IOptionsCalculator {
    @Override
    public List<EnumOption> options(AbstractFieldEditor ed, IMessageFlowNode node) {
        IMuleProject muleProject = MuleCorePlugin.getDesignContext().getMuleProject();
        Set<ErrorModel> errorTypes = new ErrorTypesProvider(muleProject).getAllErrorModels();
        return errorTypes.stream().map(e -> {
            String type = e.getType();
            String namespace = e.getNamespace();
            if (namespace.equals("CORE") || namespace.equals("MULE")) {
                return new EnumOption(type);
            }
            return new EnumOption(namespace + ":" + type);
        }).distinct().collect(Collectors.toList());
    }
}

