/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta.creators;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.mule.tooling.core.module.Artifact;
import org.mule.tooling.ui.modules.core.widgets.IValidator;
import org.mule.tooling.ui.modules.core.widgets.editors.IElementBasedInitializable;
import org.mule.tooling.ui.modules.core.widgets.editors.IOptionsCalculator;
import org.mule.tooling.ui.modules.core.widgets.editors.IValueCalculator;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.AttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.AttributeReader;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.IEnumOptionsProvider;
import org.mule.tooling.utils.LazyValue;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EnumAttributeCreator
implements AttributeCreator {
    @Override
    public AttributeHelper create(String name, String decription, boolean required, String type, AttributeGroup gr, Element element, Artifact muleArtifact) {
        IOptionsCalculator calculator;
        EnumElementWrapper enumElement = new EnumElementWrapper(element);
        List<EnumOption> options = this.createEnumOptions(enumElement);
        String defaultValue = enumElement.defaultValue;
        boolean isAutoSort = enumElement.autoSort;
        boolean removeEmptyOption = enumElement.removeEmptyOption;
        EnumHelper enumHelper = (EnumHelper)gr.addEnumHelper(name, enumElement.caption, required, decription, defaultValue, isAutoSort, options, false, false, removeEmptyOption);
        Optional<IOptionsCalculator> optionsCalculator = enumElement.optionsCalculator();
        if (optionsCalculator.isPresent() && (calculator = (IOptionsCalculator)optionsCalculator.get()) instanceof IElementBasedInitializable) {
            ((IElementBasedInitializable)((Object)calculator)).init(element);
        }
        enumHelper.setOptionsCalculator(optionsCalculator);
        enumHelper.setValueCalculator(enumElement.valueCalculator());
        enumHelper.setProviderName(element.getAttribute("providerName"));
        enumHelper.setImage(required ? AttributeReader.stringReqAtr : AttributeReader.stringAtr);
        enumHelper.setAllowsCustom(Boolean.parseBoolean(element.getAttribute("allowsCustom")));
        enumHelper.setDisableButton(Boolean.parseBoolean(element.getAttribute("disableButton")));
        enumHelper.setAsRadioGroup(Boolean.parseBoolean(element.getAttribute("asRadioGroup")));
        enumHelper.setHorizontal(Boolean.parseBoolean(element.getAttribute("horizontal")));
        enumHelper.setUseSelectionDialog(Boolean.parseBoolean(element.getAttribute("useSelectionDialog")));
        String buttonClass = element.getAttribute("buttonClass");
        String buttonCaption = element.getAttribute("buttonCaption");
        String buttonTooltip = element.getAttribute("buttonTooltip");
        String buttonEnablementClass = element.getAttribute("buttonEnablementClass");
        String buttonImagePath = element.getAttribute("buttonImage");
        String prerequisites = element.getAttribute("prerequisites");
        if (StringUtils.isNotBlank((String)prerequisites)) {
            enumHelper.setPrerequisites(Arrays.asList(prerequisites.split(",")));
        } else {
            enumHelper.setPrerequisites(Collections.emptyList());
        }
        String keyParts = element.getAttribute("keyParts");
        if (StringUtils.isNotBlank((String)keyParts)) {
            enumHelper.setKeyParts(Arrays.asList(keyParts.split(",")));
        } else {
            enumHelper.setKeyParts(Collections.emptyList());
        }
        if (!StringUtils.isBlank((String)buttonCaption)) {
            enumHelper.setButtonCaption(buttonCaption);
        }
        if (!StringUtils.isBlank((String)buttonClass)) {
            enumHelper.setButtonClass(buttonClass);
        }
        if (!StringUtils.isBlank((String)buttonTooltip)) {
            enumHelper.setButtonTooltip(buttonTooltip);
        }
        if (!StringUtils.isBlank((String)buttonEnablementClass)) {
            enumHelper.setButtonEnablementClass(buttonEnablementClass);
        }
        if (!StringUtils.isBlank((String)buttonImagePath)) {
            this.configureImage(enumHelper, buttonImagePath);
        }
        enumHelper.setTypeChooser(Boolean.parseBoolean(element.getAttribute("isTypeChooser")));
        enumHelper.setChildElementChooser(Boolean.parseBoolean(element.getAttribute("isChildElementChooser")));
        enumHelper.setAffects(element.getAttribute("affects"));
        enumHelper.setValidator(enumElement.customValidator());
        return enumHelper;
    }

    public void configureImage(EnumHelper enumHelper, String buttonImagePath) {
        LazyValue buttonImage = new LazyValue(() -> {
            String key = "org.mule.tooling.ui.modules.core:" + buttonImagePath;
            ImageDescriptor imageDescriptor = JFaceResources.getImageRegistry().getDescriptor(key);
            if (imageDescriptor == null) {
                imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.mule.tooling.ui.modules.core", (String)buttonImagePath);
                JFaceResources.getImageRegistry().put(key, imageDescriptor);
            }
            return imageDescriptor;
        });
        LazyValue disabledButtonImage = new LazyValue(() -> {
            ImageDescriptor buttonImageDescriptor = enumHelper.getButtonImageDescriptor();
            if (buttonImageDescriptor == null) {
                throw new NullPointerException("The configured icon could not be retrieved");
            }
            ImageDescriptor disabled = ImageDescriptor.createWithFlags((ImageDescriptor)buttonImageDescriptor, (int)1);
            return disabled;
        });
        enumHelper.setLazyImageDescriptor((LazyValue<ImageDescriptor>)buttonImage);
        enumHelper.setLazyDisabledImageDescriptor((LazyValue<ImageDescriptor>)disabledButtonImage);
    }

    private List<EnumOption> createEnumOptions(EnumElementWrapper enumElement) {
        ArrayList optionsToReturn = Lists.newArrayList();
        IEnumOptionsProvider optionsProvider = (IEnumOptionsProvider)enumElement.optionsProvider().or((Object)new NullOptionsProvider());
        optionsToReturn.addAll(optionsProvider.getOptions());
        List<Element> optionElements = enumElement.getChildNodes();
        for (Element optionElement : optionElements) {
            String value = optionElement.getAttribute("value");
            String caption = optionElement.getAttribute("caption");
            EnumOption option = new EnumOption(value, caption, enumElement.defaultValue);
            option.setVersions(optionElement.getAttribute("versions"));
            optionsToReturn.add(option);
        }
        return optionsToReturn;
    }

    public static <T> T newInstance(String className) {
        try {
            Object newInstance = Class.forName(className).newInstance();
            return (T)newInstance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> Optional<T> getClassForAttr(Element element, String attr) {
        String className = element.getAttribute(attr);
        if (className.length() > 0) {
            T newInstance = EnumAttributeCreator.newInstance(className);
            return Optional.of(newInstance);
        }
        return Optional.absent();
    }

    private final class EnumElementWrapper {
        private final Element element;
        private final String defaultValue;
        private final String caption;
        private final boolean autoSort;
        private final boolean removeEmptyOption;

        public EnumElementWrapper(Element element) {
            this.element = element;
            this.defaultValue = element.getAttribute("defaultValue");
            this.caption = element.getAttribute("caption");
            String autoSortAttr = element.getAttribute("autoSort");
            this.autoSort = autoSortAttr.isEmpty() ? false : Boolean.parseBoolean(autoSortAttr);
            String removeEmptyOptionAttr = element.getAttribute("removeEmptyOption");
            this.removeEmptyOption = removeEmptyOptionAttr.isEmpty() ? false : Boolean.parseBoolean(removeEmptyOptionAttr);
        }

        public Optional<IOptionsCalculator> optionsCalculator() {
            return EnumAttributeCreator.this.getClassForAttr(this.element, "class");
        }

        public Optional<IValueCalculator> valueCalculator() {
            return EnumAttributeCreator.this.getClassForAttr(this.element, "valueCalculator");
        }

        public Optional<IValidator> customValidator() {
            return EnumAttributeCreator.this.getClassForAttr(this.element, "customValidator");
        }

        public Optional<IEnumOptionsProvider> optionsProvider() {
            return EnumAttributeCreator.this.getClassForAttr(this.element, "optionsProvider");
        }

        public List<Element> getChildNodes() {
            return this.toElemList(this.element.getChildNodes());
        }

        private List<Element> toElemList(NodeList nodeList) {
            ArrayList<Element> col = new ArrayList<Element>();
            int a = 0;
            while (a < nodeList.getLength()) {
                Node node = nodeList.item(a);
                if (node instanceof Element) {
                    Element el = (Element)node;
                    col.add(el);
                }
                ++a;
            }
            return col;
        }
    }

    private static final class NullOptionsProvider
    implements IEnumOptionsProvider {
        private NullOptionsProvider() {
        }

        @Override
        public List<EnumOption> getOptions() {
            return Lists.newArrayList();
        }
    }
}

