/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta.creators;

import java.util.ArrayList;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.mule.tooling.core.module.Artifact;
import org.mule.tooling.ui.modules.core.widgets.editors.IValueCalculator;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.DynamicEditorsAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.AttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.AttributeReader;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.MuleVersionRange;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DynamicEditorAttributeCreator
implements AttributeCreator {
    @Override
    public AttributeHelper create(String name, String decription, boolean required, String type, AttributeGroup gr, Element element, Artifact muleArtifact) {
        MuleVersionRange defaultVersion = new MuleVersionRange(new VersionRange("[1.0.0,99.0.0]"), true);
        NodeList elementsByTagName = element.getElementsByTagName("editor-ref");
        String removeEmptyOptionAttr = element.getAttribute("removeEmptyOption");
        boolean removeEmptyOption = removeEmptyOptionAttr.isEmpty() ? false : Boolean.parseBoolean(removeEmptyOptionAttr);
        ArrayList<DynamicEditorsAttributeHelper.NodeOption> modes = new ArrayList<DynamicEditorsAttributeHelper.NodeOption>();
        if (!removeEmptyOption) {
            modes.add(DynamicEditorsAttributeHelper.EMPTY_OPTION);
        }
        int a = 0;
        while (a < elementsByTagName.getLength()) {
            Element el = (Element)elementsByTagName.item(a);
            String elementId = el.getAttribute("id");
            String elementName = el.getAttribute("name");
            modes.add(new DynamicEditorsAttributeHelper.NodeOption(elementName, elementId, AttributeReader.parseVersionsAttribute(el, defaultVersion)));
            ++a;
        }
        DynamicEditorsAttributeHelper ms = new DynamicEditorsAttributeHelper(name, element.getAttribute("caption"), modes);
        ms.setAlwaysCombo(true);
        String defaultValue = element.getAttribute("defaultValue");
        if (defaultValue.length() > 0) {
            ms.setDefaultValue(defaultValue);
        }
        String isHorizontal = element.getAttribute("horizontal");
        ms.setHorizontal(Boolean.parseBoolean(isHorizontal));
        String calculatorName = element.getAttribute("class");
        if (calculatorName.length() > 0) {
            try {
                IValueCalculator newInstance = (IValueCalculator)Class.forName(calculatorName).newInstance();
                ms.setCalculator(newInstance);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ms.setCaption(element.getAttribute("caption"));
        ms.setDescription(decription);
        gr.add(ms);
        return ms;
    }
}

