/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta.creators;

import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModelObject;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ElementModel;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ITypeHyperlinkProvider;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentAttributeNode;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentElementNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ITextEditor;
import org.mule.tooling.core.module.Artifact;
import org.mule.tooling.core.utils.ExpressionUtils;
import org.mule.tooling.core.xml.XmlFactoryUtils;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.GlobalUnknown;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.internal.enablement.EnablementParser;
import org.mule.tooling.ui.modules.core.validation.MuleConfigurationValidator;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.ExpressionValuePersistence;
import org.mule.tooling.ui.modules.core.widgets.IValidator;
import org.mule.tooling.ui.modules.core.widgets.IValidatorWithSeverity;
import org.mule.tooling.ui.modules.core.widgets.IValueConverter;
import org.mule.tooling.ui.modules.core.widgets.editors.EnablementLoadValueModifier;
import org.mule.tooling.ui.modules.core.widgets.editors.GlobalRefEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.ILoadedValueModifier;
import org.mule.tooling.ui.modules.core.widgets.editors.IModeUpdater;
import org.mule.tooling.ui.modules.core.widgets.editors.TextViewerCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeCategory;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelperComponentManager;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;
import org.mule.tooling.ui.modules.core.widgets.meta.GlobalRefAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.IEditorSelectionListener;
import org.mule.tooling.ui.modules.core.widgets.meta.IHasListener;
import org.mule.tooling.ui.modules.core.widgets.meta.NameEditorsStackContainer;
import org.mule.tooling.ui.modules.core.widgets.meta.SpecialValuePersistence;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.AttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.AttributeHelperComponentCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.BooleanAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.BooleanListAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.ButtonAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.ChildControllerAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.ChildElementAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.ClassNameAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.ContentAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.CustomAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.DWScriptAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.DateTimeAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.DoubleAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.DummyAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.DynamicAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.DynamicEditorAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.EncodingAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.EnumAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.FileAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.FlowRefAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.GlobalRefAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.GroupTabsAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.HorizontalAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.IntegerAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.LabelAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.ListAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.LongAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.MuleVersionRange;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.MultiTypeChooserAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.MultiWayAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.NameAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.PasswordAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.PathAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.RadioAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.RadioBooleanAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.RegexAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.RequiredElementsAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.ResourceAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.SeparatorAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.SetAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.StringAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.SwitchAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.SwitchCaseAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.TextAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.TimeAttributeCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.UrlAttributeCreator;
import org.mule.tooling.ui.modules.internal.meta.TypeChooserComponent;
import org.mule.tooling.utils.SilentRunner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AttributeReader {
    private static final String ATTR_ACCEPTS_EMPTY_VALUE = "acceptsEmptyValue";
    private static final String ATTR_DEPRECATED_VERSIONS = "deprecatedVersions";
    private static final String ATTR_DEPRECATED_MESSAGE = "deprecatedMessage";
    private static final String ATTR_WARNING_MESSAGE = "warningMessage";
    private static final String ATTR_REQUIRED_FOR_DATA_SENSE = "requiredForDataSense";
    public static final Image booleanAtr = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.mule.tooling.ui.modules.core", (String)"icons/attrs/att_boolean_obj.gif").createImage();
    public static final Image stringAtr = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.mule.tooling.ui.modules.core", (String)"icons/attrs/att_string_obj.gif").createImage();
    public static final Image stringReqAtr = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.mule.tooling.ui.modules.core", (String)"icons/attrs/att_req_obj.gif").createImage();
    public static final Image idAtr = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.mule.tooling.ui.modules.core", (String)"icons/attrs/att_id_obj.gif").createImage();
    public static final Image fileAtr = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.mule.tooling.ui.modules.core", (String)"icons/attrs/att_file_obj.gif").createImage();
    public static final Image classAtr = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.mule.tooling.ui.modules.core", (String)"icons/attrs/att_class_obj.gif").createImage();
    public static final Image implAtr = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.mule.tooling.ui.modules.core", (String)"icons/attrs/att_impl_obj.gif").createImage();
    public static final Image uriAtr = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.mule.tooling.ui.modules.core", (String)"icons/attrs/att_uri_obj.gif").createImage();
    public static final String FILE_DOES_NOT_EXIST_MESSAGE = "Path does not exist";
    public static List<NameEditorsStackContainer> currentNameEditorsList = new LinkedList<NameEditorsStackContainer>();
    private static HashMap<String, AttributeCreator> creators = new HashMap();
    private static HashMap<String, AttributeHelperComponentCreator> componentsCreators = new HashMap();
    private static ArrayList<EnumOption> encodingOptions;

    static {
        ArrayList<EnumOption> options = new ArrayList<EnumOption>();
        URL resource = Platform.getBundle((String)"org.mule.tooling.utils.epl").getResource("charset.properties");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream openStream = resource.openStream();){
                Properties ps = new Properties();
                ps.load(openStream);
                int a = 0;
                while (a < Integer.parseInt(ps.getProperty("totalnumber"))) {
                    String label = ps.getProperty("codeset." + a + ".label");
                    String iana = ps.getProperty("codeset." + a + ".iana");
                    options.add(new EnumOption(iana, label));
                    ++a;
                }
                encodingOptions = options;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        creators.put("string", new StringAttributeCreator());
        creators.put("dummy", new DummyAttributeCreator());
        creators.put("separator", new SeparatorAttributeCreator());
        creators.put("button", new ButtonAttributeCreator());
        creators.put("switch", new SwitchAttributeCreator());
        creators.put("horizontal", new HorizontalAttributeCreator());
        creators.put("switchCase", new SwitchCaseAttributeCreator());
        creators.put("groupTabs", new GroupTabsAttributeCreator());
        creators.put("multi-way", new MultiWayAttributeCreator());
        creators.put("password", new PasswordAttributeCreator());
        creators.put("text", new TextAttributeCreator());
        creators.put("dynamicEditors", new DynamicEditorAttributeCreator());
        creators.put("dw-script", new DWScriptAttributeCreator());
        creators.put("globalRef", new GlobalRefAttributeCreator());
        creators.put("list", new ListAttributeCreator());
        creators.put("childElement", new ChildElementAttributeCreator());
        creators.put("childController", new ChildControllerAttributeCreator());
        creators.put("regexp", new RegexAttributeCreator());
        creators.put("label", new LabelAttributeCreator());
        creators.put("enum", new EnumAttributeCreator());
        creators.put("booleanList", new BooleanListAttributeCreator());
        creators.put("set", new SetAttributeCreator());
        creators.put("content", new ContentAttributeCreator());
        creators.put("radio", new RadioAttributeCreator());
        creators.put("encoding", new EncodingAttributeCreator());
        creators.put("boolean", new BooleanAttributeCreator());
        creators.put("flowRef", new FlowRefAttributeCreator());
        creators.put("radioBoolean", new RadioBooleanAttributeCreator());
        creators.put("name", new NameAttributeCreator());
        creators.put("custom", new CustomAttributeCreator());
        creators.put("dynamic", new DynamicAttributeCreator());
        creators.put("classname", new ClassNameAttributeCreator());
        creators.put("integer", new IntegerAttributeCreator());
        creators.put("datetime", new DateTimeAttributeCreator());
        creators.put("time", new TimeAttributeCreator());
        creators.put("long", new LongAttributeCreator());
        creators.put("double", new DoubleAttributeCreator());
        creators.put("url", new UrlAttributeCreator());
        creators.put("path", new PathAttributeCreator());
        creators.put("file", new FileAttributeCreator());
        creators.put("resource", new ResourceAttributeCreator());
        creators.put("element-multi-type-chooser", new MultiTypeChooserAttributeCreator());
        creators.put("require", new RequiredElementsAttributeCreator());
        AttributeReader.processCreatorExtensions();
        AttributeReader.processEditorComponentCreators();
    }

    public static void readAttributes(AttributeCategory atrs, InputStream stream, String mode, Artifact muleArtifact) {
        try {
            Document parse = XmlFactoryUtils.createSecureDocumentBuilder().parse(stream);
            NodeList ls = parse.getDocumentElement().getChildNodes();
            AttributeReader.readAttributes(atrs, mode, ls, muleArtifact);
        }
        catch (IOException | SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void processEditorComponentCreators() {
        AttributeHelperComponentManager.values().forEach(x -> {
            AttributeHelperComponentCreator attributeHelperComponentCreator = componentsCreators.put(x.getName(), x.getAttributeHelperComponentCreator());
        });
    }

    private static void processCreatorExtensions() {
        IConfigurationElement[] configurationElements;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.mule.tooling.ui.modules.core.attributeCreator");
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            final IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            final String name = configurationElement.getAttribute("name");
            SilentRunner.run((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    creators.put(name, (AttributeCreator)configurationElement.createExecutableExtension("class"));
                    return null;
                }
            }, null);
            ++n2;
        }
    }

    public static void readAttributes(AttributeCategory atrs, String mode, NodeList ls, Artifact muleArtifact) {
        HashMap<String, AttributeGroup> groups = new HashMap<String, AttributeGroup>();
        int a = 0;
        while (a < ls.getLength()) {
            Node n = ls.item(a);
            AttributeReader.parseAttributes(atrs, mode, groups, n, muleArtifact);
            ++a;
        }
    }

    public static void readAttributes(AttributeCategory atrs, String mode, Node node, Artifact muleArtifact) {
        HashMap<String, AttributeGroup> groups = new HashMap<String, AttributeGroup>();
        AttributeReader.parseAttributes(atrs, mode, groups, node, muleArtifact);
    }

    private static void parseAttributes(AttributeCategory atrs, String mode, HashMap<String, AttributeGroup> groups, Node n, Artifact muleArtifact) {
        if (n instanceof Element) {
            Element el = (Element)n;
            if (el.getNodeName().equals("group")) {
                MuleVersionRange versionRange;
                AttributeGroup newGroup = atrs.newGroup(el.getAttribute("caption"));
                newGroup.setId(el.getAttribute("id"));
                String attribute = el.getAttribute("topAnchor");
                if (attribute.length() > 0) {
                    newGroup.setTopAnchor(attribute);
                }
                if ((attribute = el.getAttribute("description")).length() > 0) {
                    newGroup.setDescription(attribute);
                }
                if ((attribute = el.getAttribute("collapsable")).length() > 0) {
                    newGroup.setCollapsable(Boolean.parseBoolean(attribute));
                }
                if ((attribute = el.getAttribute("collapsed")).length() > 0) {
                    newGroup.setCollapsed(Boolean.parseBoolean(attribute));
                }
                if ((attribute = el.getAttribute("bottomAnchor")).length() > 0) {
                    newGroup.setBottomAnchor(attribute);
                }
                if ((versionRange = AttributeReader.parseVersionsAttribute(el)) != null) {
                    newGroup.setRange(versionRange);
                }
                groups.put(newGroup.getId(), newGroup);
                newGroup.setMode(el.getAttribute("mode"));
                newGroup.setControlledBy(el.getAttribute("controlled"));
                AttributeReader.readAttrs(el.getChildNodes(), newGroup, mode, muleArtifact);
            } else {
                AttributeGroup emptyGroup = atrs.getGroup("");
                emptyGroup.setId("");
                emptyGroup.setMode("");
                groups.put("", emptyGroup);
                AttributeReader.readAttrs(el, emptyGroup, mode, muleArtifact);
            }
        }
    }

    private static void readAttrs(Node node, AttributeGroup group, String mode, Artifact muleArtifact) {
        AttributeReader.parseAttr(group, mode, node, muleArtifact);
    }

    private static void readAttrs(NodeList ls, AttributeGroup group, String mode, Artifact muleArtifact) {
        int a = 0;
        while (a < ls.getLength()) {
            Node n = ls.item(a);
            AttributeReader.parseAttr(group, mode, n, muleArtifact);
            ++a;
        }
    }

    public static void parseAttr(AttributeGroup group, String mode, Node node, Artifact muleArtifact) {
        String isTextArea;
        String fillWhenNotEmpty;
        MuleVersionRange versions;
        String enablementCondition;
        String loadedValueModifierClassName;
        String alternativeTo;
        String updater;
        String customValidator;
        String appearsAsRequired;
        String nestedName;
        boolean isToElement;
        String selHandler;
        String customTextViewerCreator;
        String valuePersistence;
        String requiresExpression;
        String supportsExpressions;
        String priority;
        String groupLabel;
        String groupIn;
        String bottomAnchor;
        String topAnchor;
        String persistenceTransformer;
        String placeholder;
        String saveAs;
        String alwaysFillSimple;
        String alwaysFill;
        String transient_;
        String tiny;
        String recalcWhen;
        String revalidateOnEnablementChange;
        String controlled;
        String indented;
        String unchangeable;
        String visible;
        String singeLineForExpressions;
        String warningMessage;
        String deprecatedMessage;
        if (!(node instanceof Element)) {
            return;
        }
        Element el = (Element)node;
        String theMode = el.getAttribute("mode");
        if (mode != null && theMode.length() > 0 && !theMode.equals(mode)) {
            return;
        }
        String name = el.getAttribute("name");
        String description = el.getAttribute("description");
        boolean required = Boolean.parseBoolean(el.getAttribute("required"));
        String type = el.getNodeName();
        AttributeCreator creator = creators.get(type);
        if (creator == null) {
            return;
        }
        AttributeHelper helper = creator.create(name, description, required, type, group, el, muleArtifact);
        if (required) {
            boolean acceptsEmptyValue = Boolean.parseBoolean(el.getAttribute(ATTR_ACCEPTS_EMPTY_VALUE));
            helper.setAcceptsEmptyValue(acceptsEmptyValue);
        }
        helper.setMode(theMode);
        String attribute = el.getAttribute(ATTR_DEPRECATED_VERSIONS);
        if (attribute != null && attribute.length() > 0) {
            if (attribute.contains("EE")) {
                attribute = attribute.replace(".EE", ";EE");
            }
            helper.setDeprecatedRange(new VersionRange(attribute));
        }
        if (StringUtils.isNotBlank((String)(deprecatedMessage = el.getAttribute(ATTR_DEPRECATED_MESSAGE)))) {
            helper.setDeprecatedMessage(deprecatedMessage);
        }
        if (StringUtils.isNotBlank((String)(warningMessage = el.getAttribute(ATTR_WARNING_MESSAGE)))) {
            helper.setWarningMessage(warningMessage);
        }
        if ((singeLineForExpressions = el.getAttribute("singeLineForExpressions")).length() > 0) {
            helper.setSingleLineExp(Boolean.parseBoolean(singeLineForExpressions));
        }
        if ((visible = el.getAttribute("visibleInDialog")).length() > 0) {
            helper.setVisibleInDialog(Boolean.parseBoolean(visible));
        }
        if ((unchangeable = el.getAttribute("unchangeable")).length() > 0) {
            helper.setUnchangeable(Boolean.parseBoolean(unchangeable));
        }
        String spanStr = el.getAttribute("span");
        int span = 0;
        if (spanStr != null && spanStr.length() > 0) {
            try {
                span = Integer.parseInt(spanStr);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (span != 0) {
            helper.setSpan(span);
        }
        if ((indented = el.getAttribute("indented")).length() > 0) {
            helper.setIndented(Boolean.parseBoolean(indented));
        }
        String indentationStr = el.getAttribute("indentation");
        int indentation = 0;
        if (indentationStr != null && indentationStr.length() > 0) {
            try {
                indentation = Integer.parseInt(indentationStr);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (indentation != 0) {
            helper.setIndentation(indentation);
        }
        boolean captionIsUp = Boolean.parseBoolean(el.getAttribute("captionIsUp"));
        helper.setCaptionIsUp(captionIsUp);
        String mflow = el.getAttribute("storeIndependently");
        if (mflow.length() > 0) {
            helper.setStoreInMFlow(Boolean.parseBoolean(mflow));
            helper.setId("auxiliary;meta" + helper.getId());
        }
        if ((controlled = el.getAttribute("controlled")).length() > 0) {
            helper.setRequiredPropertyId(controlled);
        }
        if ((revalidateOnEnablementChange = el.getAttribute("revalidateOnEnablementChange")).length() > 0) {
            helper.setRevalidateOnEnablementChange(Boolean.parseBoolean(revalidateOnEnablementChange));
        }
        if ((recalcWhen = el.getAttribute("recalcWhen")).length() > 0) {
            helper.setRecalcWhen(recalcWhen);
        }
        if ((tiny = el.getAttribute("tiny")).length() > 0) {
            helper.setTiny(Boolean.parseBoolean(tiny));
        }
        if ((transient_ = el.getAttribute("transient")).length() > 0) {
            helper.setTransient(Boolean.parseBoolean(transient_));
        }
        if (Boolean.parseBoolean(el.getAttribute("hiddenForUser"))) {
            helper.setHiddenForUser(true);
        }
        if ((alwaysFill = el.getAttribute("alwaysFill")).length() > 0) {
            helper.setAlwaysFill(Boolean.parseBoolean(alwaysFill));
        }
        if ((alwaysFillSimple = el.getAttribute("alwaysFillSimple")).length() > 0) {
            helper.setAlwaysFillSimple(Boolean.parseBoolean(alwaysFillSimple));
        }
        if ((saveAs = el.getAttribute("saveAs")).length() > 0) {
            helper.setSaveAs(saveAs);
        }
        if ((placeholder = el.getAttribute("placeholder")).length() > 0) {
            helper.setPlaceholder(placeholder);
        }
        if ((persistenceTransformer = el.getAttribute("persistenceTransformer")) != null && persistenceTransformer.length() > 0) {
            if (persistenceTransformer.equals("DefaultDynamicEditorPersistenceTransformer")) {
                String editorsIds = el.getAttribute("editorsIds");
                Class[] types = new Class[]{String.class, String.class};
                Object[] args = new Object[]{name, editorsIds};
                helper.setPersistenceTransformer("org.mule.tooling.ui.modules.core.widgets.editors.dynamic.DefaultDynamicEditorPersistenceTransformer", types, args);
            } else if (persistenceTransformer.equals("EnableIfElementExists")) {
                Class[] types = new Class[]{String.class};
                Object[] args = new Object[]{name};
                helper.setPersistenceTransformer("org.mule.tooling.ui.modules.core.widgets.meta.EnableIfElementExists", types, args);
            } else if (persistenceTransformer.startsWith("EnableIfAttributeExists ")) {
                int start = "EnableIfAttributeExists ".length();
                attrName = persistenceTransformer.substring(start);
                types = new Class[]{String.class, String.class};
                args = new Object[]{name, attrName};
                helper.setPersistenceTransformer("org.mule.tooling.ui.modules.core.widgets.meta.EnableIfAttributeExists", types, args);
            } else if (persistenceTransformer.startsWith("JoinWith ")) {
                int start = "JoinWith ".length();
                attrName = persistenceTransformer.substring(start);
                types = new Class[]{String.class, String.class};
                args = new Object[]{name, attrName};
                helper.setPersistenceTransformer("org.mule.tooling.ui.modules.core.widgets.meta.JoiningPersistenceTransformer", types, args);
            } else {
                helper.setPersistenceTransformer(persistenceTransformer);
            }
        }
        if ((topAnchor = el.getAttribute("topAnchor")).length() > 0) {
            helper.setTopAnchor(topAnchor);
        }
        if ((bottomAnchor = el.getAttribute("bottomAnchor")).length() > 0) {
            helper.setBottomAnchor(bottomAnchor);
        }
        if ((groupIn = el.getAttribute("groupIn")).length() > 0) {
            helper.setGroupIn(groupIn);
        }
        if ((groupLabel = el.getAttribute("groupLabel")).length() > 0) {
            helper.setGroupLabel(groupLabel);
        }
        if ((priority = el.getAttribute("priority")).length() > 0) {
            try {
                helper.setPriority(Integer.parseInt(priority));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((supportsExpressions = el.getAttribute("supportsExpressions")).length() > 0) {
            helper.setSupportsExpressions(Boolean.parseBoolean(supportsExpressions));
        }
        if ((requiresExpression = el.getAttribute("requiresExpression")).length() > 0) {
            helper.setRequiresExpression(Boolean.parseBoolean(requiresExpression));
        }
        if ((valuePersistence = el.getAttribute("valuePersistence")).length() > 0) {
            IValueConverter pers = null;
            pers = valuePersistence.equals("expression") ? new ExpressionValuePersistence(helper.getId()) : AttributeReader.createInstance(valuePersistence, IValueConverter.class);
            helper.setValuePersistence(pers);
        }
        if (StringUtils.isNotBlank((String)(customTextViewerCreator = el.getAttribute("customTextViewerCreator")))) {
            helper.setCustomTextViewerCreator(AttributeReader.createInstance(customTextViewerCreator, TextViewerCreator.class));
        }
        if ((selHandler = el.getAttribute("changeHandler")).length() > 0 && helper instanceof IHasListener) {
            IEditorSelectionListener pers = AttributeReader.createInstance(selHandler, IEditorSelectionListener.class);
            ((IHasListener)((Object)helper)).setListener(pers);
        }
        helper.setAttribute(!(isToElement = Boolean.parseBoolean(el.getAttribute("isToElement"))));
        String attrXmlOrder = el.getAttribute("xmlOrder");
        if (StringUtils.isNotEmpty((String)attrXmlOrder)) {
            helper.setXmlOrder(Integer.parseInt(attrXmlOrder));
        }
        if (Boolean.parseBoolean(el.getAttribute("showOnlyInInbound"))) {
            helper.setShowOnlyInInbound(true);
        }
        if (Boolean.parseBoolean(el.getAttribute("showOnlyInOutbound"))) {
            helper.setShowOnlyInOutbound(true);
        }
        if ((nestedName = el.getAttribute("nestedName")).length() > 0) {
            helper.setNestedTagName(nestedName);
        }
        helper.setCData(Boolean.parseBoolean(el.getAttribute("wrapWithCDATA")));
        String canonicalPath = el.getAttribute("canonicalPath");
        if (canonicalPath.length() > 0) {
            helper.setCanonicalPath(canonicalPath);
        }
        if ((appearsAsRequired = el.getAttribute("appearsAsRequired")).length() > 0) {
            helper.setAppearsAsRequired(Boolean.parseBoolean(appearsAsRequired));
        }
        if ((customValidator = el.getAttribute("customValidator")).length() > 0) {
            helper.setValidator(AttributeReader.createInstance(customValidator, IValidator.class));
        }
        if ((updater = el.getAttribute("updater")).length() > 0) {
            helper.setUpdater(AttributeReader.createInstance(updater, IModeUpdater.class));
        }
        if ((alternativeTo = el.getAttribute("alternativeTo")).length() > 0) {
            String[] stringArray = alternativeTo.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String alternative = stringArray[n2];
                if (alternative.length() > 0) {
                    helper.addAlternative(alternative);
                }
                ++n2;
            }
        }
        if ((loadedValueModifierClassName = el.getAttribute("loadedValueModifier")).length() > 0) {
            ILoadedValueModifier loadedValueModifier = AttributeReader.createInstance(loadedValueModifierClassName, ILoadedValueModifier.class);
            helper.setLoadedValueModifier(loadedValueModifier);
        }
        if ((enablementCondition = el.getAttribute("enabledWhen")).length() > 0) {
            EnablementLoadValueModifier loadedValueModifier = new EnablementLoadValueModifier();
            loadedValueModifier.setEnablement(EnablementParser.newIsntance().getCondition(enablementCondition));
            helper.setLoadedValueModifier(loadedValueModifier);
        }
        if ((versions = AttributeReader.parseVersionsAttribute(el)) != null) {
            helper.setRange(versions);
        }
        if ((fillWhenNotEmpty = el.getAttribute("fillWhenNotEmpty")).length() > 0) {
            helper.setFillWhenNotEmpty(Boolean.parseBoolean(fillWhenNotEmpty));
        }
        boolean svpRequired = Boolean.parseBoolean(el.getAttribute("specialValuePersistenceRequired"));
        String specialPersistence = el.getAttribute("specialValuePersistance");
        String defaultValue = el.getAttribute("defaultValue");
        if (specialPersistence.length() > 0) {
            helper.setValuePersistence(new SpecialValuePersistence(specialPersistence, svpRequired, defaultValue));
        }
        if ((isTextArea = el.getAttribute("isTextArea")).length() > 0) {
            helper.setTextArea(Boolean.parseBoolean(isTextArea));
        }
        String textAreaHeight = el.getAttribute("textAreaHeight");
        int height = 0;
        if (textAreaHeight != null && textAreaHeight.length() > 0) {
            try {
                height = Integer.parseInt(spanStr);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (height != 0) {
            helper.setTextAreaHeight(height);
        }
        boolean requiredForDataSense = Boolean.parseBoolean(el.getAttribute(ATTR_REQUIRED_FOR_DATA_SENSE));
        helper.setRequiredForDataSense(helper.isTypeChooser() || requiredForDataSense);
        AttributeReader.processComponents(helper, el.getChildNodes(), muleArtifact);
        AttributeReader.applyCompatibilityCorrections(helper);
    }

    private static void processComponents(AttributeHelper helper, NodeList nodeList, Artifact muleArtifact) {
        int a = 0;
        while (a < nodeList.getLength()) {
            Element el;
            String type;
            AttributeHelperComponentCreator capabilityCreator;
            Node n = nodeList.item(a);
            if (n instanceof Element && (capabilityCreator = componentsCreators.get(type = (el = (Element)n).getNodeName())) != null) {
                capabilityCreator.createAndRegister(el, muleArtifact, helper);
            }
            ++a;
        }
    }

    private static void applyCompatibilityCorrections(AttributeHelper helper) {
        if (helper instanceof EnumHelper && ((EnumHelper)helper).isTypeChooser()) {
            EnumHelper enumHelper = (EnumHelper)helper;
            Optional<TypeChooserComponent> component = helper.getComponent(TypeChooserComponent.class);
            if (!component.isPresent()) {
                TypeChooserComponent element = new TypeChooserComponent(enumHelper.getKeyParts());
                helper.registerComponent(TypeChooserComponent.class, element);
            }
        }
    }

    public static MuleVersionRange parseVersionsAttribute(Element el) {
        return AttributeReader.parseVersionsAttribute(el, null);
    }

    public static MuleVersionRange parseVersionsAttribute(Element el, MuleVersionRange defaultRange) {
        boolean enterprise = false;
        String versions = el.getAttribute("versions");
        if (StringUtils.isNotBlank((String)versions)) {
            int indexOf = versions.indexOf(59);
            if (indexOf != -1) {
                versions = versions.substring(0, indexOf);
                enterprise = true;
            }
            return new MuleVersionRange(new VersionRange(versions), enterprise);
        }
        return defaultRange;
    }

    public static ArrayList<EnumOption> getEncodingOptions() {
        return encodingOptions;
    }

    private static <T> T createInstance(String className, Class<T> type) {
        T instance = null;
        try {
            instance = type.cast(Class.forName(className).newInstance());
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not instantiate class: " + className, e);
        }
        return instance;
    }

    static final class DirValidator
    implements IValidator,
    IValidatorWithSeverity {
        DirValidator() {
        }

        @Override
        public String validate(Object value, AttributeContext context, AttributeHelper helper) {
            return null;
        }

        @Override
        public int getSeverity() {
            return 4;
        }
    }

    public static final class GlobalRefHyperlinkProvider
    implements ITypeHyperlinkProvider {
        public IHyperlink[] calculateHyperlinks(String attributeName, DomainEditingModelObject findElement, ITextViewer viewer, final int offset, String startString, final int lengthCompletion, final String fullString, String typeSpecialization) {
            IDocumentElementNode[] childNodes;
            IDocumentElementNode[] iDocumentElementNodeArray = childNodes = findElement.getRoot().getChildNodes();
            int n = childNodes.length;
            int n2 = 0;
            while (n2 < n) {
                IDocumentElementNode n3 = iDocumentElementNodeArray[n2];
                DomainEditingModelObject mz = (DomainEditingModelObject)n3;
                AttributeContext ctx = new AttributeContext();
                ElementModel resolve = MuleConfigurationValidator.resolve(mz.getNamespace(), mz.getLocalName(), ctx, mz.isGlobal(), null, null);
                if (resolve != null) {
                    IDocumentAttributeNode[] nodeAttributes;
                    IDocumentAttributeNode[] iDocumentAttributeNodeArray = nodeAttributes = mz.getNodeAttributes();
                    int n4 = nodeAttributes.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        final IDocumentAttributeNode na = iDocumentAttributeNodeArray[n5];
                        if (na.getAttributeName().equals("name") && na.getAttributeValue().equals(fullString)) {
                            return new IHyperlink[]{new IHyperlink(){

                                public IRegion getHyperlinkRegion() {
                                    return new Region(offset, lengthCompletion);
                                }

                                public String getTypeLabel() {
                                    return "global reference";
                                }

                                public String getHyperlinkText() {
                                    return fullString;
                                }

                                public void open() {
                                    IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                                    ITextEditor adapter = (ITextEditor)activeEditor.getAdapter(ITextEditor.class);
                                    adapter.selectAndReveal(na.getValueOffset(), na.getValueLength());
                                }
                            }};
                        }
                        ++n5;
                    }
                }
                ++n2;
            }
            return new IHyperlink[0];
        }
    }

    public static final class NameHelper
    extends AttributeHelper {
        public NameHelper(String id, Class<?> type, boolean required) {
            super(id, type, required);
        }
    }

    static final class PSValidator
    implements IValidator,
    IValidatorWithSeverity {
        PSValidator() {
        }

        @Override
        public String validate(Object value, AttributeContext context, AttributeHelper helper) {
            return null;
        }

        @Override
        public int getSeverity() {
            return 4;
        }
    }

    public static class XMLAwareGlobalRefValidator
    implements IValidator {
        private final GlobalRefAttributeHelper hp;

        public XMLAwareGlobalRefValidator(GlobalRefAttributeHelper hp) {
            this.hp = hp;
        }

        @Override
        public String validate(Object value, AttributeContext context, AttributeHelper helper) {
            if (value == null || value.toString().length() == 0) {
                return null;
            }
            List<IMessageFlowEntity> gl = null;
            try {
                gl = GlobalRefEditor.getActualGlobals(context);
            }
            catch (NullPointerException nullPointerException) {
                MuleConfiguration muleConfiguration = context.getMuleConfiguration();
                List globalEntries = muleConfiguration.getGlobalEntries();
                List globalEntries2 = context.getGlobalEntries();
                gl = new ArrayList<IMessageFlowEntity>();
                gl.addAll(globalEntries);
                gl.addAll(globalEntries2);
            }
            ArrayList<String> globalElementNames = new ArrayList<String>();
            for (IMessageFlowEntity vl : gl) {
                GlobalUnknown u;
                String unknownName;
                if (vl instanceof GlobalElement) {
                    GlobalElement n = (GlobalElement)vl;
                    PropertyCollectionMap propertyCollectionMap = new PropertyCollectionMap(n.getProperties());
                    String property = propertyCollectionMap.getProperty(this.hp.getAttrName(), null);
                    String property2 = propertyCollectionMap.getProperty("id", null);
                    if (property2 != null) {
                        globalElementNames.add(property2);
                    }
                    if (property == null) {
                        property = property2;
                    }
                    if (property == null) {
                        property = propertyCollectionMap.getProperty("name", null);
                    }
                    if (property == null) continue;
                    globalElementNames.add(property);
                    continue;
                }
                if (!(vl instanceof GlobalUnknown) || (unknownName = (u = (GlobalUnknown)vl).getUnknownName()) == null) continue;
                globalElementNames.add(unknownName);
            }
            String valueToValidate = value.toString();
            if (!ExpressionUtils.isExpressionOrProperty((String)valueToValidate) && !globalElementNames.contains(valueToValidate)) {
                return "Reference to unknown global element:" + valueToValidate;
            }
            return null;
        }
    }
}

