/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.ui.modules.core.widgets.meta.MetaDescriptionEntry;
import org.osgi.framework.Version;

public class VersionFilter {
    private static VersionFilter instance;

    public static synchronized VersionFilter getInstance() {
        if (instance == null) {
            instance = new VersionFilter();
        }
        return instance;
    }

    public <T extends MetaDescriptionEntry> Collection<T> filter(Collection<T> metaDescriptionEntries, Version currentVersion) {
        ArrayList<MetaDescriptionEntry> result = new ArrayList<MetaDescriptionEntry>();
        for (MetaDescriptionEntry metaDescriptionEntry : metaDescriptionEntries) {
            VersionRange entryRange = metaDescriptionEntry.getRange();
            if (entryRange != null && !entryRange.isIncluded(currentVersion)) continue;
            result.add(metaDescriptionEntry);
        }
        return result;
    }

    public <T extends MetaDescriptionEntry> Collection<T> filter(Collection<T> metaDescriptionEntries, IFlowTransformerContext context) {
        IServerDefinition serverDefinition = CoreUtils.getServerDefinition((IFlowTransformerContext)context);
        String versionStr = serverDefinition.getVersion();
        Version currentVersion = new Version(versionStr);
        return this.filter(metaDescriptionEntries, currentVersion);
    }
}

