/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.regex.Pattern;
import org.mule.tooling.core.utils.ExpressionUtils;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeValidator;

public class TimeAttributeHelper
extends AttributeHelper {
    protected int min;
    protected int max;
    protected boolean isShowMilliseconds = false;

    public boolean isShowMilliseconds() {
        return this.isShowMilliseconds;
    }

    public void setShowMilliseconds(boolean isShowMilliseconds) {
        this.isShowMilliseconds = isShowMilliseconds;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public TimeAttributeHelper(String id, Class<?> type, boolean required) {
        super(id, type, required);
        this.setValidator(new TimeAttributeValidator());
    }

    private static final class TimeAttributeValidator
    extends AttributeValidator {
        private static final String NUMBERS_REGEX = "[0-9]+";
        private static final Pattern NUMBER_PATTERN = Pattern.compile("[0-9]+");
        private static final String VALUE_MUST_BE_AN_INTEGER = "Value must be an integer";

        private TimeAttributeValidator() {
        }

        @Override
        public String validate(Object value, AttributeContext context, AttributeHelper helper) {
            String valueStr = value.toString();
            if (valueStr.trim().isEmpty()) {
                return null;
            }
            String result = this.validateExpression(value.toString(), helper.isSupportsExpressions());
            if (result != null) {
                return result;
            }
            if (!ExpressionUtils.isExpressionOrProperty((String)value.toString())) {
                if (!NUMBER_PATTERN.matcher(valueStr).matches()) {
                    try {
                        Integer.parseInt(value.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        return this.getAllowedTypesMessage(VALUE_MUST_BE_AN_INTEGER, helper.isSupportsExpressions());
                    }
                }
                return null;
            }
            return null;
        }
    }
}

