/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModelObject;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentElementNode;
import java.util.List;
import org.mule.tooling.core.validation.Message;
import org.mule.tooling.core.validation.MessageBuilder;
import org.mule.tooling.core.validation.ValidationConstants;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.ChildElementTableFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.StringFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.IComponentValidator;

public class SpringPropertyValidator
implements IComponentValidator {
    private String ERROR_MESSAGE = "One of the following values required: 'value', 'ref' or nested element.";
    private String ERROR_MESSAGE2 = "Only one of the following values required: 'value', 'ref' or nested element.";

    @Override
    public Message validateComponent(DomainEditingModelObject pNode) {
        String ref = pNode.getXMLAttributeValue("ref");
        String value = pNode.getXMLAttributeValue("value");
        IDocumentElementNode[] nesteds = pNode.getChildNodes();
        if (!(ref != null && ref.length() != 0 || value != null && value.length() != 0 || nesteds != null && nesteds.length != 0)) {
            return MessageBuilder.newErrorMessage((String)this.ERROR_MESSAGE).build();
        }
        if (ref != null && ref.length() != 0 && (value != null && value.length() != 0 || nesteds != null && nesteds.length != 0)) {
            return MessageBuilder.newErrorMessage((String)this.ERROR_MESSAGE2).build();
        }
        if (value != null && value.length() != 0 && nesteds != null && nesteds.length != 0) {
            return MessageBuilder.newErrorMessage((String)this.ERROR_MESSAGE2).build();
        }
        return ValidationConstants.MESSAGE_OK;
    }

    @Override
    public Message validateComponentGUI(IMessageFlowNode node, List<IFieldEditor> editors) {
        String ref = null;
        String value = null;
        String nesteds = null;
        for (IFieldEditor editor : editors) {
            if (editor instanceof AbstractFieldEditor) {
                String editorId = editor.getHelper().id;
                if (editor instanceof StringFieldEditor) {
                    StringFieldEditor sfe = (StringFieldEditor)editor;
                    if (editorId != null && editorId.equals("ref")) {
                        ref = sfe.getPublicValue();
                    }
                    if (editorId != null && editorId.equals("value")) {
                        value = sfe.getPublicValue();
                    }
                }
            }
            if (!(editor instanceof ChildElementTableFieldEditor)) continue;
            ChildElementTableFieldEditor tableFieldEditor = (ChildElementTableFieldEditor)editor;
            String editorId = tableFieldEditor.getHelper().id;
            if (editorId == null || !editorId.equals("http://www.springframework.org/schema/beans/property-child") || tableFieldEditor.getDefs() == null || tableFieldEditor.getDefs().size() == 0) continue;
            nesteds = "notNull";
        }
        if (!(ref != null && ref.length() != 0 || value != null && value.length() != 0 || nesteds != null && nesteds.length() != 0)) {
            return MessageBuilder.newErrorMessage((String)this.ERROR_MESSAGE).build();
        }
        if (ref != null && ref.length() != 0 && (value != null && value.length() != 0 || nesteds != null && nesteds.length() != 0)) {
            return MessageBuilder.newErrorMessage((String)this.ERROR_MESSAGE2).build();
        }
        if (value != null && value.length() != 0 && nesteds != null && nesteds.length() != 0) {
            return MessageBuilder.newErrorMessage((String)this.ERROR_MESSAGE2).build();
        }
        return ValidationConstants.MESSAGE_OK;
    }
}

