/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModelObject;
import java.util.List;
import org.mule.tooling.core.validation.Message;
import org.mule.tooling.core.validation.MessageBuilder;
import org.mule.tooling.core.validation.ValidationConstants;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.EnumFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.StringFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.IComponentValidator;

public class SplitterValidator
implements IComponentValidator {
    private String ERROR_TEXT = "Custom evaluator value should be specified when 'custom' evaluator type is selected.";
    private String ERROR_TEXT2 = "Custom evaluator value should be empty.";

    private Message validateValues(String evaluator, String customEvaluator) {
        if (evaluator != null && evaluator.equals("custom")) {
            if (customEvaluator == null || customEvaluator.length() == 0) {
                return MessageBuilder.newErrorMessage((String)this.ERROR_TEXT).build();
            }
        } else if (customEvaluator != null && customEvaluator.length() > 0) {
            return MessageBuilder.newErrorMessage((String)this.ERROR_TEXT2).build();
        }
        return ValidationConstants.MESSAGE_OK;
    }

    @Override
    public Message validateComponent(DomainEditingModelObject pNode) {
        try {
            String evaluator = pNode.getXMLAttributeValue("evaluator");
            String customEvaluator = pNode.getXMLAttributeValue("custom-evaluator");
            return this.validateValues(evaluator, customEvaluator);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return ValidationConstants.MESSAGE_OK;
        }
    }

    @Override
    public Message validateComponentGUI(IMessageFlowNode node, List<IFieldEditor> editors) {
        try {
            String evaluator = null;
            String customEvaluator = null;
            for (IFieldEditor editor : editors) {
                String editorId;
                if (!(editor instanceof AbstractFieldEditor) || (editorId = editor.getHelper().id) == null) continue;
                if (editorId.equals("evaluator")) {
                    if (!(editor instanceof EnumFieldEditor)) continue;
                    EnumFieldEditor efe = (EnumFieldEditor)editor;
                    evaluator = efe.getPublicValue();
                    continue;
                }
                if (!editorId.equals("custom-evaluator") || !(editor instanceof StringFieldEditor)) continue;
                StringFieldEditor sfe = (StringFieldEditor)editor;
                customEvaluator = sfe.getPublicValue();
            }
            return this.validateValues(evaluator, customEvaluator);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return ValidationConstants.MESSAGE_OK;
        }
    }
}

