/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractValuePersistence;

public final class SpecialValuePersistence
extends AbstractValuePersistence {
    private static final String DEFAULT_VALUE = "#[payload]";
    private final String objectsId;
    private final String objectId;
    private final boolean required;
    private final String defaultValue;

    public SpecialValuePersistence(String commonPrefix) {
        this(commonPrefix, false, DEFAULT_VALUE);
    }

    public SpecialValuePersistence(String commonPrefix, boolean required) {
        this(commonPrefix, required, DEFAULT_VALUE);
    }

    public SpecialValuePersistence(String commonPrefix, boolean required, String defaultValue) {
        this.objectsId = "@" + commonPrefix;
        this.objectId = "@" + commonPrefix.substring(0, commonPrefix.length() - 1);
        this.required = required;
        this.defaultValue = defaultValue;
    }

    @Override
    public String getId(PropertyCollectionMap newProperties, PropertyCollectionMap parentProperties, String id) {
        String fromExpression = newProperties.getProperty("fromExpression", null);
        String none = newProperties.getProperty("none", null);
        String nullStringToAvoidAmbiguity = null;
        if (none != null && none.equals("true")) {
            Map propertyCollections = newProperties.getPropertyCollections();
            Set keySet = propertyCollections.keySet();
            HashSet<String> keysToRemove = new HashSet<String>();
            for (String key : keySet) {
                if (!key.startsWith(this.objectId)) continue;
                keysToRemove.add(key);
            }
            for (String key : keysToRemove) {
                propertyCollections.remove(key);
                propertyCollections.put("-" + key, new PropertyCollectionMap());
            }
            return null;
        }
        if (fromExpression != null && fromExpression.equals("true")) {
            Map propertyCollections = newProperties.getPropertyCollections();
            Set keySet = propertyCollections.keySet();
            HashSet<String> keysToRemove = new HashSet<String>();
            for (String key : keySet) {
                if (!key.startsWith(this.objectId)) continue;
                keysToRemove.add(key);
            }
            for (String key : keysToRemove) {
                propertyCollections.remove(key);
                propertyCollections.put("-" + key, new PropertyCollectionMap());
            }
            String ref = newProperties.getProperty("ref", null);
            if (ref == null || ref.length() == 0) {
                newProperties.addProperty("ref", this.defaultValue);
            }
        } else {
            newProperties.addProperty("ref", nullStringToAvoidAmbiguity);
        }
        newProperties.addProperty("fromExpression", nullStringToAvoidAmbiguity);
        newProperties.addProperty("createAList", nullStringToAvoidAmbiguity);
        Collection values = newProperties.getPropertyCollections().values();
        for (PropertyCollectionMap m : values) {
            m.addProperty("fromExpression", nullStringToAvoidAmbiguity);
            m.addProperty("createAList", nullStringToAvoidAmbiguity);
        }
        return this.objectsId + ";1";
    }

    @Override
    public PropertyCollection adjust(List<PropertyCollection> defs2, String id) {
        for (PropertyCollection ca : defs2) {
            String newValue;
            if (!ca.getName().startsWith(this.objectsId)) continue;
            List properties = ca.getProperties();
            if (!this.required) {
                if (this.contains(properties, "ref")) {
                    SpecialValuePersistence.clear(properties);
                    properties.add(this.createProperty("fromExpression", "true"));
                    properties.add(this.createProperty("createAList", "false"));
                    properties.add(this.createProperty("none", "false"));
                    newValue = this.defaultValue;
                } else if (!ca.getPropertyCollections().isEmpty()) {
                    SpecialValuePersistence.clear(properties);
                    properties.add(this.createProperty("createAList", "true"));
                    properties.add(this.createProperty("fromExpression", "false"));
                    properties.add(this.createProperty("none", "false"));
                    newValue = "";
                } else {
                    SpecialValuePersistence.clear(properties);
                    properties.add(this.createProperty("createAList", "false"));
                    properties.add(this.createProperty("fromExpression", "false"));
                    properties.add(this.createProperty("none", "true"));
                    newValue = "";
                }
            } else if (this.contains(properties, "ref")) {
                properties.add(this.createProperty("fromExpression", "true"));
                properties.add(this.createProperty("createAList", "false"));
                newValue = this.defaultValue;
            } else {
                properties.add(this.createProperty("createAList", "true"));
                properties.add(this.createProperty("fromExpression", "false"));
                newValue = "";
            }
            boolean found = false;
            for (Property property : properties) {
                if (!property.getName().equals("ref")) continue;
                if (property.getValue() == null || property.getValue().length() == 0) {
                    property.setValue(newValue);
                }
                found = true;
                break;
            }
            if (!found) {
                properties.add(this.createProperty("ref", newValue));
            }
            return ca;
        }
        PropertyCollection newPropertyCollection = new PropertyCollection();
        String newPropertyCollectionName = this.objectsId + ";0";
        List defaultProperties = newPropertyCollection.getProperties();
        newPropertyCollection.setName(newPropertyCollectionName);
        if (!this.required) {
            SpecialValuePersistence.clear(defaultProperties);
            defaultProperties.add(this.createProperty("none", "true"));
            defaultProperties.add(this.createProperty("fromExpression", "false"));
        } else {
            defaultProperties.add(this.createProperty("fromExpression", "true"));
        }
        defaultProperties.add(this.createProperty("createAList", "false"));
        defaultProperties.add(this.createProperty("ref", this.defaultValue));
        return newPropertyCollection;
    }

    private static void clear(List<Property> properties) {
        PropertiesUtils.removeAll(properties, (String)"createAList");
        PropertiesUtils.removeAll(properties, (String)"fromExpression");
        PropertiesUtils.removeAll(properties, (String)"none");
    }

    private Property createProperty(String name, String value) {
        Property property = new Property();
        property.setName(name);
        property.setValue(value);
        return property;
    }

    private boolean contains(List<Property> properties, String attributeName) {
        for (Property property : properties) {
            if (!property.getName().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String convertModelToXML(String str) {
        return null;
    }

    @Override
    public String convertXMLToModel(String str) {
        return null;
    }
}

