/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModelObject;
import java.util.List;
import org.mule.tooling.core.validation.Message;
import org.mule.tooling.core.validation.MessageBuilder;
import org.mule.tooling.core.validation.ValidationConstants;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.TextElementFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.IComponentValidator;

public class SalesforceInnerObjectValueValidator
implements IComponentValidator {
    private String ERROR_TEXT = "Value text should be specified for salesforce:inner-object";

    @Override
    public Message validateComponent(DomainEditingModelObject pNode) {
        try {
            String value = pNode.getXMLContent();
            if (value == null || value.length() == 0) {
                return MessageBuilder.newErrorMessage((String)this.ERROR_TEXT).build();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Message validateComponentGUI(IMessageFlowNode node, List<IFieldEditor> editors) {
        try {
            String value = null;
            for (IFieldEditor editor : editors) {
                String editorId;
                if (!(editor instanceof AbstractFieldEditor) || (editorId = editor.getHelper().id) == null || !editorId.equals("value") || !(editor instanceof TextElementFieldEditor)) continue;
                TextElementFieldEditor tefe = (TextElementFieldEditor)editor;
                value = tefe.getPublicValue();
            }
            if (value == null || value.length() == 0) {
                return MessageBuilder.newErrorMessage((String)this.ERROR_TEXT).build();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return ValidationConstants.MESSAGE_OK;
    }
}

