/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Namespace;
import org.mule.tooling.core.dom.ElementUtils;
import org.mule.tooling.core.module.Artifact;
import org.mule.tooling.core.module.IModuleLoaderHandler;
import org.mule.tooling.editor.model.element.Stereotype;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.RouteDefinition;
import org.mule.tooling.model.module.filter.NodeDefinitionFilterFactory;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractContributionHandler;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeCategory;
import org.mule.tooling.ui.modules.core.widgets.meta.MuleStereotypes;
import org.mule.tooling.ui.modules.core.widgets.meta.NestedComponentMeta;
import org.mule.tooling.ui.modules.internal.meta.StereotypeParser;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RouteDeclarationContributionHandler
extends AbstractContributionHandler<RouteDefinition> {
    @Override
    protected String getDefaultCategory(Element element) {
        return "";
    }

    @Override
    protected AbstractComponentMeta createComponentMeta(Namespace ns, RouteDefinition routeDefinition, LinkedHashMap<String, AttributeCategory> loadCommonProperties, HashSet<String> doNotInherit) {
        NestedComponentMeta nestedComponentMeta = new NestedComponentMeta(routeDefinition.getMuleElement(), ns, (NodeDefinition)routeDefinition, loadCommonProperties, doNotInherit);
        routeDefinition.setHasAttributes(!loadCommonProperties.isEmpty());
        return nestedComponentMeta;
    }

    @Override
    protected RouteDefinition createNodeDefinition(Namespace ns, Element element, Artifact muleArtifact, IModuleLoaderHandler handler) {
        RouteDefinition routeDefinition = new RouteDefinition();
        this.configureAllowedStereotypesFilter(routeDefinition, ns, element);
        String localName = element.getAttribute("localId");
        String xmlName = element.getAttribute("xmlname");
        if (StringUtils.isNotBlank((String)xmlName)) {
            localName = xmlName;
        }
        routeDefinition.setMuleElement(this.createQName(ns, localName));
        routeDefinition.setBundleSymbolicName(muleArtifact.getId());
        return routeDefinition;
    }

    private void configureAllowedStereotypesFilter(RouteDefinition routeDefinition, Namespace ns, Element element) {
        ArrayList<Stereotype> allowedStereotypes = new ArrayList<Stereotype>();
        StereotypeParser parser = new StereotypeParser();
        for (Element allowedStereotype : ElementUtils.toElemList((NodeList)element.getElementsByTagName("allowed-stereotypes"))) {
            for (Element stereotypeElement : ElementUtils.toElemList((NodeList)allowedStereotype.getElementsByTagName("stereotype"))) {
                allowedStereotypes.add(parser.processStereotype(stereotypeElement));
            }
        }
        if (allowedStereotypes.isEmpty()) {
            allowedStereotypes.add(MuleStereotypes.PROCESSOR);
        }
        routeDefinition.setAcceptsFilter(NodeDefinitionFilterFactory.createFilter(allowedStereotypes));
    }

    @Override
    protected RouteDefinition createNodeDefinition(Namespace ns, Element element) {
        return null;
    }

    @Override
    protected Stereotype getDefaultStereotype() {
        return MuleStereotypes.PROCESSOR;
    }
}

