/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.HashSet;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Namespace;
import org.mule.tooling.core.Category;
import org.mule.tooling.editor.model.element.Stereotype;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.RouteDefinition;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractContributionHandler;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeCategory;
import org.mule.tooling.ui.modules.core.widgets.meta.MuleStereotypes;
import org.mule.tooling.ui.modules.core.widgets.meta.NamedComponentMeta;
import org.w3c.dom.Element;

public class RouteContributionHandler
extends AbstractContributionHandler<RouteDefinition> {
    private static final String ROW_NUMBER = "rowNumber";
    private static final String LAYOUT_FACTORY_ID = "layoutFactoryId";
    private static final String CHILDREN_CREATOR_ID = "childrenCreatorId";
    private static final String EDIT_POLICY_FACTORY_ID = "editPolicyFactoryId";
    private static final String PATH_EXPRESSION_ATTRIBUTE = "pathExpression";
    public static final String CATEGORY_ATTRIBUTE = "category";
    public static final String DEFAULT_ATTRIBUTE = "default";
    public static final String COLLAPSABLE_ATTRIBUTE = "collapsable";
    public static final String ACCEPTS_ELEMENTS_ATTRIBUTE = "acceptsElements";
    public static final String TITLE_RESOLVER = "titleResolver";

    @Override
    protected String getDefaultCategory(Element element) {
        String categoryAttribute = element.getAttribute(CATEGORY_ATTRIBUTE);
        return StringUtils.isEmpty((String)categoryAttribute) ? Category.SCOPES.getCategoryString() : categoryAttribute;
    }

    @Override
    protected AbstractComponentMeta createComponentMeta(Namespace ns, RouteDefinition routeDefinition, LinkedHashMap<String, AttributeCategory> loadCommonProperties, HashSet<String> doNotInherit) {
        NamedComponentMeta namedComponentMeta = new NamedComponentMeta(routeDefinition.getMuleElement(), ns, (NodeDefinition)routeDefinition, loadCommonProperties, doNotInherit);
        namedComponentMeta.setAllowAny(true);
        return namedComponentMeta;
    }

    @Override
    protected RouteDefinition createNodeDefinition(Namespace ns, Element element) {
        RouteDefinition routeDefinition = new RouteDefinition();
        routeDefinition.setRouteRef(element.getAttribute("name"));
        this.initializeRoute(routeDefinition, ns, element);
        return routeDefinition;
    }

    protected void initializeRoute(RouteDefinition routeDefinition, Namespace ns, Element element) {
        String minOccurrenceStr;
        routeDefinition.setCollapsable("true".equalsIgnoreCase(element.getAttribute(COLLAPSABLE_ATTRIBUTE)));
        routeDefinition.setLayoutFactoryId(element.getAttribute(LAYOUT_FACTORY_ID));
        routeDefinition.setChildrenCreatorId(element.getAttribute(CHILDREN_CREATOR_ID));
        routeDefinition.setEditPolicyFactoryId(element.getAttribute(EDIT_POLICY_FACTORY_ID));
        routeDefinition.setRequired("true".equalsIgnoreCase(element.getAttribute("required")));
        String maxOccurrenceStr = element.getAttribute("maxOccurrence");
        if (StringUtils.isNotBlank((String)maxOccurrenceStr)) {
            routeDefinition.setMaxOccurrence(Integer.parseInt(maxOccurrenceStr));
        }
        if (StringUtils.isNotBlank((String)(minOccurrenceStr = element.getAttribute("minOccurrence")))) {
            routeDefinition.setMinOccurrence(Integer.parseInt(minOccurrenceStr));
        }
        routeDefinition.setCaption(element.getAttribute("caption"));
        String attrXmlOrder = element.getAttribute("xmlOrder");
        if (StringUtils.isNotEmpty((String)attrXmlOrder)) {
            routeDefinition.setXmlOrder(Integer.parseInt(attrXmlOrder));
        }
        routeDefinition.setPathExpression(element.getAttribute(PATH_EXPRESSION_ATTRIBUTE).isEmpty() ? "${type}" : element.getAttribute(PATH_EXPRESSION_ATTRIBUTE));
        String rowNumberStr = element.getAttribute(ROW_NUMBER);
        int rowNumber = StringUtils.isNotBlank((String)rowNumberStr) ? Integer.parseInt(rowNumberStr) : 0;
        routeDefinition.setRowNumber(rowNumber);
        routeDefinition.setVisibleInPalette(false);
    }

    @Override
    protected Stereotype getDefaultStereotype() {
        return MuleStereotypes.PROCESSOR;
    }
}

