/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.HashSet;
import java.util.LinkedHashMap;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Namespace;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.mule.tooling.core.Category;
import org.mule.tooling.editor.model.element.Stereotype;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.PatternDefinition;
import org.mule.tooling.ui.modules.core.ModulesActivator;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractContributionHandler;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeCategory;
import org.mule.tooling.ui.modules.core.widgets.meta.MuleStereotypes;
import org.mule.tooling.ui.modules.core.widgets.meta.NamedComponentMeta;
import org.w3c.dom.Element;

public class PatternContributionHandler
extends AbstractContributionHandler<PatternDefinition> {
    public static final String ATT_CAUSES_SPLIT = "causesSplit";
    public static final String ATT_CONTRIBUTES_PATH = "contributesToPath";
    public static final String ATT_PATH_EXPRESSION = "pathExpression";
    public static final String ATT_CAUSES_JOIN = "causesJoin";
    public static final String ATT_PROCESSES_RESPONSE = "processesResponse";

    @Override
    protected String getDefaultCategory(Element element) {
        if (element.getNodeName().equals("filter")) {
            return Category.FILTERS.getCategoryString();
        }
        if (element.getNodeName().equals("component")) {
            return Category.CORE.getCategoryString();
        }
        if (element.getNodeName().equals("cloud-connector")) {
            return Category.CLOUD_CONNECTORS.getCategoryString();
        }
        if (element.getNodeName().equals("transformer")) {
            return Category.TRANSFORMERS.getCategoryString();
        }
        if (element.getNodeName().equals("flow")) {
            return Category.FLOW_CONTROL.getCategoryString();
        }
        return Category.CORE.getCategoryString();
    }

    @Override
    protected AbstractComponentMeta createComponentMeta(Namespace ns, PatternDefinition patternDefinition, LinkedHashMap<String, AttributeCategory> loadCommonProperties, HashSet<String> doNotInherit) {
        NamedComponentMeta namedComponentMeta = new NamedComponentMeta((QName)patternDefinition.getMuleElements().get(0), ns, (NodeDefinition)patternDefinition, loadCommonProperties, doNotInherit);
        namedComponentMeta.setAllowAny(true);
        return namedComponentMeta;
    }

    @Override
    protected PatternDefinition createNodeDefinition(Namespace ns, Element element) {
        PatternDefinition pattern = new PatternDefinition();
        String attribute = element.getAttribute("xmlname");
        String localName = element.getAttribute("localId");
        if (element.getNodeName().equals("flow")) {
            element.setAttribute("allowAny", "true");
            this.setModelGenerator(element, pattern);
        }
        pattern.getMuleElements().add(this.createQName(ns, attribute.length() > 0 ? attribute : localName));
        pattern.setCausesSplit("true".equals(element.getAttribute(ATT_CAUSES_SPLIT)));
        pattern.setCausesJoin("true".equals(element.getAttribute(ATT_CAUSES_JOIN)));
        pattern.setProcessesResponse("true".equals(element.getAttribute(ATT_PROCESSES_RESPONSE)));
        pattern.setContributesToPath("true".equals(element.getAttribute(ATT_CONTRIBUTES_PATH)));
        pattern.setPathExpression(element.getAttribute(ATT_PATH_EXPRESSION));
        return pattern;
    }

    private void setModelGenerator(Element element, PatternDefinition pattern) {
        String canonicalClassName = element.getAttribute("modelGenerator");
        if (!StringUtils.isBlank((String)canonicalClassName)) {
            try {
                pattern.setModelGenerator(Class.forName(canonicalClassName));
            }
            catch (ClassNotFoundException e) {
                ModulesActivator.getDefault().getLog().log((IStatus)new Status(4, "org.mule.tooling.ui.modules.core", "Could not load class: " + canonicalClassName + " while loading component definitions", (Throwable)e));
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected Stereotype getDefaultStereotype() {
        return MuleStereotypes.PROCESSOR;
    }
}

