/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.List;
import org.mule.tooling.core.dom.INodeWrapper;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributesPersistenceTransformer;

public class ObjectPropertiesTransformer
implements AttributesPersistenceTransformer {
    private static final String PROPERTIES_TYPE = "http://www.mulesoft.org/schema/mule/core/properties";
    private static final String PROPERTY_TYPE = "http://www.mulesoft.org/schema/mule/core/property";
    private static final String NO_PROPERTIES = "noProperties";
    private static final String USE_REFERENCE = "useReference";
    private static final String DEFINE_PROPERTIES = "defineProperties";

    @Override
    public void onLoad(IMessageFlowNode node, PropertyCollectionMap props) {
        String propertyCollectionId = PropertiesUtils.createCollectionId((String)PROPERTY_TYPE);
        List propertiesChildCollection = props.getPropertyCollectionsWithPrefix(propertyCollectionId);
        if (!propertiesChildCollection.isEmpty()) {
            props.addProperty(NO_PROPERTIES, String.valueOf(false));
            props.addProperty(DEFINE_PROPERTIES, String.valueOf(false));
            props.addProperty(USE_REFERENCE, String.valueOf(true));
        } else {
            List propertyChildrenCollections = props.getPropertyCollectionsWithPrefix(propertyCollectionId);
            if (!propertyChildrenCollections.isEmpty()) {
                props.addProperty(NO_PROPERTIES, String.valueOf(false));
                props.addProperty(DEFINE_PROPERTIES, String.valueOf(true));
                props.addProperty(USE_REFERENCE, String.valueOf(false));
            } else {
                props.addProperty(NO_PROPERTIES, String.valueOf(true));
            }
        }
    }

    @Override
    public void onSave(IMessageFlowNode node, PropertyCollectionMap props) {
        PropertyCollection propertiesForEdit = node.getPropertiesForEdit(null);
        boolean noProperties = Boolean.parseBoolean(props.getProperty(NO_PROPERTIES, "false"));
        boolean useReference = Boolean.parseBoolean(props.getProperty(USE_REFERENCE, "false"));
        boolean defineProperties = Boolean.parseBoolean(props.getProperty(DEFINE_PROPERTIES, "false"));
        if (noProperties) {
            this.removePropertyChildren(node, propertiesForEdit);
            this.removePropertiesChild(props);
        } else if (useReference) {
            this.removePropertyChildren(node, propertiesForEdit);
        } else if (defineProperties) {
            this.removePropertiesChild(props);
        }
    }

    private void removePropertiesChild(PropertyCollectionMap props) {
        List properties = props.getPropertyCollectionsWithPrefix("@http://www.mulesoft.org/schema/mule/core/properties");
        properties.forEach(p -> p.setErased(true));
    }

    private void removePropertyChildren(IMessageFlowNode node, PropertyCollection propertiesForEdit) {
        List toRemove = propertiesForEdit.getPropertyCollections();
        toRemove.forEach(p -> {
            if (p.getName().contains(PROPERTY_TYPE)) {
                node.getElement().removeChild((INodeWrapper)p.getElement());
            }
        });
    }
}

