/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Namespace;
import org.mule.tooling.core.Category;
import org.mule.tooling.core.dom.ElementUtils;
import org.mule.tooling.editor.model.element.Stereotype;
import org.mule.tooling.model.module.NestedContainerDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.filter.INodeDefinitionFilter;
import org.mule.tooling.model.module.filter.NodeDefinitionFilterFactory;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractContributionHandler;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeCategory;
import org.mule.tooling.ui.modules.core.widgets.meta.MuleStereotypes;
import org.mule.tooling.ui.modules.core.widgets.meta.NamedComponentMeta;
import org.mule.tooling.ui.modules.internal.meta.StereotypeParser;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NestedContainerContributionHandler
extends AbstractContributionHandler<NestedContainerDefinition> {
    private static final String UPDATE_PARTICIPANT_ID = "updateParticipantId";
    private static final String ROW_NUMBER = "rowNumber";
    private static final String LAYOUT_FACTORY_ID = "layoutFactoryId";
    private static final String CHILDREN_CREATOR_ID = "childrenCreatorId";
    private static final String EDIT_POLICY_FACTORY_ID = "editPolicyFactoryId";
    public static final String SHOWS_RESPONSE = "showsResponse";
    private static final String PATH_EXPRESSION_ATTRIBUTE = "pathExpression";
    public static final String CATEGORY_ATTRIBUTE = "category";
    public static final String DEFAULT_ATTRIBUTE = "default";
    public static final String COLLAPSABLE_ATTRIBUTE = "collapsable";
    public static final String PROMPT_ATTRIBUTE = "prompt";
    public static final String ACCEPTS_CATEGORY_ATTRIBUTE = "acceptsCategory";
    public static final String ACCEPTS_ELEMENTS_ATTRIBUTE = "acceptsElements";

    @Override
    protected String getDefaultCategory(Element element) {
        String categoryAttribute = element.getAttribute(CATEGORY_ATTRIBUTE);
        return StringUtils.isEmpty((String)categoryAttribute) ? Category.SCOPES.getCategoryString() : categoryAttribute;
    }

    @Override
    protected AbstractComponentMeta createComponentMeta(Namespace ns, NestedContainerDefinition container, LinkedHashMap<String, AttributeCategory> loadCommonProperties, HashSet<String> doNotInherit) {
        NamedComponentMeta namedComponentMeta = new NamedComponentMeta(container.getMuleElement(), ns, (NodeDefinition)container, loadCommonProperties, doNotInherit);
        namedComponentMeta.setAllowAny(true);
        return namedComponentMeta;
    }

    @Override
    protected NestedContainerDefinition createNodeDefinition(Namespace ns, Element element) {
        NestedContainerDefinition nestedContainer = new NestedContainerDefinition();
        this.initializeNestedContainer(nestedContainer, ns, element);
        return nestedContainer;
    }

    protected void initializeNestedContainer(NestedContainerDefinition nestedContainer, Namespace ns, Element element) {
        String localName = element.getAttribute("localId");
        nestedContainer.setMuleElement(this.createQName(ns, localName));
        String acceptsAttribute = element.getAttribute(ACCEPTS_ELEMENTS_ATTRIBUTE);
        if (StringUtils.isNotBlank((String)acceptsAttribute)) {
            nestedContainer.setAcceptsFilter(NodeDefinitionFilterFactory.createFilter((String)acceptsAttribute));
        } else {
            nestedContainer.setAcceptsFilter(this.createAllowedStereotypesFilter(ns, element));
        }
        nestedContainer.setCollapsable(Boolean.parseBoolean(element.getAttribute(COLLAPSABLE_ATTRIBUTE)));
        nestedContainer.setShowsResponse(Boolean.parseBoolean(element.getAttribute(SHOWS_RESPONSE)));
        nestedContainer.setLayoutFactoryId(element.getAttribute(LAYOUT_FACTORY_ID));
        nestedContainer.setChildrenCreatorId(element.getAttribute(CHILDREN_CREATOR_ID));
        nestedContainer.setEditPolicyFactoryId(element.getAttribute(EDIT_POLICY_FACTORY_ID));
        nestedContainer.setUpdateParticipantId(element.getAttribute(UPDATE_PARTICIPANT_ID));
        nestedContainer.setPrompt(element.getAttribute(PROMPT_ATTRIBUTE));
        String attrXmlOrder = element.getAttribute("xmlOrder");
        if (StringUtils.isNotEmpty((String)attrXmlOrder)) {
            nestedContainer.setXmlOrder(Integer.parseInt(attrXmlOrder));
        }
        nestedContainer.setPathExpression(element.getAttribute(PATH_EXPRESSION_ATTRIBUTE).isEmpty() ? "${type}" : element.getAttribute(PATH_EXPRESSION_ATTRIBUTE));
        String rowNumberStr = element.getAttribute(ROW_NUMBER);
        int rowNumber = StringUtils.isNotBlank((String)rowNumberStr) ? Integer.parseInt(rowNumberStr) : 0;
        nestedContainer.setRowNumber(rowNumber);
        nestedContainer.setVisibleInPalette(false);
    }

    private INodeDefinitionFilter createAllowedStereotypesFilter(Namespace ns, Element element) {
        ArrayList<Stereotype> allowedStereotypes = new ArrayList<Stereotype>();
        StereotypeParser parser = new StereotypeParser();
        for (Element allowedStereotype : ElementUtils.toElemList((NodeList)element.getElementsByTagName("allowed-stereotypes"))) {
            for (Element stereotypeElement : ElementUtils.toElemList((NodeList)allowedStereotype.getElementsByTagName("stereotype"))) {
                allowedStereotypes.add(parser.processStereotype(stereotypeElement));
            }
        }
        if (allowedStereotypes.isEmpty()) {
            allowedStereotypes.add(MuleStereotypes.PROCESSOR);
            allowedStereotypes.add(MuleStereotypes.FLOW);
        }
        return NodeDefinitionFilterFactory.createFilter(allowedStereotypes);
    }

    @Override
    protected Stereotype getDefaultStereotype() {
        return MuleStereotypes.PROCESSOR;
    }
}

