/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModelObject;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.IProblemReporter;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentElementNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Namespace;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.dom.ElementUtils;
import org.mule.tooling.core.dom.IAttributeWrapper;
import org.mule.tooling.core.dom.IDocumentWrapper;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.INodeListWrapper;
import org.mule.tooling.core.dom.INodeWrapper;
import org.mule.tooling.core.dom.QNameUtils;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.module.Artifact;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.editor.model.element.Stereotype;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractCompositeAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.ChildElementAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.GlobalRefAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.NestedComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.NodeDefinitionNameComparator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.AttributeReader;
import org.mule.tooling.ui.modules.internal.meta.StereotypeParser;
import org.mule.tooling.ui.palette.PaletteManager;
import org.osgi.framework.Version;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MultiWayHelper
extends AbstractCompositeAttributeHelper {
    public static final String AUXILIARY_MODE = "auxiliary;MODE;";
    public static final String MODE_NONE = "NONE";
    public static final String MODE_ATTR = "ATTR";
    public static final String MODE_CHILD = "CHILD";
    private final Map<String, AttributeHelper> editingModes = new LinkedHashMap<String, AttributeHelper>();
    public static final String EXPRESSION_MODE = "REF";
    public static final String GLOBAL_MODE = "GLOBAL";
    public static final String INLINE_MODE = "INLINE";
    public static final String BEAN_MODE = "BEAN";
    public static int NONE = 0;
    private static int EXPRESSION = 1;
    private static int GLOBAL = 2;
    private static int INLINE = 4;
    private static int BEAN = 8;
    private int modes = NONE;
    private List<String> allowedElements;
    private boolean allowsSubTypes;
    private String wrapIn;
    private List<String> globalTypes;
    private String defaultType;
    private String emptyLabel;
    private List<Stereotype> allowedStereotypes = Collections.emptyList();
    private boolean hideOnEmpty;

    public int getModes() {
        return this.modes;
    }

    public void setModes(int modes) {
        this.modes = modes;
    }

    public MultiWayHelper(String id, boolean required, String description) {
        super(id, Object.class, required, description);
    }

    @Override
    protected void parseSpecificAttributes(Element element) {
        String[] configuredModes;
        String mode = element.getAttribute("modes");
        String caption = element.getAttribute("caption");
        String description = element.getAttribute("description");
        int xmlOrder = -1;
        String order = element.getAttribute("xmlOrder");
        if (StringUtils.isNotBlank((CharSequence)order)) {
            xmlOrder = Integer.valueOf(order);
        }
        this.setDescription(description);
        this.setXmlOrder(xmlOrder);
        this.setCaption(caption);
        this.setHideOnEmpty(Boolean.parseBoolean(element.getAttribute("hideOnEmpty")));
        this.wrapIn = element.getAttribute("wrapIn");
        this.allowsSubTypes = Boolean.valueOf(element.getAttribute("allowSubTypes"));
        this.allowedElements = Arrays.asList(element.getAttribute("allowedElements").split(","));
        this.globalTypes = Arrays.asList(element.getAttribute("globalTypes").split(","));
        String label = element.getAttribute("emptyLabel");
        if (!StringUtils.isBlank((CharSequence)label)) {
            this.emptyLabel = label;
        }
        this.setDefaultType(element.getAttribute("defaultType"));
        String[] stringArray = configuredModes = mode.split("\\|");
        int n = configuredModes.length;
        int n2 = 0;
        while (n2 < n) {
            String item;
            switch (item = stringArray[n2]) {
                case "REF": {
                    this.modes |= EXPRESSION;
                    break;
                }
                case "GLOBAL": {
                    this.modes |= GLOBAL;
                    break;
                }
                case "INLINE": {
                    this.modes |= INLINE;
                    break;
                }
                case "BEAN": {
                    this.modes |= BEAN;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected mode " + item);
                }
            }
            ++n2;
        }
        List childs = ElementUtils.toElemList((NodeList)element.getChildNodes());
        for (Element child : childs) {
            if (!child.getNodeName().equals("allowed-stereotypes")) continue;
            this.configureStereotypes(child);
        }
    }

    private void configureStereotypes(Element allowedStereotypesNode) {
        StereotypeParser parser = new StereotypeParser();
        ArrayList<Stereotype> stereotypes = new ArrayList<Stereotype>();
        for (Element child : ElementUtils.toElemList((NodeList)allowedStereotypesNode.getChildNodes())) {
            if (!child.getNodeName().equals("stereotype")) continue;
            Stereotype stereotype = parser.processStereotype(child);
            stereotypes.add(stereotype);
        }
        this.setAllowedStereotypes(stereotypes);
    }

    protected void processChildModes() {
        this.getAllowedDefinitions().forEach(def -> {
            ChildElementAttributeHelper childHelper = new ChildElementAttributeHelper(def.getId(), false);
            childHelper.setInplace(true);
            childHelper.setXmlOrder(this.getXmlOrder());
            childHelper.setSubtypes(false);
            childHelper.setCreateEmpty(this.createEmpty((NodeDefinition)def));
            childHelper.setCaption(def.getName());
            this.editingModes.put(def.getId(), childHelper);
        });
    }

    private boolean createEmpty(NodeDefinition def) {
        return StringUtils.isEmpty((CharSequence)this.defaultType) || !this.defaultType.equals(def.getId());
    }

    public AttributeHelper getExpressionModeAttributeHelper() {
        AttributeHelper ref = new AttributeHelper(this.getId(), String.class, false);
        this.configureCommonProperties(ref);
        ref.setSupportsExpressions(true);
        return ref;
    }

    private void configureCommonProperties(AttributeHelper helper) {
        helper.setDescription(this.getDescription());
        helper.setRequired(this.isRequired());
        helper.setCanonicalPath(this.getCanonicalPath());
    }

    public AttributeHelper getBeanModeAttributeHelper() {
        AttributeHelper ref = new AttributeHelper(this.getId(), String.class, false);
        this.configureCommonProperties(ref);
        ref.setCaption("Bean Reference");
        return ref;
    }

    public GlobalRefAttributeHelper getGlobalModeAttributeHelper() {
        GlobalRefAttributeHelper hp = new GlobalRefAttributeHelper(this.getId(), String.class, false);
        this.configureCommonProperties(hp);
        hp.setCaption("Global reference");
        hp.setType("globalRef");
        hp.setAllowsSubTypes(this.allowsSubTypes);
        hp.setRequiredType((String)(this.globalTypes.size() > 1 ? "$" + this.globalTypes.stream().collect(Collectors.joining(",")) : this.globalTypes.stream().collect(Collectors.joining(","))));
        hp.setValidator(new AttributeReader.XMLAwareGlobalRefValidator(hp));
        hp.setHyperLinkProvider(new AttributeReader.GlobalRefHyperlinkProvider());
        hp.setImage(AttributeReader.idAtr);
        hp.setSaveAs(this.getId());
        return hp;
    }

    @Override
    protected List<AttributeHelper> parseChildNodes(Element element, AttributeGroup currentGroup, Artifact muleArtifact) {
        return Collections.emptyList();
    }

    public Map<String, AttributeHelper> getEditingModes() {
        this.editingModes.clear();
        if (this.supportsExpressionMode() && this.supportsBeanMode()) {
            refModeAttributeHelper = this.getExpressionModeAttributeHelper();
            this.editingModes.put(EXPRESSION_MODE, refModeAttributeHelper);
        } else {
            if (this.supportsExpressionMode()) {
                refModeAttributeHelper = this.getExpressionModeAttributeHelper();
                this.editingModes.put(EXPRESSION_MODE, refModeAttributeHelper);
            }
            if (this.supportsBeanMode()) {
                refModeAttributeHelper = this.getBeanModeAttributeHelper();
                this.editingModes.put(BEAN_MODE, refModeAttributeHelper);
            }
        }
        if (this.supportsGlobalMode()) {
            GlobalRefAttributeHelper globalModeAttributeHelper = this.getGlobalModeAttributeHelper();
            this.editingModes.put(GLOBAL_MODE, globalModeAttributeHelper);
        }
        if (this.supportsInlineMode()) {
            this.processChildModes();
        }
        return this.editingModes;
    }

    public boolean isAllowsSubTypes() {
        return this.allowsSubTypes;
    }

    public void setAllowsSubTypes(boolean allowsSubTypes) {
        this.allowsSubTypes = allowsSubTypes;
    }

    public List<String> getGlobalTypes() {
        return this.globalTypes;
    }

    public void setGlobalTypes(List<String> globalTypes) {
        this.globalTypes = globalTypes;
    }

    @Override
    public void generate(IElementWrapper element, MessageFlowEntity messageFlowEntity) {
        if (messageFlowEntity instanceof MessageFlowNode) {
            boolean found = false;
            MessageFlowNode node = (MessageFlowNode)messageFlowEntity;
            PropertyCollection nodeProperties = node.getPropertiesForEdit(element);
            String lookupName = this.getLookupAttributeName();
            IAttributeWrapper attrByQname = element.getAttribute(new QName(lookupName));
            IAttributeWrapper attrByName = element.getAttribute(lookupName);
            if (attrByQname != null || attrByName != null) {
                found = true;
                this.addAttributeProperty(nodeProperties, attrByQname == null ? attrByName : attrByQname);
            } else {
                found = this.addChildPropertyCollectionIfPresent(element, found, nodeProperties);
            }
            if (!found) {
                String mode = this.isRequired() ? (this.supportsExpressionMode() || this.supportsGlobalMode() || this.supportsBeanMode() ? MODE_ATTR : MODE_CHILD) : MODE_NONE;
                this.addAuxiliaryMode(nodeProperties, mode);
            }
        }
    }

    protected boolean addChildPropertyCollectionIfPresent(IElementWrapper element, boolean found, PropertyCollection nodeProperties) {
        List<NestedDefinition> nestedElementsFor = this.getAllowedDefinitions();
        INodeListWrapper lst = element.getChildElements();
        if (StringUtils.isNotBlank((CharSequence)this.wrapIn)) {
            QName wrapInQName = this.getWrapInQName();
            for (IElementWrapper childElement : lst) {
                if (!wrapInQName.equals(childElement.getQName())) continue;
                found = true;
                PropertyCollectionMap innerMap = new PropertyCollectionMap(childElement);
                PropertyCollection asPropertyCollection2 = innerMap.asPropertyCollection();
                PropertyCollection asPropertyCollection = this.generateProperty(nestedElementsFor, childElement);
                if (asPropertyCollection != null) {
                    asPropertyCollection2.addPropertyCollection(asPropertyCollection);
                }
                asPropertyCollection2.setName(PropertiesUtils.createNewCollectionId((String)this.wrapIn));
                nodeProperties.addPropertyCollection(asPropertyCollection2);
                this.addAuxiliaryMode(nodeProperties, MODE_CHILD);
                MessageFlowUtils.setElementXmlOrder((IElementWrapper)childElement, (int)this.getXmlOrder());
            }
        } else {
            PropertyCollection asPropertyCollection = this.generateProperty(nestedElementsFor, element);
            if (asPropertyCollection != null) {
                found = true;
                nodeProperties.addPropertyCollection(asPropertyCollection);
                this.addAuxiliaryMode(nodeProperties, MODE_CHILD);
            }
        }
        return found;
    }

    protected void addAttributeProperty(PropertyCollection nodeProperties, IAttributeWrapper attribute) {
        Property property = new Property();
        property.setName(this.id);
        String persistedValue = attribute.getText();
        String value = this.convert(persistedValue);
        property.setValue(value);
        nodeProperties.getProperties().add(property);
        this.addAuxiliaryMode(nodeProperties, MODE_ATTR);
    }

    private void addAuxiliaryMode(PropertyCollection nodeProperties, String mode) {
        Property propertyMode = new Property();
        propertyMode.setName(AUXILIARY_MODE + this.id);
        propertyMode.setValue(mode);
        nodeProperties.getProperties().add(propertyMode);
    }

    public QName getWrapInQName() {
        int lastIndexOfSlash = this.wrapIn.lastIndexOf(47);
        String namespaceURI = this.wrapIn.substring(0, lastIndexOfSlash);
        String localPart = this.wrapIn.substring(lastIndexOfSlash + 1);
        Namespace ns = Namespace.get((String)namespaceURI.substring(namespaceURI.lastIndexOf(47) + 1), (String)namespaceURI);
        return QNameUtils.get((String)localPart, (String)ns.getPrefix(), (String)ns.getURI());
    }

    public static QName getQName(NestedDefinition def) {
        String definitionId = def.getId();
        int lastIndexOfSlash = definitionId.lastIndexOf(47);
        String namespaceURI = definitionId.substring(0, lastIndexOfSlash);
        String localPart = definitionId.substring(lastIndexOfSlash + 1);
        Namespace ns = Namespace.get((String)namespaceURI.substring(namespaceURI.lastIndexOf(47) + 1), (String)namespaceURI);
        return QNameUtils.get((String)localPart, (String)ns.getPrefix(), (String)ns.getURI());
    }

    @Override
    public boolean isWellKnownProperty(IReadOnlyProperty property, Version currentVersion) {
        boolean isIncluded = this.getRange() == null || this.getRange().isIncluded(currentVersion);
        boolean isDeprecated = this.isDeprecatedIn(currentVersion.toString());
        boolean showDeprecatedElements = PaletteManager.INSTANCE.showDeprecatedComponents(currentVersion.toString());
        return this.getId().equals(property.getName()) && isIncluded && (!isDeprecated || isDeprecated && showDeprecatedElements);
    }

    @Override
    public void fillElement(IElementWrapper el, IMessageFlowNode node, PropertyCollectionMap propertyCollectionMap, IFlowTransformerContext context, IReadOnlyPropertyCollection collection, HashSet<String> handledElements) {
        block14: {
            Map<String, AttributeHelper> editingModes;
            List<NestedDefinition> allowedDefinitions;
            block15: {
                block13: {
                    String mode = propertyCollectionMap.getProperty(AUXILIARY_MODE + this.id, MODE_NONE);
                    allowedDefinitions = this.getAllowedDefinitions();
                    if (!MODE_ATTR.equals(mode)) break block13;
                    this.handleAttributeValue(el, propertyCollectionMap);
                    if (this.needsWrapper()) {
                        this.deleteMatchingElements(el, this.getWrapInQName());
                    } else {
                        for (NestedDefinition def : allowedDefinitions) {
                            this.deleteMatchingElements(el, MultiWayHelper.getQName(def));
                        }
                    }
                    break block14;
                }
                el.removeAttribute(this.id);
                editingModes = this.getEditingModes();
                if (this.needsWrapper()) break block15;
                for (NestedDefinition def : allowedDefinitions) {
                    AttributeHelper attributeHelper = editingModes.get(def.getId());
                    if (attributeHelper != null) {
                        attributeHelper.fillElement(el, node, propertyCollectionMap, context, collection, handledElements);
                        continue;
                    }
                    MuleCorePlugin.logWarning((String)("No attribute helper for:" + def.getId()));
                }
                if (allowedDefinitions.size() <= 1) break block14;
                this.deleteOtherChilds(el, collection, allowedDefinitions);
                break block14;
            }
            if (collection == null) {
                return;
            }
            for (IReadOnlyPropertyCollection nestedPropertyCollection : collection.getPropertyCollections()) {
                String nestedPropertyCollectionName = nestedPropertyCollection.getName();
                if (!this.wrapIn.equals(nestedPropertyCollectionName = nestedPropertyCollectionName.substring(1, nestedPropertyCollectionName.indexOf(59)))) continue;
                IElementWrapper element = nestedPropertyCollection.getElement();
                if (element == null) {
                    IDocumentWrapper document = node.getElement().getDocument();
                    QName childQName = this.getWrapInQName();
                    int xmlOrder = this.getXmlOrder();
                    Optional<IElementWrapper> maybeChildElement = Optional.ofNullable(el.getElement(childQName));
                    element = maybeChildElement.orElse(MessageFlowUtils.createElement((IDocumentWrapper)document, (QName)childQName, (int)xmlOrder));
                }
                if (nestedPropertyCollection.isErased()) {
                    if (element.getParent() == null) continue;
                    element.getParent().removeChild((INodeWrapper)element);
                    continue;
                }
                block3: for (IReadOnlyPropertyCollection wrappedCollection : nestedPropertyCollection.getPropertyCollections()) {
                    String wrappedCollectionName = wrappedCollection.getName();
                    wrappedCollectionName = wrappedCollectionName.substring(1, wrappedCollectionName.indexOf(59));
                    for (NestedDefinition def : allowedDefinitions) {
                        boolean shouldPreserveWrapper;
                        if (!def.getId().equals(wrappedCollectionName)) continue;
                        PropertyCollectionMap parentCollectionMap = propertyCollectionMap.getPropertyCollectionMap(nestedPropertyCollection.getName());
                        editingModes.get(def.getId()).fillElement(element, node, parentCollectionMap.getPropertyCollectionMap(wrappedCollection.getName()), context, nestedPropertyCollection, handledElements);
                        boolean hasParent = element.getParent() != null;
                        boolean bl = shouldPreserveWrapper = !element.getChildElements(MultiWayHelper.getQName(def)).isEmpty();
                        if (shouldPreserveWrapper) {
                            if (!hasParent) {
                                el.add((INodeWrapper)element);
                                continue block3;
                            }
                            this.deleteOtherChilds(element, nestedPropertyCollection, allowedDefinitions);
                            continue block3;
                        }
                        if (!hasParent) continue block3;
                        el.removeChild((INodeWrapper)element);
                        continue block3;
                    }
                }
            }
        }
    }

    protected void deleteOtherChilds(IElementWrapper el, IReadOnlyPropertyCollection collection, List<NestedDefinition> allowedDefinitions) {
        for (NestedDefinition def : allowedDefinitions) {
            boolean found = false;
            for (IReadOnlyPropertyCollection wrappedCollection : collection.getPropertyCollections()) {
                String wrappedCollectionName = wrappedCollection.getName();
                wrappedCollectionName = wrappedCollectionName.substring(1, wrappedCollectionName.indexOf(59));
                if (!def.getId().equals(wrappedCollectionName)) continue;
                found = true;
            }
            if (found) continue;
            this.deleteMatchingElements(el, MultiWayHelper.getQName(def));
        }
    }

    protected void deleteMatchingElements(IElementWrapper el, QName elementName) {
        INodeListWrapper childElements = el.getChildElements(elementName);
        while (!el.getChildElements(elementName).isEmpty()) {
            IElementWrapper childElement = (IElementWrapper)childElements.get(0);
            MessageFlowUtils.setElementXmlOrder((IElementWrapper)childElement, (int)this.getXmlOrder());
            el.removeChild((INodeWrapper)childElement);
            childElements = el.getChildElements(elementName);
        }
    }

    protected void handleAttributeValue(IElementWrapper el, PropertyCollectionMap propertyCollectionMap) {
        String attributeXmlName;
        String propertyValue = propertyCollectionMap.getProperty(this.id, "");
        boolean erased = Boolean.parseBoolean(propertyCollectionMap.getProperty("auxiliary;erased;" + this.id, Boolean.FALSE.toString()));
        String string = attributeXmlName = this.saveAs != null ? this.saveAs : this.id;
        if (!erased) {
            if (this.converter != null) {
                propertyValue = this.converter.convertModelToXML(propertyValue);
            }
            if (propertyValue.length() > 0) {
                Object defaultValue2 = this.getDefaultValue();
                if (defaultValue2 == null) {
                    defaultValue2 = "";
                }
                if (!propertyValue.equals(defaultValue2.toString()) || this.alwaysFill() || this.isFillWhenNotEmpty()) {
                    el.addAttribute(attributeXmlName, propertyValue);
                } else {
                    el.removeAttribute(attributeXmlName);
                }
            } else if (this.alwaysFill() && this.getDefaultValue() != null && !propertyCollectionMap.hasProperty(this.id)) {
                el.addAttribute(attributeXmlName, this.getDefaultValue().toString());
            } else if (this.isRequired() && !this.isFillWhenNotEmpty() || this.isAlwaysFillSimple()) {
                if (this.getDefaultValue() != null && !this.acceptsEmptyValue) {
                    el.addAttribute(attributeXmlName, this.getDefaultValue().toString());
                } else {
                    el.addAttribute(attributeXmlName, "");
                }
            }
        } else {
            el.removeAttribute(attributeXmlName);
        }
    }

    protected PropertyCollection generateProperty(List<NestedDefinition> nestedElementsFor, IElementWrapper rootElement) {
        for (IElementWrapper childElement : rootElement.getChildElements()) {
            for (NestedDefinition nestedDefinition : nestedElementsFor) {
                if (!nestedDefinition.matches(childElement.getQName())) continue;
                PropertyCollectionMap innerMap = new PropertyCollectionMap(childElement);
                NestedComponentMeta service = (NestedComponentMeta)nestedDefinition.getService(AbstractComponentMeta.class);
                service.generate(childElement, innerMap);
                PropertyCollection asPropertyCollection = innerMap.asPropertyCollection();
                String value = PropertiesUtils.createCollectionIdWithSuffix((String)nestedDefinition.getId(), (long)0L);
                asPropertyCollection.setName(value);
                MessageFlowUtils.setElementXmlOrder((IElementWrapper)childElement, (int)this.getXmlOrder());
                return asPropertyCollection;
            }
        }
        return null;
    }

    @Override
    public void fromElementToProperties(IElementWrapper muleModel, PropertyCollectionMap ms) {
        super.fromElementToProperties(muleModel, ms);
        if (ms.hasProperty(this.getId())) {
            Property propertyMode = new Property();
            propertyMode.setName(AUXILIARY_MODE + this.id);
            propertyMode.setValue(MODE_ATTR);
            ms.addProperty(propertyMode);
            return;
        }
        List<NestedDefinition> nestedElementsFor = this.getAllowedDefinitions();
        INodeListWrapper childElements = muleModel.getChildElements();
        PropertyCollectionMap parent = ms;
        if (this.needsWrapper()) {
            QName qName = this.getWrapInQName();
            for (IElementWrapper element : childElements) {
                if (!qName.equals(element.getQName())) continue;
                childElements = element.getChildElements();
                PropertyCollectionMap map = new PropertyCollectionMap(element);
                Property propertyMode = new Property();
                propertyMode.setName(AUXILIARY_MODE + this.id);
                propertyMode.setValue(MODE_CHILD);
                parent.addProperty(propertyMode);
                parent.addPropertyCollection(PropertiesUtils.createNewCollectionId((String)this.wrapIn), map);
                MessageFlowUtils.setElementXmlOrder((IElementWrapper)element, (int)this.getXmlOrder());
                parent = map;
                break;
            }
        }
        block1: for (IElementWrapper element : childElements) {
            for (NestedDefinition d : nestedElementsFor) {
                if (!d.matches(element.getQName())) continue;
                AbstractComponentMeta service = (AbstractComponentMeta)d.getService(AbstractComponentMeta.class);
                PropertyCollectionMap map = new PropertyCollectionMap(element);
                service.generate(element, map);
                Property propertyMode = new Property();
                propertyMode.setName(AUXILIARY_MODE + this.id);
                propertyMode.setValue(MODE_CHILD);
                parent.addProperty(propertyMode);
                parent.addPropertyCollection(PropertiesUtils.createNewCollectionId((String)d.getId()), map);
                MessageFlowUtils.setElementXmlOrder((IElementWrapper)element, (int)this.getXmlOrder());
                continue block1;
            }
        }
    }

    public List<NestedDefinition> getAllowedDefinitions() {
        ArrayList<NestedDefinition> nestedElementsFor = new ArrayList<NestedDefinition>();
        IMuleModuleManager moduleManager = MuleCorePlugin.getModuleManager();
        if (this.allowsSubTypes) {
            for (String type : this.allowedElements) {
                nestedElementsFor.addAll(moduleManager.getNestedDefinitionFor(type));
            }
        } else {
            for (String type : this.allowedElements) {
                NestedDefinition nestedElement = moduleManager.getNestedDefinition(type);
                if (nestedElement == null) continue;
                nestedElementsFor.add(nestedElement);
            }
        }
        this.getAllowedStereotypes().stream().forEach(stereotype -> {
            List collect = moduleManager.getNestedDefinitionFor(stereotype).stream().filter(x -> !nestedElementsFor.contains(x)).collect(Collectors.toList());
            nestedElementsFor.addAll(collect);
        });
        return nestedElementsFor.stream().sorted(new NodeDefinitionNameComparator()).collect(Collectors.toList());
    }

    public AttributeHelper getChildHelperFor(String caseId) {
        return this.getEditingModes().get(caseId);
    }

    public String getWrapIn() {
        return this.wrapIn;
    }

    public void setWrapIn(String wrapIn) {
        this.wrapIn = wrapIn;
    }

    public boolean needsWrapper() {
        return StringUtils.isNotBlank((CharSequence)this.wrapIn);
    }

    private List<String> getRequiredChildrenCaptions() {
        ArrayList<String> result = new ArrayList<String>();
        List<NestedDefinition> allowedDefinitions = this.getAllowedDefinitions();
        allowedDefinitions.forEach(def -> {
            if (def.getMuleElement() != null) {
                result.add(def.getMuleElement().getLocalPart());
            } else {
                result.add(def.getName());
            }
        });
        return result;
    }

    private boolean hasAnyChildren(IReadOnlyPropertyCollection property) {
        List<NestedDefinition> allowedDefinitions = this.getAllowedDefinitions();
        List possibleChildrenName = allowedDefinitions.stream().map(def -> def.getId()).collect(Collectors.toList());
        List childrenPropertyCollections = property.getPropertyCollections();
        for (IReadOnlyPropertyCollection childPropertyCollection : childrenPropertyCollections) {
            Optional<String> exists;
            String childName = childPropertyCollection.getName();
            if (childName == null || !(exists = possibleChildrenName.stream().filter(possible -> childName.startsWith("@" + possible)).findAny()).isPresent()) continue;
            return true;
        }
        return false;
    }

    public void validateMultiWay(IReadOnlyPropertyCollection propertyCollection, IProblemReporter reporter, DomainEditingModelObject pNode, int number) {
        if (this.isRequired()) {
            ChildrenValidation childrenValidation;
            DomainEditingModelObject node = pNode;
            if (this.supportsExpressionMode() || this.supportsGlobalMode()) {
                if (this.supportsInlineMode()) {
                    String attributeMessage = this.validateAttribute(propertyCollection);
                    if (StringUtils.isBlank((CharSequence)attributeMessage)) {
                        return;
                    }
                    ChildrenValidation childrenValidation2 = this.validateChildren(propertyCollection, (IDocumentElementNode)node);
                    if (StringUtils.isBlank((CharSequence)childrenValidation2.getMessage())) {
                        return;
                    }
                    if (childrenValidation2.getNode() != node) {
                        reporter.accept(4, childrenValidation2.getNode().getOffset(), MultiWayHelper.evalEnd(childrenValidation2.getNode()), childrenValidation2.getMessage(), number);
                        return;
                    }
                    reporter.accept(4, node.getOffset(), MultiWayHelper.evalEnd((IDocumentElementNode)node), "To configure '" + this.getCaption() + "', attribute '" + this.getId() + "' or child element " + String.valueOf(this.getRequiredChildrenCaptions()) + " needs to be specified", number);
                } else {
                    String attributeMessage = this.validateAttribute(propertyCollection);
                    if (StringUtils.isNotBlank((CharSequence)attributeMessage)) {
                        reporter.accept(4, node.getOffset(), MultiWayHelper.evalEnd((IDocumentElementNode)node), "Attribute '" + this.getId() + "' is required", number);
                    }
                }
            } else if (this.supportsInlineMode() && StringUtils.isNotBlank((CharSequence)(childrenValidation = this.validateChildren(propertyCollection, (IDocumentElementNode)node)).getMessage())) {
                reporter.accept(4, childrenValidation.getNode().getOffset(), MultiWayHelper.evalEnd(childrenValidation.getNode()), childrenValidation.getMessage(), number);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ChildrenValidation validateChildren(IReadOnlyPropertyCollection propertyCollection, IDocumentElementNode node) {
        ChildrenValidation result = new ChildrenValidation();
        if (this.needsWrapper()) {
            String wrapperCollectionPrefix = PropertiesUtils.createCollectionId((String)this.getWrapIn());
            Optional wrapperCollection = PropertiesUtils.findPropertyCollectionWithNamePrefix((IReadOnlyPropertyCollection)propertyCollection, (String)wrapperCollectionPrefix);
            if (!wrapperCollection.isPresent()) return result.withMessage("One of the following elements: " + String.valueOf(this.getRequiredChildrenCaptions()) + " is required and must be wrapped in " + this.getWrapInQName().getLocalPart()).withNode(node);
            propertyCollection = (IReadOnlyPropertyCollection)wrapperCollection.get();
            if (this.hasAnyChildren(propertyCollection)) return result.withNode(node);
            IDocumentElementNode[] childNodes = node.getChildNodes();
            return result.withMessage("One of the following elements: " + String.valueOf(this.getRequiredChildrenCaptions()) + " is required").withNode(childNodes.length > 0 ? childNodes[0] : node);
        }
        if (this.hasAnyChildren(propertyCollection)) return result.withNode(node);
        return result.withMessage("One of the following elements: " + String.valueOf(this.getRequiredChildrenCaptions()) + " is required").withNode(node);
    }

    private String validateAttribute(IReadOnlyPropertyCollection propertyCollection) {
        if (!this.hasAttribute(propertyCollection)) {
            return "Attribute '" + this.getId() + "' is required";
        }
        return "";
    }

    private boolean hasAttribute(IReadOnlyPropertyCollection propertyCollection) {
        IReadOnlyProperty property = (IReadOnlyProperty)propertyCollection.getProperty(this.getId());
        if (property != null) {
            return this.acceptsEmptyValue ? true : StringUtils.isNotBlank((CharSequence)property.getValue());
        }
        return false;
    }

    private static int evalEnd(IDocumentElementNode node) {
        String s = node.toString();
        int indexOfNewLine = s.indexOf(10);
        int start = node.getOffset();
        int end = start + (s.startsWith("<") && indexOfNewLine != -1 ? indexOfNewLine : s.length());
        return end;
    }

    public String getDefaultType() {
        return this.defaultType;
    }

    public void setDefaultType(String defaultType) {
        this.defaultType = defaultType;
    }

    public boolean hasDefaultType() {
        return StringUtils.isNotBlank((CharSequence)this.getDefaultType());
    }

    public Optional<String> getEmptyLabel() {
        return Optional.ofNullable(this.emptyLabel);
    }

    public void setEmptyLabel(String emptyLabel) {
        this.emptyLabel = emptyLabel;
    }

    public boolean supportsExpressionMode() {
        return this.isMode(EXPRESSION);
    }

    public boolean supportsBeanMode() {
        return this.isMode(BEAN);
    }

    public boolean supportsGlobalMode() {
        return this.isMode(GLOBAL);
    }

    public boolean supportsInlineMode() {
        return this.isMode(INLINE);
    }

    private boolean isMode(int mode) {
        return (this.modes & mode) == mode;
    }

    public static boolean isMultiwayInChildMode(PropertyCollectionMap properties, String helperId) {
        String modeProperty = AUXILIARY_MODE + helperId;
        String mode = properties.getProperty(modeProperty, MODE_NONE);
        return MODE_CHILD.equals(mode);
    }

    public Collection<String> getXmlNames() {
        Collection<String> xmlNames = this.needsWrapper() ? Collections.singleton(this.getWrapInQName().getLocalPart()) : (Collection)this.getAllowedDefinitions().stream().map(definition -> MultiWayHelper.getQName(definition).getLocalPart()).collect(Collectors.toList());
        return xmlNames;
    }

    public List<Stereotype> getAllowedStereotypes() {
        return this.allowedStereotypes;
    }

    public void setAllowedStereotypes(List<Stereotype> allowedStereotypes) {
        this.allowedStereotypes = allowedStereotypes;
    }

    public boolean isHideOnEmpty() {
        return this.hideOnEmpty;
    }

    public void setHideOnEmpty(boolean hideOnEmpty) {
        this.hideOnEmpty = hideOnEmpty;
    }

    private static class ChildrenValidation {
        private String message = "";
        private IDocumentElementNode node;

        private ChildrenValidation() {
        }

        public ChildrenValidation withMessage(String message) {
            this.message = message;
            return this;
        }

        public ChildrenValidation withNode(IDocumentElementNode node) {
            this.node = node;
            return this;
        }

        public String getMessage() {
            return this.message;
        }

        public IDocumentElementNode getNode() {
            return this.node;
        }
    }
}

