/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import org.eclipse.osgi.service.resolver.VersionRange;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.ui.modules.core.widgets.meta.IAnchorAware;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.MuleVersionRange;
import org.osgi.framework.Version;

public class MetaDescriptionEntry
implements IAnchorAware {
    protected String id;
    private VersionRange range;
    boolean eeOnly;
    protected String mode;
    protected String description;
    protected String caption;
    private String bottomAnchor;
    private String topAnchor;

    public boolean isEEOnly() {
        return this.eeOnly;
    }

    public void setEEOnly(boolean eeOnly) {
        this.eeOnly = eeOnly;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public VersionRange getRange() {
        return this.range;
    }

    public void setRange(MuleVersionRange muleVersionRange) {
        this.setRange(muleVersionRange.getVersionRange());
        this.setEEOnly(muleVersionRange.isEE());
    }

    public void setRange(VersionRange range) {
        this.range = range;
    }

    public void setRange(String range) {
        this.range = new VersionRange(range);
    }

    public boolean matches(String version) {
        if (this.range == null) {
            return true;
        }
        if (version.endsWith(";")) {
            version = version.substring(0, version.length() - 1);
        }
        return this.range.isIncluded(new Version(version));
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean matches(EndpointDirection direction) {
        if (direction != null && this.mode != null && this.mode.length() > 0) {
            if (direction == EndpointDirection.OUTBOUND) {
                return this.mode.equals("outbound");
            }
            return this.mode.equals("inbound");
        }
        return true;
    }

    public String toString() {
        return "MetaDescriptionEntry [id=" + this.id + ", range=" + String.valueOf(this.range) + ", eeOnly=" + this.eeOnly + ", caption=" + this.caption + "]";
    }

    @Override
    public String getTopAnchor() {
        return this.topAnchor;
    }

    public void setTopAnchor(String topAnchor) {
        this.topAnchor = topAnchor;
    }

    @Override
    public String getBottomAnchor() {
        return this.bottomAnchor;
    }

    public void setBottomAnchor(String bottomAnchor) {
        this.bottomAnchor = bottomAnchor;
    }
}

