/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.text.NumberFormat;
import org.mule.tooling.core.utils.ExpressionUtils;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeValidator;

public class LongAttributeHelper
extends AttributeHelper {
    public static final String VALUE_MUST_BE_GREATER_THAN_MESSAGE = "Value must be greater than ";
    public static final String VALUE_MUST_BE_SMALLER_THAN_MESSAGE = "Value must be smaller than ";
    protected long max;
    protected long min;
    protected long step;

    public LongAttributeHelper(String id, Class<?> type, boolean required) {
        super(id, type, required);
        this.setValidator(new LongAttributeValidator());
    }

    public long getMax() {
        return this.max;
    }

    public void setMax(long max) {
        this.max = max;
    }

    public long getMin() {
        return this.min;
    }

    public void setMin(long min) {
        this.min = min;
    }

    public long getStep() {
        return this.step;
    }

    public void setStep(long step) {
        this.step = step;
    }

    private final class LongAttributeValidator
    extends AttributeValidator {
        private static final String VALUE_MUST_BE_A_LONG_OR_INTEGER = "Value must be a long or integer";

        private LongAttributeValidator() {
        }

        @Override
        public String validate(Object value, AttributeContext context, AttributeHelper helper) {
            if (value == null) {
                value = "";
            }
            if (value.toString().trim().length() == 0) {
                return null;
            }
            String result = this.validateExpression(value.toString(), helper.isSupportsExpressions());
            if (result != null) {
                return result;
            }
            if (!ExpressionUtils.isExpressionOrProperty((String)value.toString())) {
                try {
                    long parseDouble = Long.parseLong(value.toString());
                    if (parseDouble < LongAttributeHelper.this.min && parseDouble != -1L) {
                        return LongAttributeHelper.VALUE_MUST_BE_GREATER_THAN_MESSAGE + NumberFormat.getNumberInstance().format(LongAttributeHelper.this.min);
                    }
                    if (parseDouble > LongAttributeHelper.this.max) {
                        return LongAttributeHelper.VALUE_MUST_BE_SMALLER_THAN_MESSAGE + NumberFormat.getNumberInstance().format(LongAttributeHelper.this.max);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    return this.getAllowedTypesMessage(VALUE_MUST_BE_A_LONG_OR_INTEGER, helper.isSupportsExpressions());
                }
            }
            return null;
        }
    }
}

