/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.widgets.meta.AfterSaveCorrection;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributesPersistenceTransformer;

public final class LoadScriptPersistenceTransformer
implements AttributesPersistenceTransformer,
AfterSaveCorrection {
    final String _text = "text";
    final String _innerText = "inner-text";
    final String _changed = "changed";

    @Override
    public final void onLoad(IMessageFlowNode node, PropertyCollectionMap props) {
        String text = props.getProperty("text", "");
        String innerText = props.getProperty("inner-text", "");
        if (LoadScriptPersistenceTransformer.allSpaces(text) && !LoadScriptPersistenceTransformer.allSpaces(innerText)) {
            props.addProperty("text", innerText);
            props.addProperty("inner-text", null);
            props.addProperty("changed", "true");
        }
    }

    private static boolean allSpaces(String s) {
        int i = 0;
        while (i < s.length()) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public final void onSave(IMessageFlowNode node, PropertyCollectionMap props) {
    }

    @Override
    public void afterSave(IMessageFlowNode node, PropertyCollectionMap props) {
        String changed = props.getProperty("changed", "false");
        String text = props.getProperty("text", "");
        if (Boolean.parseBoolean(changed)) {
            props.addProperty("inner-text", text);
            props.addProperty("text", null);
        }
        props.addProperty("changed", null);
    }
}

