/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.decorator.PropertiesMap;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.widgets.meta.AfterSaveCorrection;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributesPersistenceTransformer;
import org.mule.tooling.ui.modules.core.widgets.meta.PersistenceTransformerUtils;

public final class JoiningPersistenceTransformer
implements AttributesPersistenceTransformer,
AfterSaveCorrection {
    private final String id;
    private final String joinWith;

    public JoiningPersistenceTransformer(String id, String joinWith) {
        this.id = id;
        this.joinWith = joinWith;
    }

    @Override
    public void afterSave(IMessageFlowNode node, PropertyCollectionMap props) {
        Map collections = props.getPropertyCollections();
        PropertyCollectionMap my = PersistenceTransformerUtils.findCollection(collections, this.id);
        PropertyCollectionMap joined = PersistenceTransformerUtils.findCollection(collections, this.joinWith);
        if (my != null && joined != null) {
            this.copyProperties(my, joined);
            PersistenceTransformerUtils.deleteCollection(collections, this.id);
        }
    }

    @Override
    public void onLoad(IMessageFlowNode node, PropertyCollectionMap props) {
        Map collections = props.getPropertyCollections();
        PropertyCollectionMap my = PersistenceTransformerUtils.findCollection(collections, this.id);
        PropertyCollectionMap joined = PersistenceTransformerUtils.findCollection(collections, this.joinWith);
        if (joined == null) {
            joined = new PropertyCollectionMap();
            collections.put(PersistenceTransformerUtils.generatePropertyMapNameFor(this.joinWith, "0"), joined);
        }
        if (my != null) {
            this.copyProperties(my, joined);
        }
    }

    @Override
    public void onSave(IMessageFlowNode node, PropertyCollectionMap props) {
    }

    protected void copyProperties(PropertyCollectionMap source, PropertyCollectionMap destination) {
        PropertiesMap propertiesMap = source.getPropertiesMap();
        List list = propertiesMap.asPropertyList();
        for (Property property : list) {
            destination.addProperty(property.getName(), property.getValue());
        }
        Map propertyCollections = source.getPropertyCollections();
        Set myEntries = propertyCollections.entrySet();
        for (Map.Entry myEntry : myEntries) {
            destination.getPropertyCollections().put((String)myEntry.getKey(), (PropertyCollectionMap)myEntry.getValue());
        }
    }
}

