/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModelObject;
import java.util.List;
import org.mule.tooling.core.validation.Message;
import org.mule.tooling.core.validation.MessageBuilder;
import org.mule.tooling.core.validation.ValidationConstants;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.GlobalRefEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.IComponentValidator;

public class JMSEndpointValidator
implements IComponentValidator {
    private String CONNECTOR_REF_VALIDATION_MESSAGE = "'connector-ref' attribute is required";

    protected Message validateConnectorRef(String value) {
        if (value == null || value.length() == 0) {
            return MessageBuilder.newInfoMessage((String)this.CONNECTOR_REF_VALIDATION_MESSAGE).build();
        }
        return ValidationConstants.MESSAGE_OK;
    }

    @Override
    public Message validateComponent(DomainEditingModelObject pNode) {
        String connectorRefValue = pNode.getXMLAttributeValue("connector-ref");
        return this.validateConnectorRef(connectorRefValue);
    }

    @Override
    public Message validateComponentGUI(IMessageFlowNode node, List<IFieldEditor> editors) {
        String connectorRefValue = null;
        for (IFieldEditor editor : editors) {
            String id;
            AttributeHelper helper = editor.getHelper();
            if (helper == null || !"connector-ref".equals(id = helper.id) || !(editor instanceof GlobalRefEditor)) continue;
            GlobalRefEditor connectorRefEditor = (GlobalRefEditor)editor;
            connectorRefValue = connectorRefEditor.getPublicValue();
        }
        return this.validateConnectorRef(connectorRefValue);
    }
}

