/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.core.utils.ExpressionUtils;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeValidator;

public class IntegerAttributeHelper
extends AttributeHelper {
    private static final String LONG = "long";
    private static final String VALUE_MUST_BE_LESS_OR_EQUAL_TO = "Value must be less or equal to ";
    private static final String VALUE_MUST_BE_GREATER_OR_EQUAL_TO = "Value must be greater or equal to ";
    private final Strategy strategy;

    public static <T> T or(T lhs, T rhs) {
        return lhs != null ? lhs : rhs;
    }

    public IntegerAttributeHelper(String id, Class<?> type, boolean required, String javaType, String min, String max, String step, String defaultValue) {
        super(id, type, required);
        String strategyDefaultValue = ExpressionUtils.isExpressionOrProperty((String)defaultValue) ? "" : defaultValue;
        Strategy strategy = this.strategy = IntegerAttributeHelper.isLong(javaType) ? new LongStrategy(min, max, step, strategyDefaultValue) : new IntStrategy(min, max, step, strategyDefaultValue);
        if (StringUtils.isNotBlank((CharSequence)defaultValue)) {
            this.setDefaultValue(defaultValue);
        }
        this.setValidator(new IntegerAttributeValidator());
    }

    private static boolean isLong(String javaType) {
        return LONG.equals(javaType);
    }

    private static class IntStrategy
    implements Strategy {
        final Integer min;
        final Integer max;
        final Integer defaultValue;

        IntStrategy(String min, String max, String step, String defaultValue) {
            this.min = IntegerAttributeHelper.or(IntStrategy.parse(min), Integer.MIN_VALUE);
            this.max = IntegerAttributeHelper.or(IntStrategy.parse(max), Integer.MAX_VALUE);
            this.defaultValue = IntStrategy.parse(defaultValue);
        }

        static Integer parse(String value) {
            return value.length() > 0 ? Integer.valueOf(Integer.parseInt(value)) : null;
        }

        @Override
        public String validate(String stringToValidate, String allowedTypesMessage) {
            int number;
            block5: {
                try {
                    int defVal;
                    number = Integer.parseInt(stringToValidate);
                    if (this.defaultValue == null || number != (defVal = this.defaultValue.intValue())) break block5;
                    return null;
                }
                catch (NumberFormatException numberFormatException) {
                    return allowedTypesMessage;
                }
            }
            if (number < this.min) {
                return IntegerAttributeHelper.VALUE_MUST_BE_GREATER_OR_EQUAL_TO + this.min.toString();
            }
            if (number > this.max) {
                return IntegerAttributeHelper.VALUE_MUST_BE_LESS_OR_EQUAL_TO + this.max.toString();
            }
            return null;
        }
    }

    private static final class IntegerAttributeValidator
    extends AttributeValidator {
        private static final String VALUE_MUST_BE_AN_INTEGER = "Value must be an integer";

        private IntegerAttributeValidator() {
        }

        @Override
        public String validate(Object value, AttributeContext context, AttributeHelper helper) {
            String stringToValidate;
            String string = stringToValidate = value == null ? "" : value.toString();
            if (stringToValidate.trim().isEmpty()) {
                return null;
            }
            boolean supportsExpressions = helper.isSupportsExpressions();
            String result = this.validateExpression(stringToValidate, supportsExpressions);
            if (result != null) {
                return result;
            }
            if (!ExpressionUtils.isExpressionOrProperty((String)stringToValidate)) {
                IntegerAttributeHelper intHelper = (IntegerAttributeHelper)helper;
                return intHelper.strategy.validate(stringToValidate, this.getAllowedTypesMessage(VALUE_MUST_BE_AN_INTEGER, supportsExpressions));
            }
            return null;
        }
    }

    private static class LongStrategy
    implements Strategy {
        final Long min;
        final Long max;
        final Long defaultValue;

        LongStrategy(String min, String max, String step, String defaultValue) {
            this.min = IntegerAttributeHelper.or(LongStrategy.parse(min), Long.MIN_VALUE);
            this.max = IntegerAttributeHelper.or(LongStrategy.parse(max), Long.MAX_VALUE);
            this.defaultValue = LongStrategy.parse(defaultValue);
        }

        static Long parse(String value) {
            return value.length() > 0 ? Long.valueOf(Long.parseLong(value)) : null;
        }

        @Override
        public String validate(String stringToValidate, String allowedTypesMessage) {
            long number;
            block5: {
                try {
                    long defVal;
                    number = Long.parseLong(stringToValidate);
                    if (this.defaultValue == null || number != (defVal = this.defaultValue.longValue())) break block5;
                    return null;
                }
                catch (NumberFormatException numberFormatException) {
                    return allowedTypesMessage;
                }
            }
            if (number < this.min) {
                return IntegerAttributeHelper.VALUE_MUST_BE_GREATER_OR_EQUAL_TO + this.min.toString();
            }
            if (number > this.max) {
                return IntegerAttributeHelper.VALUE_MUST_BE_LESS_OR_EQUAL_TO + this.max.toString();
            }
            return null;
        }
    }

    public static interface Strategy {
        public String validate(String var1, String var2);
    }
}

