/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.tooling.core.module.Artifact;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractCompositeAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GroupTabsAttributeHelper
extends AbstractCompositeAttributeHelper {
    private final Map<String, Map.Entry<String, List<AttributeHelper>>> items = new HashMap<String, Map.Entry<String, List<AttributeHelper>>>();

    public GroupTabsAttributeHelper(String id, String description) {
        super(id, Object.class, false, description);
    }

    @Override
    protected void parseSpecificAttributes(Element element) {
    }

    @Override
    protected List<AttributeHelper> parseChildNodes(Element element, AttributeGroup currentGroup, Artifact muleArtifact) {
        NodeList childNodes = element.getChildNodes();
        int nChildren = childNodes.getLength();
        ArrayList<AttributeHelper> allHelpers = new ArrayList<AttributeHelper>();
        int i = 0;
        while (i < nChildren) {
            Element item;
            Node node = childNodes.item(i);
            if (node instanceof Element && (item = (Element)node).getTagName().equals("tabItem")) {
                List<AttributeHelper> children = super.parseChildNodes(item, currentGroup, muleArtifact);
                String itemId = item.getAttribute("id");
                String itemName = item.getAttribute("name");
                children.forEach(ah -> ah.setParent(itemId));
                allHelpers.addAll(children);
                AbstractMap.SimpleEntry<String, List<AttributeHelper>> itemChildren = new AbstractMap.SimpleEntry<String, List<AttributeHelper>>(itemName, children);
                this.items.put(itemId, itemChildren);
            }
            ++i;
        }
        return allHelpers;
    }

    public Map<String, Map.Entry<String, List<AttributeHelper>>> getItems() {
        return this.items;
    }
}

