/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.IEditorSelectionListener;
import org.mule.tooling.ui.modules.core.widgets.meta.IHasListener;

public class GlobalRefAttributeHelper
extends AttributeHelper
implements IHasListener {
    public IEditorSelectionListener listener;
    private String additionalCheckbox = null;
    private String attrName = "name";
    private String requiredType;
    private boolean allowsSubTypes;

    public GlobalRefAttributeHelper(String id, Class<?> type, boolean required) {
        super(id, type, required);
    }

    @Override
    public IEditorSelectionListener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(IEditorSelectionListener listener) {
        this.listener = listener;
    }

    public String getAttrName() {
        return this.attrName;
    }

    public void setAttrName(String attrName) {
        this.attrName = attrName;
    }

    public void setRequiredType(String attribute) {
        this.requiredType = attribute;
    }

    public void setAdditionalCheckbox(String additionalCheckbox) {
        this.additionalCheckbox = additionalCheckbox;
    }

    public String getAdditionalCheckbox() {
        return this.additionalCheckbox;
    }

    public boolean isAllowsSubTypes() {
        return this.allowsSubTypes;
    }

    public void setAllowsSubTypes(boolean allowsSubTypes) {
        this.allowsSubTypes = allowsSubTypes;
    }

    public String getRequiredType(String version) {
        if (this.allowsSubTypes) {
            Object calcRequiredType = this.requiredType.startsWith("$") ? this.requiredType.substring(1) : this.requiredType;
            calcRequiredType = "$" + GlobalRefAttributeHelper.getAllowedGlobalDefinitions(this.allowsSubTypes, Arrays.asList(((String)calcRequiredType).split(","))).stream().map(NodeDefinition::getId).collect(Collectors.joining(","));
            return GlobalRefAttributeHelper.getRequiredType((String)calcRequiredType, version);
        }
        return GlobalRefAttributeHelper.getRequiredType(this.requiredType, version);
    }

    private static String getRequiredType(String requiredType, String version) {
        if (version.indexOf(59) != -1) {
            String string = "http://www.mulesoft.org/schema/mule/";
            if (requiredType != null && requiredType.startsWith(string)) {
                String substring = requiredType.substring(string.length());
                String tp = string + "ee/" + substring;
                GlobalDefinition global = MuleCorePlugin.getModuleManager().getGlobalDefinition(tp);
                if (global != null) {
                    return global.getId();
                }
            }
            return requiredType;
        }
        return requiredType;
    }

    public static List<GlobalDefinition> getAllowedGlobalDefinitions(boolean allowsSubTypes, List<String> globalTypes) {
        ArrayList<GlobalDefinition> globalDefinitions = new ArrayList<GlobalDefinition>();
        IMuleModuleManager moduleManager = MuleCorePlugin.getModuleManager();
        if (allowsSubTypes) {
            GlobalRefAttributeHelper.updateGlobalDefinitionsWithSubtypes(globalDefinitions, moduleManager, globalTypes);
        } else {
            GlobalRefAttributeHelper.updateDefinedGlobalTypes(globalDefinitions, moduleManager, globalTypes);
        }
        return globalDefinitions;
    }

    private static void updateGlobalDefinitionsWithSubtypes(List<GlobalDefinition> globalDefinitions, IMuleModuleManager moduleManager, List<String> globalTypes) {
        for (String type : globalTypes) {
            globalDefinitions.addAll(moduleManager.getGlobalDefinitionsFor(type));
        }
    }

    private static void updateDefinedGlobalTypes(List<GlobalDefinition> globalDefinitions, IMuleModuleManager moduleManager, List<String> globalTypes) {
        for (String type : globalTypes) {
            GlobalDefinition globalDef = moduleManager.getGlobalDefinition(type);
            if (globalDef == null || globalDef.isAbstract()) continue;
            globalDefinitions.add(globalDef);
        }
    }
}

