/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.HashSet;
import java.util.LinkedHashMap;
import javax.xml.namespace.QName;
import org.dom4j.Namespace;
import org.mule.tooling.core.Category;
import org.mule.tooling.editor.model.element.Stereotype;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.internal.metadata.GlobalNameKey;
import org.mule.tooling.ui.modules.core.metadata.MetadataCacheKeyProvider;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractContributionHandler;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeCategory;
import org.mule.tooling.ui.modules.core.widgets.meta.GlobalComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.MuleStereotypes;
import org.w3c.dom.Element;

public class GlobalContributionHandler
extends AbstractContributionHandler<GlobalDefinition> {
    public static boolean isGlobalTransformer(String category) {
        return category.equals("org.mule.tooling.globalCategory.transformers");
    }

    public static boolean isBeanCategory(String category) {
        return category.equals("org.mule.tooling.globalCategory.bean");
    }

    @Override
    protected String getDefaultCategory(Element element) {
        if (element.getNodeName().equals("global-filter")) {
            return Category.GLOBAL_FILTERS.getCategoryString();
        }
        if (element.getNodeName().equals("global-transformer")) {
            return Category.GLOBAL_TRANSFORMERS.getCategoryString();
        }
        if (element.getNodeName().equals("global-endpoint")) {
            return Category.GLOBAL_ENDPOINTS.getCategoryString();
        }
        if (element.getNodeName().equals("global-cloud-connector")) {
            return Category.GLOBAL_CLOUD_CONNECTORS.getCategoryString();
        }
        if (element.getNodeName().equals("global-bean")) {
            return "org.mule.tooling.category.bean";
        }
        return Category.GLOBAL_CONNECTORS.getCategoryString();
    }

    @Override
    protected AbstractComponentMeta createComponentMeta(Namespace ns, GlobalDefinition global, LinkedHashMap<String, AttributeCategory> loadCommonProperties, HashSet<String> doNotInherit) {
        return new GlobalComponentMeta(ns, (NodeDefinition)global, loadCommonProperties, doNotInherit);
    }

    @Override
    protected void addSpecificMeta(GlobalDefinition nodeDefinition) {
        nodeDefinition.registerService(MetadataCacheKeyProvider.class, (Object)GlobalNameKey.getInstance());
    }

    @Override
    protected GlobalDefinition createNodeDefinition(Namespace ns, Element element) {
        GlobalDefinition globalDefinition = new GlobalDefinition();
        String localNamesAtr = element.getAttribute("localId");
        String attribute = element.getAttribute("xmlname");
        if (localNamesAtr.length() != 0) {
            String[] localNames;
            String[] stringArray = localNames = localNamesAtr.split(",");
            int n = localNames.length;
            int n2 = 0;
            while (n2 < n) {
                String localName = stringArray[n2];
                QName createQName = this.createQName(ns, attribute.length() > 0 ? attribute : localName);
                globalDefinition.getMuleElements().add(createQName);
                globalDefinition.getMuleElements().add(this.createQName(ns, localName));
                ++n2;
            }
        } else {
            QName createQName = this.createQName(ns, attribute.length() > 0 ? attribute : element.getNodeName());
            globalDefinition.getMuleElements().add(createQName);
        }
        return globalDefinition;
    }

    @Override
    protected Stereotype getDefaultStereotype() {
        return MuleStereotypes.APP_CONFIG;
    }
}

