/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.ArrayList;
import java.util.List;
import org.mule.tooling.core.utils.ExpressionUtils;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IValidator;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;

public class FlowAttributeHelper
extends AttributeHelper {
    private static final String MESSAGE_1 = "Reference to unknown sub flow:";
    private static final String MESSAGE_2 = "Reference to unknown flow:";
    private static final String MESSAGE_3 = "Reference to unknown flow or sub flow:";
    private boolean removeEmptyOption = false;
    private boolean subFlow = true;
    private boolean flows;

    public FlowAttributeHelper(String id, boolean req) {
        super(id, String.class, req);
        this.setValidator(new IValidator(){

            @Override
            public String validate(Object value, AttributeContext context, AttributeHelper helper) {
                if (value == null || value.toString().length() == 0 || ExpressionUtils.isExpressionOrProperty((String)value.toString())) {
                    return null;
                }
                MuleConfiguration config = context.getMuleConfiguration();
                List flowsFromAllFiles = context.getFlows();
                List flowsFromCurrentFile = config.getFlows();
                ArrayList allFlows = new ArrayList();
                allFlows.ensureCapacity(flowsFromCurrentFile.size() + flowsFromAllFiles.size());
                allFlows.addAll(flowsFromAllFiles);
                allFlows.addAll(flowsFromCurrentFile);
                boolean found = false;
                for (Container f : allFlows) {
                    String flowName = f.getName();
                    if (flowName == null || !flowName.equals(value)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    if (FlowAttributeHelper.this.isSubFlow() && !FlowAttributeHelper.this.isFlows()) {
                        return FlowAttributeHelper.MESSAGE_1;
                    }
                    if (!FlowAttributeHelper.this.isSubFlow() && FlowAttributeHelper.this.isFlows()) {
                        return FlowAttributeHelper.MESSAGE_2;
                    }
                    if (FlowAttributeHelper.this.isSubFlow() && FlowAttributeHelper.this.isFlows()) {
                        return "Reference to unknown flow or sub flow: \"" + value.toString() + "\"";
                    }
                }
                return null;
            }
        });
    }

    @Deprecated
    public boolean isSubflows() {
        return this.subFlow;
    }

    public boolean isSubFlow() {
        return this.subFlow;
    }

    public void setSubFlow(boolean subFlow) {
        this.subFlow = subFlow;
    }

    public void setFlows(boolean flows) {
        this.flows = flows;
    }

    public boolean isFlows() {
        return this.flows;
    }

    public boolean isRemoveEmptyOption() {
        return this.removeEmptyOption;
    }

    public void setRemoveEmptyOption(boolean removeEmptyOption) {
        this.removeEmptyOption = removeEmptyOption;
    }

    @Override
    public boolean shouldAddEmptyOption() {
        return super.shouldAddEmptyOption() && !this.isRemoveEmptyOption();
    }
}

