/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.ArrayList;
import java.util.List;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.ExpressionUtils;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IValidator;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;

public class ErrorHandlerValidator
implements IValidator {
    private static final String MESSAGE = "Reference to unknown";

    @Override
    public String validate(Object value, AttributeContext context, AttributeHelper helper) {
        if (value == null || value.toString().length() == 0 || ExpressionUtils.isExpressionOrProperty((String)value.toString())) {
            return null;
        }
        IMuleProject muleProject = context.getProject();
        if (muleProject != null) {
            List configurations = muleProject.getConfigurationsCache().getConfigurations();
            List<String> values = this.possibleValues(configurations);
            int i = 0;
            while (i < values.size()) {
                if (values.get(i).equals(value.toString())) {
                    return null;
                }
                ++i;
            }
            return "Reference to unknown \"" + value.toString() + "\"";
        }
        return null;
    }

    private List<String> possibleValues(List<MuleConfiguration> configurations) {
        ArrayList<String> errorHandlers = new ArrayList<String>();
        for (MuleConfiguration muleConfiguration : configurations) {
            List flows = muleConfiguration.getFlows();
            for (Container container : flows) {
                if (!"http://www.mulesoft.org/schema/mule/core/default-error-handler".equals(container.getType())) continue;
                errorHandlers.add(container.getName());
            }
        }
        return errorHandlers;
    }
}

