/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModelObject;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentElementNode;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.core.validation.Message;
import org.mule.tooling.core.validation.MessageBuilder;
import org.mule.tooling.core.validation.ValidationConstants;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.IComponentValidator;

public class ErrorHandlerComponentValidator
implements IComponentValidator {
    private static final String EVERY_HANDLER_ERROR = "Every handler (except for the last one) within an 'error-handler' must specify a 'when' or 'type' attribute";

    @Override
    public Message validateComponent(DomainEditingModelObject pNode) {
        List childNodes = pNode.getChildNodesList();
        int childCount = childNodes.size();
        int i = 0;
        while (i < childNodes.size()) {
            Message valid = this.validate((IDocumentElementNode)childNodes.get(i), i >= childCount - 1);
            if (valid != ValidationConstants.MESSAGE_OK) {
                return valid;
            }
            ++i;
        }
        return ValidationConstants.MESSAGE_OK;
    }

    private Message validate(IDocumentElementNode node, boolean lastNode) {
        if (!lastNode) {
            String whenValue;
            String typeValue = node.getXMLAttributeValue("type") == null ? "" : node.getXMLAttributeValue("type");
            String string = whenValue = node.getXMLAttributeValue("when") == null ? "" : node.getXMLAttributeValue("when");
            if (StringUtils.isBlank((CharSequence)(typeValue + whenValue))) {
                return MessageBuilder.newErrorMessage((String)EVERY_HANDLER_ERROR).build();
            }
        }
        return ValidationConstants.MESSAGE_OK;
    }

    @Override
    public Message validateComponentGUI(IMessageFlowNode node, List<IFieldEditor> editors) {
        return ValidationConstants.MESSAGE_OK;
    }
}

