/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.core.utils.ExpressionUtils;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IValidator;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;

public class EnumValidator
implements IValidator {
    @Override
    public String validate(Object value, AttributeContext context, AttributeHelper helper) {
        Collection<EnumOption> options = ((EnumHelper)helper).getOptions();
        StringBuilder possibleEnumValuesDescription = new StringBuilder("Value should be one of the following: ");
        String stringValue = value.toString();
        if (!helper.isRequired() && StringUtils.isBlank((CharSequence)stringValue)) {
            return null;
        }
        if (options.isEmpty()) {
            return null;
        }
        if (helper.isSupportsExpressions() && ExpressionUtils.isExpression((String)stringValue) || ExpressionUtils.isPropertyPlaceholder((String)stringValue)) {
            return null;
        }
        int i = 0;
        for (EnumOption option : options) {
            if (option.value.equals(stringValue)) {
                return null;
            }
            possibleEnumValuesDescription.append(option.value);
            if (i != options.size() - 1) {
                possibleEnumValuesDescription.append(", ");
            }
            ++i;
        }
        return possibleEnumValuesDescription.toString();
    }
}

