/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.core.utils.ExpressionUtils;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.Sort;

public class EnumOption {
    protected static final String EMPTY_OPTION_VALUE = "";
    protected static final String NONE_CAPTION = "-- Empty --";
    protected static final String EMPTY_EXPRESSION_CAPTION = "";
    protected static final String DEFAULT_CAPTION_SUFFIX = " (Default)";
    private static final Comparator<EnumOption> COMPARATOR = new EnumOptionComparator(Sort.ASC);
    private static final Comparator<EnumOption> REVERSED_COMPARATOR = new EnumOptionComparator(Sort.DESC);
    public final String value;
    public final String caption;
    protected String versions;
    private boolean isReadOnly;
    private boolean isUnknown;

    public EnumOption(String value, String caption, String defaultValue, boolean isReadOnly) {
        this.value = value;
        if (StringUtils.isBlank((String)caption)) {
            caption = value;
        }
        this.caption = StringUtils.isNotEmpty((String)defaultValue) && defaultValue.equals(value) ? caption + DEFAULT_CAPTION_SUFFIX : caption;
        this.isReadOnly = isReadOnly;
        this.isUnknown = false;
    }

    public EnumOption(String value, String caption, String defaultValue, boolean isReadOnly, boolean isUnknown) {
        this.value = value;
        if (StringUtils.isBlank((String)caption)) {
            caption = value;
        }
        this.caption = StringUtils.isNotEmpty((String)defaultValue) && defaultValue.equals(value) ? caption + DEFAULT_CAPTION_SUFFIX : caption;
        this.isReadOnly = isReadOnly;
        this.isUnknown = isUnknown;
    }

    public EnumOption(String value, String caption, String defaultValue) {
        this(value, caption, defaultValue, false);
    }

    public EnumOption(String value, String caption, boolean isReadOnly) {
        this(value, caption, null, isReadOnly);
    }

    public EnumOption(String value, String caption, boolean isReadOnly, boolean isUnknown) {
        this(value, caption, null, isReadOnly, isUnknown);
    }

    public EnumOption(String value, String caption) {
        this(value, caption, null);
    }

    public EnumOption(String valueAndLabel) {
        this(valueAndLabel, valueAndLabel);
    }

    public String toString() {
        return this.value + " -> " + this.caption;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumOption other = (EnumOption)obj;
        if (this.value == null && other.value != null) {
            return false;
        }
        return this.value.equals(other.value);
    }

    public static void sortOptions(List<EnumOption> options, Sort sortMethod) {
        if (sortMethod == Sort.NONE) {
            int emptyOptionIndex = options.indexOf(EnumOption.getEmptyOption());
            if (emptyOptionIndex > 0) {
                EnumOption emptyOption = options.remove(emptyOptionIndex);
                options.add(0, emptyOption);
            }
            return;
        }
        Collections.sort(options, sortMethod.equals((Object)Sort.ASC) ? COMPARATOR : REVERSED_COMPARATOR);
    }

    public static EnumOption getEmptyOption() {
        return EnumOption.getEmptyOption(null);
    }

    public static EnumOption getEmptyOption(AttributeHelper attribute) {
        boolean allowsCustom = attribute instanceof EnumHelper ? ((EnumHelper)attribute).isAllowsCustom() : false;
        String caption = !allowsCustom ? NONE_CAPTION : "";
        return new EnumOption("", caption);
    }

    public boolean isEmptyOption() {
        return EnumOption.getEmptyOption().equals(this);
    }

    public String getVersions() {
        return this.versions;
    }

    public EnumOption setVersions(String versions) {
        this.versions = versions;
        return this;
    }

    public boolean isUnknown() {
        return this.isUnknown;
    }

    public void setUnknown(boolean isUnknown) {
        this.isUnknown = isUnknown;
    }

    public String getCaption() {
        return this.caption;
    }

    static final class EnumOptionComparator
    implements Comparator<EnumOption> {
        private Sort sortMethod;

        public EnumOptionComparator(Sort sortMethod) {
            this.sortMethod = sortMethod;
        }

        @Override
        public int compare(EnumOption lhs, EnumOption rhs) {
            String label2;
            String label1 = lhs.caption != null ? lhs.caption : "";
            String string = label2 = rhs.caption != null ? rhs.caption : "";
            if (lhs.isEmptyOption()) {
                return -1;
            }
            if (rhs.isEmptyOption()) {
                return 1;
            }
            if (ExpressionUtils.isExpressionOrProperty((String)label1)) {
                return -1;
            }
            if (ExpressionUtils.isExpressionOrProperty((String)label2)) {
                return 1;
            }
            return label1.toUpperCase().compareTo(label2.toUpperCase()) * (this.sortMethod == Sort.ASC ? 1 : -1);
        }
    }
}

