/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.mule.tooling.ui.modules.core.ModulesActivator;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IContentProposalProviderFactory;
import org.mule.tooling.ui.modules.core.widgets.IValidator;
import org.mule.tooling.ui.modules.core.widgets.editors.IOptionsCalculator;
import org.mule.tooling.ui.modules.core.widgets.editors.IValueCalculator;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumValidator;
import org.mule.tooling.ui.modules.core.widgets.meta.IEditorSelectionListener;
import org.mule.tooling.ui.modules.core.widgets.meta.IHasListener;
import org.mule.tooling.utils.LazyValue;

public class EnumHelper
extends AttributeHelper
implements IHasListener {
    private String buttonCaption = null;
    private String buttonClass = null;
    private String buttonTooltip = null;
    private String buttonEnablementClass = null;
    private boolean radioGroup;
    private boolean horizontal;
    private boolean showLabel;
    boolean allowsCustom;
    private boolean removeEmptyOption;
    private Collection<EnumOption> options;
    private boolean autoSort;
    private IOptionsCalculator calculator;
    public IEditorSelectionListener listener;
    private String affects;
    private boolean buttonDisabled;
    private boolean isChildElementChooser;
    private IValueCalculator valueCalculator;
    private String providerName;
    private List<String> keyParts;
    private boolean useSelectionDialog;
    private LazyValue<ImageDescriptor> imageDescriptor;
    private LazyValue<ImageDescriptor> disabledImageDescriptor;

    public ImageDescriptor getButtonImageDescriptor() {
        return this.getOrLogError(this.imageDescriptor);
    }

    public void setButtonImageDescriptor(ImageDescriptor buttonImageDescriptor) {
        this.imageDescriptor = new LazyValue(() -> buttonImageDescriptor);
    }

    public ImageDescriptor getButtonDisabledImageDescriptor() {
        return this.getOrLogError(this.disabledImageDescriptor);
    }

    private ImageDescriptor getOrLogError(LazyValue<ImageDescriptor> supplier) {
        try {
            return supplier != null ? (ImageDescriptor)supplier.getOrCompute() : null;
        }
        catch (Throwable t) {
            ModulesActivator.debugTracer().trace(ModulesActivator.ATTRIBUTE_CREATOR_ID, "Unexpected error loading image", t);
            return null;
        }
    }

    public void setButtonDisabledImageDescriptor(ImageDescriptor buttonImageDescriptor) {
        this.disabledImageDescriptor = new LazyValue(() -> buttonImageDescriptor);
    }

    public boolean isAutoSort() {
        return this.autoSort;
    }

    public void setAutoSort(boolean autoSort) {
        this.autoSort = autoSort;
    }

    public Collection<EnumOption> getOptions() {
        return this.options;
    }

    public void setOptions(Collection<EnumOption> options) {
        this.options = options;
    }

    public EnumHelper(String id, Class<?> type, boolean required, boolean autoSort, Collection<EnumOption> options) {
        super(id, type, required);
        this.initialize(autoSort, options);
    }

    public EnumHelper(String id, Class<?> type, boolean required, boolean autoSort, Collection<EnumOption> options, boolean removeEmptyOption) {
        super(id, type, required);
        this.initialize(autoSort, options);
        this.removeEmptyOption = removeEmptyOption;
    }

    private void initialize(boolean autoSort, final Collection<EnumOption> options) {
        this.options = options;
        this.autoSort = autoSort;
        this.proposalProvider = new IContentProposalProviderFactory(){

            @Override
            public int getProposalAcceptanceStyle() {
                return 2;
            }

            @Override
            public IContentProposalProvider getContentProposalProvider(AttributeContext context) {
                String[] srt = new String[options.size()];
                int a = 0;
                for (EnumOption s : EnumHelper.this.options) {
                    srt[a++] = s.value;
                }
                return new SimpleContentProposalProvider(srt);
            }
        };
    }

    public boolean isAllowsCustom() {
        return this.allowsCustom;
    }

    public void setAllowsCustom(boolean allowsCustom) {
        this.allowsCustom = allowsCustom;
    }

    @Override
    public IValidator getValidator() {
        if (super.getValidator() != null || this.isAllowsCustom()) {
            return this.validator;
        }
        return new EnumValidator();
    }

    public boolean isRemoveEmptyOption() {
        return this.removeEmptyOption;
    }

    public void setRemoveEmptyOption(boolean removeBlankOption) {
        this.removeEmptyOption = removeBlankOption;
    }

    public boolean isRadioGroup() {
        return this.radioGroup;
    }

    public void setAsRadioGroup(boolean asRadio) {
        this.radioGroup = asRadio;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    @Override
    public IEditorSelectionListener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(IEditorSelectionListener listener) {
        this.listener = listener;
    }

    public void setHorizontal(boolean h) {
        this.horizontal = h;
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public void setOptionsCalculator(IOptionsCalculator calc) {
        this.calculator = calc;
    }

    public void setOptionsCalculator(Optional<IOptionsCalculator> calc) {
        if (calc.isPresent()) {
            this.calculator = (IOptionsCalculator)calc.get();
        }
    }

    public IOptionsCalculator getOptionsCalculator() {
        return this.calculator;
    }

    public String getButtonCaption() {
        return this.buttonCaption;
    }

    public String getButtonClass() {
        return this.buttonClass;
    }

    public void setButtonCaption(String buttonCaption) {
        this.buttonCaption = buttonCaption;
    }

    public void setButtonClass(String buttonClass) {
        this.buttonClass = buttonClass;
    }

    public String getButtonTooltip() {
        return this.buttonTooltip;
    }

    public void setButtonTooltip(String buttonTooltip) {
        this.buttonTooltip = buttonTooltip;
    }

    public String getButtonEnablementClass() {
        return this.buttonEnablementClass;
    }

    public void setButtonEnablementClass(String buttonEnablementClass) {
        this.buttonEnablementClass = buttonEnablementClass;
    }

    public String getAffects() {
        return this.affects;
    }

    public void setAffects(String affects) {
        this.affects = affects;
    }

    @Override
    public boolean shouldAddEmptyOption() {
        return (this.isAllowsCustom() || super.shouldAddEmptyOption()) && !this.isRemoveEmptyOption();
    }

    public void setDisableButton(boolean buttonDisabled) {
        this.buttonDisabled = buttonDisabled;
    }

    public boolean isButtonDisabled() {
        return this.buttonDisabled;
    }

    public boolean isChildElementChooser() {
        return this.isChildElementChooser;
    }

    public void setChildElementChooser(boolean isChildElementChooser) {
        this.isChildElementChooser = isChildElementChooser;
    }

    public IValueCalculator getValueCalculator() {
        return this.valueCalculator;
    }

    public void setValueCalculator(IValueCalculator valueCalculator) {
        this.valueCalculator = valueCalculator;
    }

    public void setValueCalculator(Optional<IValueCalculator> valueCalculator) {
        if (valueCalculator.isPresent()) {
            this.valueCalculator = (IValueCalculator)valueCalculator.get();
        }
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public List<String> getKeyParts() {
        return this.keyParts;
    }

    public void setKeyParts(List<String> keyParts) {
        this.keyParts = keyParts;
    }

    public boolean isUseSelectionDialog() {
        return this.useSelectionDialog;
    }

    public void setUseSelectionDialog(boolean useSelectionDialog) {
        this.useSelectionDialog = useSelectionDialog;
    }

    public void setLazyImageDescriptor(LazyValue<ImageDescriptor> imageDescriptor) {
        this.imageDescriptor = imageDescriptor;
    }

    public void setLazyDisabledImageDescriptor(LazyValue<ImageDescriptor> disabledImageDescriptor) {
        this.disabledImageDescriptor = disabledImageDescriptor;
    }
}

