/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.HashSet;
import java.util.LinkedHashMap;
import org.dom4j.Namespace;
import org.mule.tooling.core.Category;
import org.mule.tooling.editor.model.element.Stereotype;
import org.mule.tooling.model.module.EndpointDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractContributionHandler;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeCategory;
import org.mule.tooling.ui.modules.core.widgets.meta.EndpointComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.MuleStereotypes;
import org.w3c.dom.Element;

public class EndpointContributionHandler
extends AbstractContributionHandler<EndpointDefinition> {
    private static final String FALSE = "false";
    private static final String DEFAULT_OUTBOUND = "outbound-endpoint";
    private static final String DEFAULT_INBOUND = "inbound-endpoint";
    private static final String CLOUD_CONNECTOR_ENDPOINT = "cloud-connector-message-source";

    protected EndpointDefinition createDefinition() {
        return new EndpointDefinition();
    }

    @Override
    protected EndpointDefinition createNodeDefinition(Namespace ns, Element element) {
        EndpointDefinition endpoint = this.createDefinition();
        if (CLOUD_CONNECTOR_ENDPOINT.equals(element.getLocalName())) {
            endpoint.setCloudConnectorEndpoint(true);
        }
        String inboundName = element.getAttribute("inboundLocalName");
        String outboundName = element.getAttribute("outboundLocalName");
        if (inboundName.length() == 0) {
            inboundName = DEFAULT_INBOUND;
        }
        if (outboundName.length() == 0) {
            outboundName = DEFAULT_OUTBOUND;
        }
        endpoint.setInboundMuleElement(this.createQName(ns, inboundName));
        endpoint.setOutboundMuleElement(this.createQName(ns, outboundName));
        endpoint.setSupportsInbound(!FALSE.equals(element.getAttribute("supportsInbound")));
        endpoint.setSupportsOutbound(!FALSE.equals(element.getAttribute("supportsOutbound")));
        String attribute = element.getAttribute("defaultMep");
        if (attribute.length() == 0) {
            attribute = "OneWay";
        }
        endpoint.setDefaultMep(attribute);
        boolean responseParticipant = Boolean.parseBoolean(element.getAttribute("response-participant"));
        endpoint.setResponseParticipant(responseParticipant);
        return endpoint;
    }

    @Override
    protected AbstractComponentMeta createComponentMeta(Namespace ns, EndpointDefinition endpoint, LinkedHashMap<String, AttributeCategory> loadCommonProperties, HashSet<String> doNotInherit) {
        return new EndpointComponentMeta(ns, (NodeDefinition)endpoint, loadCommonProperties, doNotInherit);
    }

    @Override
    protected String getDefaultCategory(Element element) {
        return Category.ENDPOINTS.getCategoryString();
    }

    @Override
    protected String getDefaultPaletteCategory(Element element) {
        return Category.CLOUD_CONNECTORS.getCategoryString();
    }

    @Override
    protected Stereotype getDefaultStereotype() {
        return MuleStereotypes.SOURCE;
    }
}

