/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.mule.tooling.core.dom.IAttributeListWrapper;
import org.mule.tooling.core.dom.IAttributeWrapper;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.INodeListWrapper;
import org.mule.tooling.core.dom.INodeWrapper;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.dstructure.IStructureProvider;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.IDynamicStructureClickHandler;

public class DynamicStructureHelper
extends AttributeHelper {
    static final String INDEX = "!index";
    protected IStructureProvider provider;
    protected IDynamicStructureClickHandler handler;
    protected IStructureProvider structureProvider;
    boolean isToParent = true;

    public IStructureProvider getStructureProvider() {
        return this.structureProvider;
    }

    public void setStructureProvider(IStructureProvider structureProvider) {
        this.structureProvider = structureProvider;
    }

    public IDynamicStructureClickHandler getHandler() {
        return this.handler;
    }

    public void setHandler(IDynamicStructureClickHandler handler) {
        this.handler = handler;
    }

    public DynamicStructureHelper(String id, Class<?> type, boolean required) {
        super(id, type, required);
    }

    @Override
    public void generate(IElementWrapper element, MessageFlowEntity messageFlowEntity) {
        try {
            IElementWrapper childElement = element.getElement(this.id);
            if (this.isToParent) {
                childElement = element;
            }
            if (childElement != null) {
                MessageFlowNode node = (MessageFlowNode)messageFlowEntity;
                PropertyCollection propertyCollection = node.getPropertiesForEdit(element);
                propertyCollection.addPropertyCollection(this.to(childElement));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isToParent() {
        return this.isToParent;
    }

    public void setToParent(boolean isToParent) {
        this.isToParent = isToParent;
    }

    @Override
    public void fillElement(IElementWrapper el, IMessageFlowNode node, PropertyCollectionMap propertyCollectionMap, IFlowTransformerContext context, IReadOnlyPropertyCollection collection, HashSet<String> handledElements) {
        IReadOnlyPropertyCollection tempPropertyCollection;
        IElementWrapper from;
        IReadOnlyPropertyCollection tempPropertyCollectionMap = null;
        for (IReadOnlyPropertyCollection innerPropertyCollection : collection.getPropertyCollections()) {
            String innerPropertyCollectionName = innerPropertyCollection.getName();
            if (innerPropertyCollectionName == null) continue;
            if (innerPropertyCollectionName.startsWith(this.id + "!")) {
                tempPropertyCollectionMap = innerPropertyCollection;
            }
            if (!innerPropertyCollectionName.equals(this.id)) continue;
            tempPropertyCollectionMap = innerPropertyCollection;
        }
        if (tempPropertyCollectionMap != null && (from = this.from(context, this.id, tempPropertyCollection = tempPropertyCollectionMap, handledElements)) != null) {
            if (this.isToParent) {
                INodeListWrapper elements = from.getChildElements();
                for (IElementWrapper element : elements) {
                    IElementWrapper createCopy = element.createCopy();
                    el.add((INodeWrapper)createCopy);
                }
                return;
            }
            el.add((INodeWrapper)from);
        }
    }

    private IElementWrapper from(IFlowTransformerContext context, String name, IReadOnlyPropertyCollection readOnlyPropertyCollection, HashSet<String> handledElements) {
        int indexOf = name.indexOf(33);
        if (indexOf > 0) {
            name = name.substring(0, indexOf);
        }
        IElementWrapper element = context.getDocumentWrapper().createElement(new QName(name));
        List properties = readOnlyPropertyCollection.getProperties();
        for (IReadOnlyProperty p : properties) {
            element.addAttribute(p.getName(), p.getValue());
        }
        ArrayList propertyCollections = new ArrayList(readOnlyPropertyCollection.getPropertyCollections());
        handledElements.add(name);
        ArrayList<IElementWrapper> mm = new ArrayList<IElementWrapper>();
        for (IReadOnlyPropertyCollection innerPropertyCollection : propertyCollections) {
            IElementWrapper from = this.from(context, innerPropertyCollection.getName(), innerPropertyCollection, handledElements);
            mm.add(from);
        }
        for (IElementWrapper e : mm) {
            element.add((INodeWrapper)e);
        }
        return element;
    }

    private PropertyCollection to(IElementWrapper element) {
        PropertyCollection cc = new PropertyCollection();
        cc.setName(this.getId() + "!" + new UID().toString());
        IAttributeListWrapper attributes = element.getAttributes();
        for (IAttributeWrapper a : attributes) {
            Property property = new Property();
            property.setName(a.getName());
            property.setName(a.getText());
            cc.getProperties().add(property);
        }
        Property property = new Property();
        cc.getProperties().add(property);
        for (IElementWrapper o : element.getChildElements()) {
            cc.getPropertyCollections().add(this.to(o));
        }
        return cc;
    }
}

