/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.List;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;

public class DynamicStructureElement {
    protected PropertyCollection collection = new PropertyCollection();
    protected ArrayList<DynamicStructureElement> lm = new ArrayList();

    public DynamicStructureElement(String name) {
        this.setName(name);
    }

    public DynamicStructureElement[] getChildren() {
        return this.lm.toArray(new DynamicStructureElement[this.lm.size()]);
    }

    public DynamicStructureElement(PropertyCollection collection) {
        this.collection = collection;
        List propertyCollections = collection.getPropertyCollections();
        for (PropertyCollection q : propertyCollections) {
            this.lm.add(new DynamicStructureElement(q));
        }
    }

    public boolean existing() {
        List properties = this.collection.getProperties();
        for (Property p : properties) {
            if (!p.getName().equals("!index")) continue;
            return true;
        }
        return false;
    }

    public String getAttribute(String atr) {
        List properties = this.collection.getProperties();
        for (Property p : properties) {
            if (!p.getName().equals(atr)) continue;
            return p.getValue();
        }
        return "";
    }

    public void setAttrubute(String atr, String value) {
        List properties = this.collection.getProperties();
        for (Property p : properties) {
            if (!p.getName().equals(atr)) continue;
            p.setValue(value);
            return;
        }
        Property q = new Property();
        q.setName(atr);
        q.setValue(value);
        properties.add(q);
    }

    public void add(DynamicStructureElement q) {
        this.lm.add(q);
        this.collection.getPropertyCollections().add(q.collection);
    }

    public void remove(DynamicStructureElement q) {
        this.lm.remove(q);
        this.collection.getPropertyCollections().remove(q.collection);
    }

    public void setName(String name) {
        this.collection.setName(name + "!" + new UID().toString());
    }

    public String getName() {
        String name = this.collection.getName();
        int indexOf = name.indexOf(33);
        if (indexOf > 0) {
            name = name.substring(0, indexOf);
        }
        return name;
    }
}

