/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Namespace;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.ModulesActivator;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.MuleVersionRange;

public class DynamicEditorsAttributeHelper
extends AttributeHelper {
    public static final NodeOption EMPTY_OPTION = new NodeOption("None", "", null);
    ThreadLocal<Boolean> inGenerate = new ThreadLocal();
    private boolean horizontal;
    protected List<NodeOption> nodes;

    public DynamicEditorsAttributeHelper(String id, String caption, List<NodeOption> modes) {
        super(id, Object.class, false);
        this.nodes = modes;
        this.setCaption(caption);
    }

    public List<NodeOption> getAllowedNodes(String muleVersion) {
        ArrayList<NodeOption> allowedNodes = new ArrayList<NodeOption>();
        for (NodeOption nodeOption : this.nodes) {
            MuleVersionRange muleVersionRange = nodeOption.getMuleVersionRange();
            if (!nodeOption.equals(EMPTY_OPTION) && !AbstractComponentMeta.supported(muleVersionRange.getVersionRange(), muleVersionRange.isEE(), muleVersion)) continue;
            allowedNodes.add(nodeOption);
        }
        return allowedNodes;
    }

    public NodeOption getNodeOption(NodeDefinition element) {
        for (NodeOption nodeOption : this.nodes) {
            if (!nodeOption.getNodeId().equals(element.getId())) continue;
            return nodeOption;
        }
        return this.nodes.get(0);
    }

    @Override
    public void fillElement(IElementWrapper el, IMessageFlowNode node, PropertyCollectionMap propertyCollectionMap, IFlowTransformerContext context, IReadOnlyPropertyCollection collection, HashSet<String> handledElements) {
    }

    @Override
    public void generate(IElementWrapper element, MessageFlowEntity messageFlowEntity) {
        element.getQName();
        if (messageFlowEntity instanceof MessageFlowNode) {
            MessageFlowNode node = (MessageFlowNode)messageFlowEntity;
            NodeDefinition nodeDefinition = node.getDefinition();
            if (nodeDefinition != null && nodeDefinition.getId() != node.getType() && this.inGenerate.get() == null) {
                this.inGenerate.set(true);
                try {
                    AbstractComponentMeta service = (AbstractComponentMeta)nodeDefinition.getService(AbstractComponentMeta.class);
                    service.generate(element, messageFlowEntity);
                }
                finally {
                    this.inGenerate.set(null);
                }
            }
        } else {
            throw new IllegalStateException("should only be used with:" + MessageFlowNode.class.getName() + " instances");
        }
    }

    @Override
    public void addNamespaces(Collection<Namespace> namespaces, MessageFlowEntity entity) {
    }

    public NodeDefinition getNode(String nodeId) {
        if (StringUtils.isBlank((String)nodeId) || this.isNotAllowedNode(nodeId)) {
            return null;
        }
        try {
            return MuleCorePlugin.getModuleManager().getNestedDefinition(nodeId);
        }
        catch (Exception e) {
            ModulesActivator.logError("Unexpected error", e);
            return null;
        }
    }

    private boolean isNotAllowedNode(String nodeId) {
        for (NodeOption option : this.nodes) {
            if (!nodeId.equals(option.getNodeId())) continue;
            return false;
        }
        return true;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setHorizontal(boolean h) {
        this.horizontal = h;
    }

    @Override
    public boolean ignoreGroupCaption() {
        return true;
    }

    public static class NodeOption {
        private String label;
        private String nodeId;
        private MuleVersionRange muleVersionRange;

        public NodeOption(String label, String nodeId, MuleVersionRange muleVersionRange) {
            this.label = label;
            this.nodeId = nodeId;
            this.muleVersionRange = muleVersionRange;
        }

        public MuleVersionRange getMuleVersionRange() {
            return this.muleVersionRange;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }
    }
}

