/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.regex.Pattern;
import org.mule.tooling.core.utils.ExpressionUtils;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeValidator;

public class DoubleAttributeHelper
extends AttributeHelper {
    protected Pattern pattern = Pattern.compile("([0-9]*)|(\\$\\{.*\\})|(\\#\\[.*\\])");
    protected double max;
    protected double min;
    protected double step;
    protected String outputFormat;

    public DoubleAttributeHelper(String id, Class<?> type, boolean required) {
        super(id, type, required);
        this.setValidator(new DoubleAttributeValidator());
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getStep() {
        return this.step;
    }

    public void setStep(double step) {
        this.step = step;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    private static final class DoubleAttributeValidator
    extends AttributeValidator {
        private DoubleAttributeValidator() {
        }

        @Override
        public String validate(Object value, AttributeContext context, AttributeHelper helper) {
            if (value == null) {
                value = "";
            }
            if (value.toString().trim().length() == 0) {
                return null;
            }
            String result = this.validateExpression(value.toString(), helper.isSupportsExpressions());
            if (result != null) {
                return result;
            }
            if (!ExpressionUtils.isExpressionOrProperty((String)value.toString())) {
                DoubleAttributeHelper doubleAttrHelper = (DoubleAttributeHelper)helper;
                try {
                    double parseDouble = Double.parseDouble(value.toString());
                    if (parseDouble < doubleAttrHelper.min) {
                        return "Value must be greater than " + NumberFormat.getNumberInstance().format(doubleAttrHelper.min);
                    }
                    if (parseDouble > doubleAttrHelper.max) {
                        return "Value must be smaller than " + NumberFormat.getNumberInstance().format(doubleAttrHelper.max);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (doubleAttrHelper.outputFormat != null) {
                        DecimalFormat decimalFormat = new DecimalFormat(doubleAttrHelper.outputFormat);
                        try {
                            Number parse = decimalFormat.parse(value.toString());
                            double parseDouble = parse.doubleValue();
                            if (parseDouble < doubleAttrHelper.min) {
                                return "Value must be greater than " + NumberFormat.getNumberInstance().format(doubleAttrHelper.min);
                            }
                            if (parseDouble > doubleAttrHelper.max) {
                                return "Value must be smaller than " + NumberFormat.getNumberInstance().format(doubleAttrHelper.max);
                            }
                            return null;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    return this.getAllowedTypesMessage("Value must be a double", helper.isSupportsExpressions());
                }
            }
            return null;
        }
    }
}

