/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.mule.tooling.core.utils.ExpressionUtils;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeValidator;

public class DateTimeAttributeHelper
extends AttributeHelper {
    private InputType inputType;
    private String outputFormat;

    public DateTimeAttributeHelper(String id, Class<?> type, boolean required) {
        super(id, type, required);
        this.setValidator(new DateTimeAttributeValidator());
    }

    public void setInputType(InputType dateTimeType) {
        this.inputType = dateTimeType;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public SimpleDateFormat getSimpleDateFormat() {
        return this.outputFormat.equals("") ? new SimpleDateFormat() : new SimpleDateFormat(this.outputFormat);
    }

    private static final class DateTimeAttributeValidator
    extends AttributeValidator {
        private DateTimeAttributeValidator() {
        }

        @Override
        public String validate(Object value, AttributeContext context, AttributeHelper helper) {
            block4: {
                String stringFromXML = (String)value;
                if (stringFromXML.equals("")) {
                    return null;
                }
                DateTimeAttributeHelper dateTimeAttributeHelper = (DateTimeAttributeHelper)helper;
                SimpleDateFormat format = dateTimeAttributeHelper.getSimpleDateFormat();
                try {
                    format.parse(stringFromXML);
                }
                catch (ParseException parseException) {
                    String result = this.validateExpression(value.toString(), helper.isSupportsExpressions());
                    if (result != null) {
                        return result;
                    }
                    if (ExpressionUtils.isExpressionOrProperty((String)value.toString())) break block4;
                    return "The string \"" + stringFromXML + "\" doesn't match the given format \"" + format.toPattern() + "\".";
                }
            }
            return null;
        }
    }

    public static enum InputType {
        DATE,
        TIME,
        DATETIME;

    }
}

