/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.swt.widgets.Composite;
import org.mule.tooling.core.module.Artifact;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.ICustomFieldEditorFactory;
import org.mule.tooling.ui.modules.core.widgets.meta.ReflectionBasedCustomFieldEditorFactory;

public class CustomControlHelper
extends AttributeHelper {
    private ICustomFieldEditorFactory factory;
    private List<AttributeHelper> innerAttributeHelpers = new ArrayList<AttributeHelper>();
    private Map<String, Object> properties;

    public CustomControlHelper(String id, String controlClass, Artifact muleArtifact, Map<String, Object> properties) {
        this(id, new ReflectionBasedCustomFieldEditorFactory(controlClass), muleArtifact, properties);
    }

    public CustomControlHelper(String id, ICustomFieldEditorFactory factory, Artifact muleArtifact, Map<String, Object> properties) {
        super(id, String.class, false);
        this.factory = factory;
        this.properties = properties;
        this.setMuleArtifact(muleArtifact);
    }

    public CustomControlHelper(String id, String controlClass, Artifact muleArtifact) {
        this(id, controlClass, muleArtifact, new HashMap<String, Object>());
    }

    public IFieldEditor createEditor(AttributesPropertyPage page, AttributeGroup attributeGroup, Composite groupComposite) {
        return this.factory.createEditor(this, page, attributeGroup, groupComposite);
    }

    public Optional<Object> getProperty(String propertyName) {
        return Optional.ofNullable(this.properties.get(propertyName));
    }

    public Boolean getBooleanProperty(String propertyName, boolean defaultValue) {
        return Optional.ofNullable((Boolean)this.properties.get(propertyName)).orElse(defaultValue);
    }

    public String getStringProperty(String propertyName, String defaultValue) {
        return Optional.ofNullable((String)this.properties.get(propertyName)).orElse(defaultValue);
    }

    public void addHelpersToGroup(AttributeGroup group) {
        for (AttributeHelper innerHelper : this.innerAttributeHelpers) {
            group.add(innerHelper);
        }
    }

    public List<AttributeHelper> getInnerAttributeHelpers() {
        return this.innerAttributeHelpers;
    }

    public void setInnerAttributeHelpers(List<AttributeHelper> innerAttributeHelpers) {
        this.innerAttributeHelpers = innerAttributeHelpers;
    }

    public void addInnerAttributeHelpers(AttributeHelper ... helpers) {
        this.innerAttributeHelpers.addAll(Arrays.asList(helpers));
    }
}

