/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.dom4j.Namespace;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.generator.IContainerXmlGenerator;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfigurationXmlGenerator;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeCategory;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.XmlOrderComparator;
import org.osgi.framework.Version;

public class ContainerXmlGenerator
implements IContainerXmlGenerator {
    private QName name;

    public ContainerXmlGenerator(QName name) {
        this.name = name;
    }

    public IElementWrapper generate(Container container, NodeDefinition definition, IFlowTransformerContext context, MuleConfigurationXmlGenerator xmlGenerator) {
        IReadOnlyPropertyCollection properties = container.getProperties();
        IElementWrapper createdElement = context.getDocumentWrapper().createElement(this.name);
        AbstractComponentMeta componentMeta = this.getComponentMeta(definition);
        this.processUnknown(definition, context, properties, createdElement);
        this.processChildElements(context, container, properties, componentMeta, createdElement, xmlGenerator);
        return createdElement;
    }

    private void processUnknown(NodeDefinition definition, IFlowTransformerContext context, IReadOnlyPropertyCollection properties, IElementWrapper createdElement) {
        List propertyList = properties.getProperties();
        for (IReadOnlyProperty property : propertyList) {
            if (!this.getComponentMeta(definition).isUnknownProperty(properties, property, this.getCurrentVersion(context))) continue;
            createdElement.addAttribute(new QName(property.getName()), property.getValue());
        }
    }

    public AbstractComponentMeta getComponentMeta(NodeDefinition definition) {
        return (AbstractComponentMeta)definition.getService(AbstractComponentMeta.class);
    }

    public Version getCurrentVersion(IFlowTransformerContext context) {
        IServerDefinition serverDefinition = CoreUtils.getServerDefinition((IFlowTransformerContext)context);
        return new Version(serverDefinition.getVersion());
    }

    private void processChildElements(IFlowTransformerContext context, Container node, IReadOnlyPropertyCollection properties, AbstractComponentMeta componentMeta, IElementWrapper element, MuleConfigurationXmlGenerator xmlGenerator) {
        ArrayList<AttributeHelper> childElements = new ArrayList<AttributeHelper>();
        Version currentVersion = new Version(context.getMuleProject().getServerDefinition().getVersion());
        PropertyCollectionMap propertyCollectionMap = new PropertyCollectionMap(properties);
        for (AttributeCategory modelAttribute : componentMeta.getAttributeCategoryMap().values()) {
            childElements.addAll(modelAttribute.getAttributes(currentVersion));
        }
        childElements.addAll(node.getNestedContainers());
        Collections.sort(childElements, new XmlOrderComparator());
        HashSet<String> handledElements = new HashSet<String>();
        for (Object e : childElements) {
            if (e instanceof AttributeHelper) {
                AttributeHelper helper = (AttributeHelper)e;
                helper.fillElement(element, (IMessageFlowNode)node, propertyCollectionMap, context, properties, handledElements);
                continue;
            }
            if (!(e instanceof NestedContainer)) continue;
            xmlGenerator.processNestedContainer((NestedContainer)e, context);
        }
    }

    public List<Namespace> getNamespaces(Container container) {
        return this.getComponentMeta(container.getDefinition()).getNamespaces((MessageFlowEntity)container);
    }
}

