/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Namespace;
import org.mule.tooling.core.Category;
import org.mule.tooling.core.builder.messageflow.ICanMatchElement;
import org.mule.tooling.core.generator.IContainerXmlGenerator;
import org.mule.tooling.core.module.Artifact;
import org.mule.tooling.core.module.IModuleLoaderHandler;
import org.mule.tooling.core.module.MuleModule;
import org.mule.tooling.editor.model.element.Stereotype;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractContributionHandler;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeCategory;
import org.mule.tooling.ui.modules.core.widgets.meta.CanMatchElementManager;
import org.mule.tooling.ui.modules.core.widgets.meta.ContainerXmlGenerator;
import org.mule.tooling.ui.modules.core.widgets.meta.MuleStereotypes;
import org.mule.tooling.ui.modules.core.widgets.meta.NamedComponentMeta;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ContainerContributionHandler
extends AbstractContributionHandler<ContainerDefinition> {
    @Override
    protected String getDefaultCategory(Element element) {
        String categoryAttribute = element.getAttribute("category");
        return StringUtils.isEmpty((String)categoryAttribute) ? Category.SCOPES.getCategoryString() : categoryAttribute;
    }

    @Override
    protected AbstractComponentMeta createComponentMeta(Namespace ns, ContainerDefinition container, LinkedHashMap<String, AttributeCategory> loadCommonProperties, HashSet<String> doNotInherit) {
        NamedComponentMeta namedComponentMeta = new NamedComponentMeta(container.getMuleElement(), ns, (NodeDefinition)container, loadCommonProperties, doNotInherit);
        namedComponentMeta.setAllowAny(true);
        return namedComponentMeta;
    }

    @Override
    protected void configureMeta(ContainerDefinition container, AbstractComponentMeta componentMeta) {
        ICanMatchElement canMatchElement;
        super.configureMeta(container, componentMeta);
        if (StringUtils.isNotEmpty((String)container.getElementMatcher()) && (canMatchElement = CanMatchElementManager.get().getCanMatchElement(container.getElementMatcher())) != null) {
            container.registerService(ICanMatchElement.class, (Object)canMatchElement);
        }
        container.registerService(IContainerXmlGenerator.class, (Object)new ContainerXmlGenerator(container.getMuleElement()));
    }

    @Override
    protected ContainerDefinition createNodeDefinition(Namespace ns, Element element) {
        throw new RuntimeException("This method should never be called.");
    }

    @Override
    protected ContainerDefinition createNodeDefinition(Namespace ns, Element element, Artifact muleArtifact, IModuleLoaderHandler handler) {
        ContainerDefinition container = new ContainerDefinition();
        String localName = element.getAttribute("localId");
        String xmlName = element.getAttribute("xmlname");
        container.setMuleElement(this.createQName(ns, StringUtils.isNotEmpty((String)xmlName) ? xmlName : localName));
        String containerBehavior = element.getAttribute("containerBehavior");
        String pathExpression = element.getAttribute("pathExpression");
        container.setContainerBehavior(containerBehavior.isEmpty() ? "default" : containerBehavior);
        container.setPathExpression(pathExpression.isEmpty() ? "${name}" : pathExpression);
        if (element.hasAttribute("defaultNestedContainer")) {
            container.setDefaultContainerId(ns.getURI() + "/" + element.getAttribute("defaultNestedContainer"));
        }
        NodeList childNodes = element.getChildNodes();
        List initedNestedContainers = MuleModule.initElements((NodeList)childNodes, (Artifact)muleArtifact, (Namespace)ns, (IModuleLoaderHandler)handler);
        container.setNestedContainerDefinitions(initedNestedContainers);
        container.setBundleSymbolicName(muleArtifact.getId());
        return container;
    }

    @Override
    protected Stereotype getDefaultStereotype() {
        return MuleStereotypes.PROCESSOR;
    }
}

