/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModelObject;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentElementNode;
import java.util.List;
import org.mule.tooling.core.validation.Message;
import org.mule.tooling.core.validation.MessageBuilder;
import org.mule.tooling.core.validation.ValidationConstants;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.ChildElementFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.StringFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.IComponentValidator;

public class ComponentClassValidator
implements IComponentValidator {
    protected String ERROR_MESSAGE_UI = "Class value must be set either providing a Class Name or Defining an Object. Not in Both";
    protected String ERROR_MESSAGE = "Class value must be set either in 'Component' element or in 'singleton-object' nested element. Not in Both";

    @Override
    public Message validateComponent(DomainEditingModelObject pNode) {
        String classValue = pNode.getXMLAttributeValue("class");
        if (classValue == null || classValue.length() == 0) {
            boolean found = false;
            IDocumentElementNode[] iDocumentElementNodeArray = pNode.getChildNodes();
            int n = iDocumentElementNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                String cv;
                IDocumentElementNode elementNode = iDocumentElementNodeArray[n2];
                String nodeClass = elementNode.getXMLTagName();
                if ((nodeClass = nodeClass.trim()).equals("singleton-object") && (cv = elementNode.getXMLAttributeValue("class")) != null && cv.length() > 0) {
                    found = true;
                }
                if (nodeClass.equals("spring-object") && (cv = elementNode.getXMLAttributeValue("bean")) != null && cv.length() > 0) {
                    found = true;
                }
                ++n2;
            }
            if (!found) {
                return MessageBuilder.newErrorMessage((String)this.ERROR_MESSAGE).build();
            }
        } else {
            boolean found = false;
            IDocumentElementNode[] iDocumentElementNodeArray = pNode.getChildNodes();
            int n = iDocumentElementNodeArray.length;
            int n3 = 0;
            while (n3 < n) {
                String cv;
                IDocumentElementNode elementNode = iDocumentElementNodeArray[n3];
                String nodeClass = elementNode.getXMLTagName();
                if ((nodeClass = nodeClass.trim()).equals("singleton-object") && (cv = elementNode.getXMLAttributeValue("class")) != null && cv.length() > 0) {
                    found = true;
                }
                ++n3;
            }
            if (found) {
                return MessageBuilder.newErrorMessage((String)this.ERROR_MESSAGE).build();
            }
        }
        return ValidationConstants.MESSAGE_OK;
    }

    @Override
    public Message validateComponentGUI(IMessageFlowNode node, List<IFieldEditor> editors) {
        block10: {
            String classValue = null;
            IFieldEditor classEditor = null;
            for (IFieldEditor editor : editors) {
                String editorId;
                if (!(editor instanceof AbstractFieldEditor) || (editorId = editor.getHelper().id) == null || !editorId.equals("class")) continue;
                classEditor = editor;
            }
            if (!(classEditor instanceof StringFieldEditor)) break block10;
            StringFieldEditor sfe = (StringFieldEditor)classEditor;
            classValue = sfe.getPublicValue();
            if (classValue == null || classValue.length() == 0) {
                for (IFieldEditor editor : editors) {
                    String edId = editor.getHelper().id;
                    if (edId == null || !edId.equals("http://www.mulesoft.org/schema/mule/core/abstract-object-factory")) continue;
                    ChildElementFieldEditor childEditor = (ChildElementFieldEditor)editor;
                    String text = childEditor.getText();
                    if ((text = text.trim()) == null || text.length() == 0 || !text.startsWith("core:singleton-object") && !text.startsWith("core:spring-object")) {
                        return MessageBuilder.newErrorMessage((String)this.ERROR_MESSAGE_UI).build();
                    }
                    if (childEditor.getPropertyCollection() != null) {
                        Property classProperty = null;
                        for (Property p : childEditor.getPropertyCollection().getProperties()) {
                            if (text.startsWith("core:spring-object")) {
                                if (p.getName() == null || !p.getName().equals("bean")) continue;
                                classProperty = p;
                                continue;
                            }
                            if (p.getName() == null || !p.getName().equals("class")) continue;
                            classProperty = p;
                        }
                        if (classProperty != null && classProperty.getValue() != null && classProperty.getValue().length() != 0) continue;
                        return MessageBuilder.newErrorMessage((String)this.ERROR_MESSAGE_UI).build();
                    }
                    return MessageBuilder.newErrorMessage((String)this.ERROR_MESSAGE_UI).build();
                }
            } else {
                for (IFieldEditor editor : editors) {
                    String edId = editor.getHelper().id;
                    if (edId == null || !edId.equals("http://www.mulesoft.org/schema/mule/core/abstract-object-factory")) continue;
                    ChildElementFieldEditor childEditor = (ChildElementFieldEditor)editor;
                    String text = childEditor.getText();
                    if ((text = text.trim()) == null || text.length() <= 0 || !text.startsWith("core:singleton-object") || childEditor.getPropertyCollection() == null) continue;
                    Property classProperty = null;
                    for (Property p : childEditor.getPropertyCollection().getProperties()) {
                        if (p.getName() == null || !p.getName().equals("class")) continue;
                        classProperty = p;
                    }
                    if (classProperty == null || classProperty.getValue() == null || classProperty.getValue().length() <= 0) continue;
                    return MessageBuilder.newErrorMessage((String)this.ERROR_MESSAGE_UI).build();
                }
            }
        }
        return ValidationConstants.MESSAGE_OK;
    }
}

