/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.FixedAttributeCategoryProvider;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeCategory;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.ChildManagingAttributeHelper;

public class ChildManagingAttributeEditor
extends AbstractFieldEditor {
    private TableViewer viewer;
    private PropertyCollectionMap props;

    public ChildManagingAttributeEditor(AttributeContext ctx, AttributeHelper atr, Composite parent) {
        super(ctx, atr, parent);
    }

    @Override
    protected Control createControl(Composite parent) {
        this.viewer = new TableViewer(parent, 67584);
        this.viewer.getTable().setHeaderVisible(true);
        ChildManagingAttributeHelper gl = (ChildManagingAttributeHelper)this.getHelper();
        AttributeCategory allAttributes = gl.getAllAttributes();
        Collection<AttributeGroup> groups = allAttributes.getGroups();
        TableColumn names = new TableColumn(this.viewer.getTable(), 0);
        TableLayout layout = new TableLayout();
        this.viewer.getTable().setLayout((Layout)layout);
        names.setText("Element");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        for (AttributeGroup g : groups) {
            Collection<AttributeHelper> elements = g.elements();
            for (AttributeHelper h : elements) {
                TableColumn c = new TableColumn(this.viewer.getTable(), 0);
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
                c.setText(h.getCaption());
                c.setData((Object)h);
                c.setWidth(100);
            }
        }
        this.viewer.setLabelProvider((IBaseLabelProvider)new LaneLabelProvider());
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        GridData layoutData = new GridData(1808);
        layoutData.horizontalSpan = 3;
        this.viewer.getTable().setLayoutData((Object)layoutData);
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                TitleAreaDialog dlg = new TitleAreaDialog(Display.getCurrent().getActiveShell()){
                    private AttributesPropertyPage pm;
                    private PropertyCollectionMap propertyCollectionMap;
                    private MessageFlowNode n;

                    protected Control createDialogArea(Composite parent) {
                        Composite createDialogArea = (Composite)super.createDialogArea(parent);
                        this.setTitle("Route properties");
                        IStructuredSelection selection = (IStructuredSelection)(this).ChildManagingAttributeEditor.this.viewer.getSelection();
                        Object firstElement = selection.getFirstElement();
                        CompartmentLane l = (CompartmentLane)firstElement;
                        IMessageFlowEntity value = (IMessageFlowEntity)l.getCompartmentLaneEntries().get(0);
                        this.setMessage("Edit properties for route to '" + ((MessageFlowNode)value).getName() + "'");
                        ChildManagingAttributeHelper gl = (ChildManagingAttributeHelper)ChildManagingAttributeEditor.this.getHelper();
                        AttributeCategory allAttributes = gl.getAllAttributes();
                        this.pm = new AttributesPropertyPage(null, ChildManagingAttributeEditor.this.context.getProject(), createDialogArea, new FixedAttributeCategoryProvider(allAttributes));
                        this.pm.setLayoutData(new GridData(1808));
                        if (value instanceof MessageFlowNode) {
                            this.n = (MessageFlowNode)value;
                            Map propertyCollections = (this).ChildManagingAttributeEditor.this.props.getPropertyCollections();
                            this.propertyCollectionMap = (PropertyCollectionMap)propertyCollections.get(l.getEntityId());
                            if (this.propertyCollectionMap == null) {
                                this.propertyCollectionMap = new PropertyCollectionMap();
                                (this).ChildManagingAttributeEditor.this.props.addPropertyCollection(this.n.getEntityId(), this.propertyCollectionMap);
                            }
                            this.pm.loadFrom((IMessageFlowNode)this.n, this.propertyCollectionMap);
                        }
                        return createDialogArea;
                    }

                    protected void okPressed() {
                        this.pm.saveTo((IMessageFlowNode)this.n, this.propertyCollectionMap);
                        (this).ChildManagingAttributeEditor.this.viewer.refresh(true);
                        super.okPressed();
                    }
                };
                dlg.open();
            }
        });
        return this.viewer.getTable();
    }

    @Override
    public String getValue() {
        return "";
    }

    @Override
    public void setValue(String value) {
    }

    @Override
    public void saveTo(IMessageFlowNode node, PropertyCollectionMap props) {
        for (String s : this.props.getPropertyCollections().keySet()) {
            props.addPropertyCollection(s, (PropertyCollectionMap)this.props.getPropertyCollections().get(s));
        }
    }

    @Override
    public void loadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        if (node instanceof SplitterNode) {
            this.props = props;
            SplitterNode sn = (SplitterNode)node;
            Compartment compartment = sn.getCompartment();
            List lanes = compartment.getLanes();
            this.viewer.setInput((Object)lanes.toArray());
        }
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }

    private final class LaneLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private LaneLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            CompartmentLane l;
            IMessageFlowEntity value;
            if (columnIndex == 0 && (value = (IMessageFlowEntity)(l = (CompartmentLane)element).getCompartmentLaneEntries().get(0)) instanceof MessageFlowNode) {
                MessageFlowNode node = (MessageFlowNode)value;
                return node.getDefinition().getIconImage();
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            CompartmentLane l = (CompartmentLane)element;
            IMessageFlowEntity value = (IMessageFlowEntity)l.getCompartmentLaneEntries().get(0);
            if (value instanceof MessageFlowNode) {
                MessageFlowNode n = (MessageFlowNode)value;
                if (columnIndex == 0) {
                    return n.getName();
                }
                AttributeHelper h = (AttributeHelper)ChildManagingAttributeEditor.this.viewer.getTable().getColumn(columnIndex).getData();
                String id = h.getId();
                Map propertyCollections = ChildManagingAttributeEditor.this.props.getPropertyCollections();
                PropertyCollectionMap propertyCollectionMap = (PropertyCollectionMap)propertyCollections.get(l.getEntityId());
                if (propertyCollectionMap != null) {
                    return propertyCollectionMap.getProperty(id, "");
                }
            }
            return null;
        }
    }
}

