/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.dom4j.Namespace;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.INodeListWrapper;
import org.mule.tooling.core.dom.INodeWrapper;
import org.mule.tooling.core.dom.QNameUtils;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IPropertyCollectionReadCapability;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeCategory;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.IAddNewChildActionHandler;
import org.mule.tooling.ui.modules.core.widgets.meta.NestedComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.XmlOrderComparator;

public class ChildElementAttributeHelper
extends AttributeHelper {
    protected boolean inplace;
    protected boolean multiple;
    protected boolean tableUI;
    private boolean removeBorder;
    private String valuePersistenceRequires = null;
    protected boolean treeUI;
    private String[] allowedSubtypes;
    protected boolean subtypes;
    protected String structure;
    private IAddNewChildActionHandler addCommand = null;
    private boolean createEmpty = false;

    public ChildElementAttributeHelper(String id, boolean required) {
        super(id, Object.class, required);
    }

    public boolean isTableUI() {
        return this.tableUI;
    }

    public void setTableUI(boolean tableUI) {
        this.tableUI = tableUI;
    }

    public boolean isInplace() {
        return this.inplace;
    }

    public void setInplace(boolean inplace) {
        this.inplace = inplace;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public boolean isSubtypes() {
        return this.subtypes;
    }

    public void setSubtypes(boolean subtypes) {
        this.subtypes = subtypes;
    }

    public String[] getAllowedSubtypes() {
        return this.allowedSubtypes;
    }

    public void setAllowedSubtypes(String ... subtypes) {
        this.allowedSubtypes = subtypes;
        this.setSubtypes(true);
    }

    public String getStructure() {
        return this.structure;
    }

    public void setStructure(String structure) {
        this.structure = structure;
    }

    public PropertyCollection createNew(HashMap<String, String> attrs) {
        List<NestedDefinition> nestedElementsFor = this.getAllowedDefinitions();
        NestedDefinition definition = nestedElementsFor.get(0);
        String string = PropertiesUtils.createCollectionIdWithSuffix((String)definition.getId(), (String)new UID().toString());
        PropertyCollection cl = new PropertyCollection();
        cl.setName(string);
        for (String s : attrs.keySet()) {
            Property property = new Property();
            property.setName(s);
            property.setValue(attrs.get(s));
            cl.getProperties().add(property);
        }
        return cl;
    }

    public PropertyCollection createChild(HashMap<String, String> attrs) {
        return this.createChild(attrs, null);
    }

    public PropertyCollection createChild(HashMap<String, String> attrs, String tag) {
        ChildElementAttributeHelper nestedHelper = this.getNestedHelper(tag);
        return nestedHelper.createNew(attrs);
    }

    public ChildElementAttributeHelper getNestedHelper() {
        return this.getNestedHelper("");
    }

    public ChildElementAttributeHelper getNestedHelper(String tag) {
        List<NestedDefinition> nestedElementsFor;
        NestedDefinition d;
        AbstractComponentMeta service;
        ChildElementAttributeHelper[] childElements;
        if (tag == null) {
            tag = "";
        }
        if ((childElements = (service = (AbstractComponentMeta)(d = (nestedElementsFor = this.getAllowedDefinitions()).get(0)).getService(AbstractComponentMeta.class)).getChildElements()).length == 1) {
            return childElements[0];
        }
        if (childElements.length > 0) {
            ChildElementAttributeHelper[] childElementAttributeHelperArray = childElements;
            int n = childElements.length;
            int n2 = 0;
            while (n2 < n) {
                ChildElementAttributeHelper helper = childElementAttributeHelperArray[n2];
                if (helper.getStructure() != null && helper.getStructure().equals(tag)) {
                    return helper;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public void fromElementToProperties(IElementWrapper muleModel, PropertyCollectionMap ms) {
        List<NestedDefinition> nestedElementsFor = this.getAllowedDefinitions();
        INodeListWrapper childElements = muleModel.getChildElements();
        int num = 0;
        for (IElementWrapper element : childElements) {
            for (NestedDefinition definition : nestedElementsFor) {
                if (!definition.matches(element.getQName())) continue;
                AbstractComponentMeta service = (AbstractComponentMeta)definition.getService(AbstractComponentMeta.class);
                PropertyCollectionMap map = new PropertyCollectionMap(element);
                service.generate(element, map);
                ms.addPropertyCollection(PropertiesUtils.createCollectionIdWithSuffix((String)definition.getId(), (long)(++num)), map);
                MessageFlowUtils.setElementXmlOrder((IElementWrapper)element, (int)this.getXmlOrder());
            }
        }
    }

    @Override
    public void generate(IElementWrapper element, MessageFlowEntity messageFlowEntity) {
        EndpointDirection direction;
        if (this.mode != null && messageFlowEntity instanceof EndpointNode && (direction = ((EndpointNode)messageFlowEntity).getDirection()) != null && (direction == EndpointDirection.OUTBOUND && "inbound".equals(this.mode) || direction == EndpointDirection.INBOUND && "outbound".equals(this.mode))) {
            return;
        }
        if (messageFlowEntity instanceof MessageFlowNode) {
            MessageFlowNode node = (MessageFlowNode)messageFlowEntity;
            PropertyCollection nodeProperties = node.getPropertiesForEdit(element);
            List<NestedDefinition> nestedElementsFor = this.getAllowedDefinitions();
            INodeListWrapper childElements = element.getChildElements();
            int num = 0;
            for (IElementWrapper childElement : childElements) {
                for (NestedDefinition definition : nestedElementsFor) {
                    if (!definition.matches(childElement.getQName())) continue;
                    NestedComponentMeta service = (NestedComponentMeta)definition.getService(AbstractComponentMeta.class);
                    PropertyCollectionMap map = new PropertyCollectionMap(childElement);
                    service.generate(childElement, map);
                    PropertyCollection asPropertyCollection = map.asPropertyCollection();
                    String value = PropertiesUtils.createCollectionIdWithSuffix((String)definition.getId(), (long)num);
                    asPropertyCollection.setName(value);
                    ++num;
                    nodeProperties.addPropertyCollection(asPropertyCollection);
                    MessageFlowUtils.setElementXmlOrder((IElementWrapper)childElement, (int)this.getXmlOrder());
                }
            }
        } else {
            throw new IllegalStateException("should only be used with:" + MessageFlowNode.class.getName() + " instances");
        }
    }

    public List<NestedDefinition> getAllowedDefinitions() {
        List<NestedDefinition> nestedElementsFor = null;
        IMuleModuleManager moduleManager = MuleCorePlugin.getModuleManager();
        if (this.allowedSubtypes != null) {
            ArrayList<NestedDefinition> s = new ArrayList<NestedDefinition>();
            String[] stringArray = this.allowedSubtypes;
            int n = this.allowedSubtypes.length;
            int n2 = 0;
            while (n2 < n) {
                String subType = stringArray[n2];
                NestedDefinition nestedElement = moduleManager.getNestedDefinition(subType.trim());
                if (nestedElement != null) {
                    s.add(nestedElement);
                }
                ++n2;
            }
            return s;
        }
        if (this.subtypes) {
            nestedElementsFor = moduleManager.getNestedDefinitionFor(this.id);
        } else {
            NestedDefinition nestedElement = moduleManager.getNestedDefinition(this.id);
            if (nestedElement != null) {
                nestedElementsFor = Collections.singletonList(nestedElement);
            } else {
                return Collections.emptyList();
            }
        }
        return nestedElementsFor;
    }

    public static void sortNestedProperties(PropertyCollection properties) {
        if (properties != null) {
            List propertyCollections = properties.getPropertyCollections();
            ChildElementAttributeHelper.sortPropertyCollections(propertyCollections);
        }
    }

    private static void sortPropertyCollections(List<PropertyCollection> list) {
        Collections.sort(list, new PropertyCollectionComparator());
    }

    @Override
    public void fillElement(IElementWrapper el, IMessageFlowNode node, PropertyCollectionMap propertyCollectionMap, IFlowTransformerContext context, IReadOnlyPropertyCollection collection, HashSet<String> handledElements) {
        if (collection == null) {
            return;
        }
        ArrayList sortedPropertyCollections = new ArrayList(collection.getPropertyCollections());
        Collections.sort(sortedPropertyCollections, new PropertyCollectionComparator());
        Map<String, NestedDefinition> nestedElementsFor = this.getNestedElementDefinitions();
        for (NestedDefinition nestedDefinition : nestedElementsFor.values()) {
            handledElements.add(QNameUtils.toQualifiedName((QName)nestedDefinition.getMuleElement()));
        }
        HashSet<String> ids = new HashSet<String>();
        for (IReadOnlyPropertyCollection nestedPropertyCollection : sortedPropertyCollections) {
            IElementWrapper element;
            NestedDefinition nestedDefinition;
            String nestedPropertyCollectionName = nestedPropertyCollection.getName();
            if (!ids.add(nestedPropertyCollectionName) || nestedPropertyCollectionName == null || nestedPropertyCollectionName.length() <= 0 || nestedPropertyCollectionName.charAt(0) != '@' || (nestedDefinition = nestedElementsFor.get(nestedPropertyCollectionName = nestedPropertyCollectionName.substring(1, nestedPropertyCollectionName.indexOf(59)))) == null) continue;
            boolean doAdd = true;
            if (this.isTransient()) {
                doAdd = false;
            }
            if ((element = nestedPropertyCollection.getElement()) == null) {
                throw new IllegalArgumentException("Child element property collection without xml element: " + nestedPropertyCollection.getName());
            }
            if (nestedPropertyCollection.isErased()) {
                if (element.getParent() == null) continue;
                element.getParent().removeChild((INodeWrapper)element);
                continue;
            }
            MessageFlowUtils.setElementXmlOrder((IElementWrapper)element, (int)this.getXmlOrder());
            AbstractComponentMeta service = (AbstractComponentMeta)nestedDefinition.getService(AbstractComponentMeta.class);
            HashSet<String> otherElems = new HashSet<String>();
            ArrayList<AttributeHelper> helpers = new ArrayList<AttributeHelper>();
            for (AttributeCategory a : service.getAttributeCategoryMap().values()) {
                for (AttributeGroup g : a.getGroups()) {
                    helpers.addAll(g.getFilteredHelpers(context));
                }
            }
            Collections.sort(helpers, new XmlOrderComparator());
            for (AttributeHelper helper : helpers) {
                helper.fillElement(element, node, new PropertyCollectionMap(nestedPropertyCollection), context, nestedPropertyCollection, otherElems);
            }
            handledElements.add(element.getTagName());
            if (this.inplace && !this.isMultiple()) {
                if (!this.isCreateEmpty() && element.getAttributes().isEmpty() && element.getText().trim().isEmpty() && element.isEmpty()) {
                    if (element.getParent() == null) continue;
                    element.getParent().removeChild((INodeWrapper)element);
                    continue;
                }
                if (!doAdd || element.getParent() != null) continue;
                el.add((INodeWrapper)element);
                continue;
            }
            if (!doAdd || element.getParent() != null) continue;
            el.add((INodeWrapper)element);
        }
    }

    private Map<String, NestedDefinition> getNestedElementDefinitions() {
        HashMap<String, NestedDefinition> nestedElementsFor = new HashMap<String, NestedDefinition>();
        if (this.subtypes) {
            List nested = MuleCorePlugin.getModuleManager().getNestedDefinitionFor(this.id);
            for (NestedDefinition def : nested) {
                nestedElementsFor.put(def.getId(), def);
            }
        } else {
            NestedDefinition nestedElement = MuleCorePlugin.getModuleManager().getNestedDefinition(this.id);
            if (nestedElement != null) {
                nestedElementsFor.put(this.id, nestedElement);
            }
        }
        return nestedElementsFor;
    }

    public boolean isCreateEmpty() {
        return this.createEmpty;
    }

    public void setCreateEmpty(boolean createEmpty) {
        this.createEmpty = createEmpty;
    }

    @Override
    public void addNamespaces(Collection<Namespace> namespaces, MessageFlowEntity entity) {
        MessageFlowNode node = (MessageFlowNode)entity;
        IReadOnlyPropertyCollection collection = node.getProperties();
        this.addNamespaces(namespaces, node, collection);
    }

    private void addNamespaces(Collection<Namespace> namespaces, MessageFlowNode node, IReadOnlyPropertyCollection collection) {
        List propertyCollections;
        HashMap<String, NestedDefinition> nestedElementsFor = new HashMap<String, NestedDefinition>();
        if (this.subtypes) {
            List nested = MuleCorePlugin.getModuleManager().getNestedDefinitionFor(this.id);
            for (NestedDefinition def : nested) {
                nestedElementsFor.put(def.getId(), def);
            }
        } else {
            nestedElementsFor.put(this.id, MuleCorePlugin.getModuleManager().getNestedDefinition(this.id));
        }
        if (collection != null && (propertyCollections = collection.getPropertyCollections()) != null) {
            for (IReadOnlyPropertyCollection c : propertyCollections) {
                NestedDefinition nestedDefinition;
                String nm = c.getName();
                if (nm == null || nm.length() <= 0 || nm.charAt(0) != '@' || (nestedDefinition = (NestedDefinition)nestedElementsFor.get(nm = nm.substring(1, nm.indexOf(59)))) == null) continue;
                AbstractComponentMeta service = (AbstractComponentMeta)nestedDefinition.getService(AbstractComponentMeta.class);
                QName qName = service.getQName((MessageFlowEntity)node);
                namespaces.add(Namespace.get((String)qName.getPrefix(), (String)qName.getNamespaceURI()));
                namespaces.addAll(service.getAdditionalNamespaces());
                for (AttributeCategory ac : service.getAttributeCategoryMap().values()) {
                    for (AttributeGroup ag : ac.getGroups()) {
                        for (AttributeHelper ah : ag.elements()) {
                            if (!(ah instanceof ChildElementAttributeHelper)) continue;
                            ((ChildElementAttributeHelper)ah).addNamespaces(namespaces, node, c);
                        }
                    }
                }
            }
        }
    }

    public boolean isAllowed(NodeDefinition def) {
        HashSet<NestedDefinition> allowedDefinitions = new HashSet<NestedDefinition>(this.getAllowedDefinitions());
        return allowedDefinitions.contains(def);
    }

    public void setRemoveBorder(boolean removeBorder) {
        this.removeBorder = removeBorder;
    }

    public boolean isRemoveBorder() {
        return this.removeBorder;
    }

    public void setAddCommand(IAddNewChildActionHandler addCommand) {
        this.addCommand = addCommand;
    }

    public IAddNewChildActionHandler getAddCommand() {
        return this.addCommand;
    }

    public String getValuePersistenceRequires() {
        return this.valuePersistenceRequires;
    }

    public void setValuePersistenceRequires(String valuePersistenceRequires) {
        this.valuePersistenceRequires = valuePersistenceRequires;
    }

    private static final class PropertyCollectionComparator
    implements Comparator<IPropertyCollectionReadCapability<?, ?>> {
        private PropertyCollectionComparator() {
        }

        @Override
        public int compare(IPropertyCollectionReadCapability<?, ?> o1, IPropertyCollectionReadCapability<?, ?> o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            if (o1 == null) {
                return -1;
            }
            if (o1.getName() == null && o2.getName() == null) {
                return 0;
            }
            if (o1.getName() == null) {
                return -1;
            }
            if (o2.getName() == null) {
                return 1;
            }
            int first = this.subName(o1.getName()).compareTo(this.subName(o2.getName()));
            if (first != 0) {
                return first;
            }
            return this.subNumber(o1.getName()) - this.subNumber(o2.getName());
        }

        String subName(String name) {
            int end = name.indexOf(59);
            if (end == -1) {
                return "";
            }
            return name.substring(0, end);
        }

        int subNumber(String name) {
            int start = name.indexOf(59);
            if (start == -1) {
                return -1;
            }
            String sub = name.substring(start + 1);
            try {
                return Integer.parseInt(sub);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
    }
}

