/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ITypeHyperlinkProvider;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Namespace;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.swt.graphics.Image;
import org.mule.tooling.core.dom.IAttributeWrapper;
import org.mule.tooling.core.dom.IDocumentWrapper;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.INodeListWrapper;
import org.mule.tooling.core.dom.INodeWrapper;
import org.mule.tooling.core.dom.NodeType;
import org.mule.tooling.core.dom.QNameUtils;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.IModelGenerator;
import org.mule.tooling.core.generator.MuleNamespaces;
import org.mule.tooling.core.module.Artifact;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.IContentProposalProviderFactory;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.IValidator;
import org.mule.tooling.ui.modules.core.widgets.IValueConverter;
import org.mule.tooling.ui.modules.core.widgets.IValueFactory;
import org.mule.tooling.ui.modules.core.widgets.editors.ILoadedValueModifier;
import org.mule.tooling.ui.modules.core.widgets.editors.IModeUpdater;
import org.mule.tooling.ui.modules.core.widgets.editors.IValueCalculator;
import org.mule.tooling.ui.modules.core.widgets.editors.TextViewerCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AfterLoadCorrection;
import org.mule.tooling.ui.modules.core.widgets.meta.AfterSaveCorrection;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroupRequirement;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelperComponent;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributesPersistenceTransformer;
import org.mule.tooling.ui.modules.core.widgets.meta.ButtonAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.IDialogAction;
import org.mule.tooling.ui.modules.core.widgets.meta.MetaDescriptionEntry;
import org.mule.tooling.ui.palette.PaletteManager;
import org.mule.tooling.utils.TypeContainer;
import org.osgi.framework.Version;

public class AttributeHelper
extends MetaDescriptionEntry
implements IModelGenerator,
Cloneable {
    protected IContentProposalProviderFactory proposalProvider;
    protected String requiredPropertyId;
    protected IValueFactory valueFactory;
    protected IValueConverter converter;
    protected ITypeHyperlinkProvider hyperLinkProvider;
    protected HashSet<String> logicalAlternatives = new HashSet();
    protected boolean singleLineExp;
    protected String originalName;
    protected String saveAs;
    protected String recalcWhen;
    private List<String> prerequisites;
    protected boolean visibleInDialog = true;
    private boolean alwaysFill;
    protected String typeString = "";
    private Image image;
    private IModeUpdater updater;
    protected String groupIn;
    protected boolean isAttribute = true;
    protected String nestedTagName = null;
    protected String canonicalPath = null;
    protected boolean supportsExpressions = false;
    protected boolean requiresExpression = false;
    protected boolean isCData;
    protected boolean indented;
    protected int span = 0;
    protected int indentation = 0;
    private boolean hiddenForUser;
    protected int priority = 0;
    private boolean showOnlyInInbound;
    private boolean showOnlyInOutbound;
    private boolean fillWhenNotEmpty;
    private boolean alwaysCombo;
    protected Object defaultValue;
    protected final Class<?> type;
    protected boolean required;
    protected boolean acceptsEmptyValue;
    private boolean appearsAsRequired;
    protected IValidator validator;
    boolean transientA;
    private int setHeight;
    private boolean mflow;
    private AttributesPersistenceTransformer persistenceTransformer = null;
    private String groupLabel = null;
    private boolean tiny;
    private boolean unchangeable;
    private Artifact muleArtifact = null;
    private boolean alwaysFillSimple;
    private boolean revalidateOnEnablementChange;
    private String metadataStaticKey;
    private ILoadedValueModifier loadedValueModifier;
    private IValueCalculator calculator;
    private TextViewerCreator customTextViewerCreator;
    private VersionRange deprecatedRange;
    private String deprecatedMessage;
    private String warningMessage;
    private boolean relativeToProject;
    private boolean requiredForDataSense;
    private int xmlOrder = -1;
    private boolean isTextArea;
    private int textAreaHeight = 100;
    private String placeholder = "";
    private boolean captionIsUp;
    private String parent = "";
    private boolean isTypeChooser;
    private final TypeContainer components = new TypeContainer();

    public AttributeHelper(String id, Class<?> type, boolean required) {
        this.id = id;
        this.type = type;
        this.required = required;
    }

    public int getXmlOrder() {
        return this.xmlOrder;
    }

    public void setXmlOrder(int xmlOrder) {
        this.xmlOrder = xmlOrder;
    }

    public String getRecalcWhen() {
        return this.recalcWhen;
    }

    public void setRecalcWhen(String recalcWhen) {
        this.recalcWhen = recalcWhen;
    }

    public boolean isSingleLineExp() {
        return this.singleLineExp;
    }

    public void setSingleLineExp(boolean singleLineExp) {
        this.singleLineExp = singleLineExp;
    }

    public boolean isCData() {
        return this.isCData;
    }

    public void setCData(boolean isCData) {
        this.isCData = isCData;
    }

    public boolean isAttribute() {
        return this.isAttribute;
    }

    public void setAttribute(boolean isAttribute) {
        this.isAttribute = isAttribute;
    }

    public String getNestedTagName() {
        return this.nestedTagName;
    }

    public void setNestedTagName(String nestedTagName) {
        this.nestedTagName = nestedTagName;
    }

    public String getCanonicalPath() {
        return this.canonicalPath;
    }

    public void setCanonicalPath(String canonicalPath) {
        this.canonicalPath = canonicalPath;
    }

    public String getGroupIn() {
        return this.groupIn;
    }

    public void setGroupIn(String groupIn) {
        this.groupIn = groupIn;
        if (groupIn.indexOf(47) != -1) {
            this.caption = "";
        }
    }

    public String getSaveAs() {
        return this.saveAs;
    }

    public void setSaveAs(String saveAs) {
        this.saveAs = saveAs;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public boolean isSupportsExpressions() {
        return this.supportsExpressions;
    }

    public void setSupportsExpressions(boolean supportsExpressions) {
        this.supportsExpressions = supportsExpressions;
    }

    public boolean isRequiresExpression() {
        return this.requiresExpression;
    }

    public void setRequiresExpression(boolean requiresExpression) {
        this.requiresExpression = requiresExpression;
    }

    public HashSet<String> getAlternatives() {
        return this.logicalAlternatives;
    }

    public void addAlternative(String alternative) {
        this.logicalAlternatives.add(alternative);
    }

    public IValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public void setValueFactory(IValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    public String getRequiredPropertyId() {
        return this.requiredPropertyId;
    }

    public void setRequiredPropertyId(String requiredPropertyId) {
        this.requiredPropertyId = requiredPropertyId;
    }

    public void addNamespaces(Collection<Namespace> namespaces, MessageFlowEntity entity) {
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setValidator(IValidator validator) {
        this.validator = validator;
    }

    public void setValidator(com.google.common.base.Optional<IValidator> validator) {
        if (validator.isPresent()) {
            this.validator = (IValidator)validator.get();
        }
    }

    public IModeUpdater getUpdater() {
        return this.updater;
    }

    public boolean isAlwaysFill() {
        return this.alwaysFill;
    }

    public void setAlwaysFill(boolean alwaysFill) {
        this.alwaysFill = alwaysFill;
    }

    public boolean isVisible() {
        return this.visibleInDialog;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public IValidator getValidator() {
        return this.validator;
    }

    public IContentProposalProviderFactory getProposalProvider() {
        return this.proposalProvider;
    }

    protected void fromPropertiesToElement(PropertyCollectionMap map, IElementWrapper element) {
        Object helperDefault;
        String property;
        if (map != null && StringUtils.isNotEmpty((String)(property = map.getProperty(this.id, ""))) && ((helperDefault = this.getDefaultValue()) == null || !property.equals(helperDefault))) {
            if (this.converter != null) {
                property = this.converter.convertXMLToModel(property);
            }
            element.addAttribute(this.saveAs != null ? this.saveAs : this.id, property);
        }
    }

    protected void fromElementToProperties(IElementWrapper element, PropertyCollectionMap map) {
        Property property = this.parseProperty(element);
        if (property != null && property.getValue() != null) {
            map.addProperty(property.getName(), property.getValue());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Property parseProperty(IElementWrapper element) {
        Property result = new Property();
        result.setName(this.id);
        if (this.isAttribute) {
            String lookupName = this.getLookupAttributeName();
            IAttributeWrapper attribute = null;
            if (lookupName.equals("tracking:enable-default-events")) {
                attribute = element.getAttribute(MuleNamespaces.getMuleTrackingEE((String)"enable-default-events"));
                if (attribute == null) {
                    result.setValue("false");
                }
            } else {
                attribute = lookupName.equals("tracking:transaction-id") ? element.getAttribute(MuleNamespaces.getMuleTrackingEE((String)"transaction-id")) : (lookupName.equals("doc:sample") ? element.getAttribute(MuleNamespaces.getMuleDoc((String)"sample")) : element.getAttribute(new QName(lookupName)));
            }
            if (attribute != null) {
                String persistedValue = attribute.getText();
                String value = this.convert(persistedValue);
                result.setValue(value);
                return result;
            }
            if (attribute != null) return result;
            this.setPropertyWithDefaultValue(result);
            return result;
        }
        IElementWrapper selectedElement = this.selectElement(element);
        if (selectedElement == null) {
            if (!this.setPropertyWithDefaultValue(result)) return null;
            return result;
        }
        String text = selectedElement.getScriptText();
        String value = this.convert(text);
        result.setValue(value);
        MessageFlowUtils.setElementXmlOrder((IElementWrapper)selectedElement, (int)this.getXmlOrder());
        return result;
    }

    private boolean setPropertyWithDefaultValue(Property property) {
        boolean valueChanged = false;
        Object defaultValue = this.getDefaultValue();
        if (defaultValue != null && !defaultValue.toString().isEmpty()) {
            property.setValue(defaultValue.toString());
            valueChanged = true;
        }
        return valueChanged;
    }

    public String getLookupAttributeName() {
        if (this.getId().equals("enable-default-events")) {
            return "tracking:enable-default-events";
        }
        if (this.id.equals("transaction-id")) {
            return "tracking:transaction-id";
        }
        if (this.getSaveAs() != null) {
            return this.getSaveAs();
        }
        return this.getId();
    }

    protected String convert(String persistedValue) {
        return this.converter != null ? this.converter.convertModelToXML(persistedValue) : persistedValue;
    }

    private IElementWrapper selectElement(IElementWrapper element) {
        if (this.nestedTagName == null) {
            return element;
        }
        QName elementQName = element.getQName();
        QName qName = new QName(elementQName.getNamespaceURI(), this.nestedTagName, elementQName.getPrefix());
        return element.getElement(qName);
    }

    public void generate(IElementWrapper element, MessageFlowEntity messageFlowEntity) {
        if (messageFlowEntity instanceof IMessageFlowNode) {
            IMessageFlowNode node = (IMessageFlowNode)messageFlowEntity;
            PropertyCollection properties = node.getPropertiesForEdit(element);
            Property property = this.parseProperty(element);
            if (property != null && property.getValue() != null) {
                properties.getProperties().add(property);
            }
        } else {
            throw new IllegalStateException("should only be used with:" + MessageFlowNode.class.getName() + " instances");
        }
    }

    public void fillElement(IElementWrapper el, IMessageFlowNode node, PropertyCollectionMap propertyCollectionMap, IFlowTransformerContext context, IReadOnlyPropertyCollection properties, HashSet<String> handledElements) {
        AbstractComponentMeta meta;
        NodeDefinition definition;
        String nodeType = node.getType();
        if (this.isStoreInMflow()) {
            return;
        }
        if (this.alwaysFill && this.isAttribute && nodeType != null && (definition = node.getDefinition()) != null && (meta = (AbstractComponentMeta)definition.getService(AbstractComponentMeta.class)) != null) {
            List<AttributeGroupRequirement> requirements = meta.getAttributeGroupRequirements();
            for (AttributeGroupRequirement requirement : requirements) {
                List<LinkedHashSet<String>> requiredAttrs = requirement.getRequiredAttrs();
                for (LinkedHashSet<String> requieredAttributeGroup : requiredAttrs) {
                    boolean accepted;
                    if (!requieredAttributeGroup.contains(this.id) || !(accepted = AttributeGroupRequirement.accepted(meta, requieredAttributeGroup, propertyCollectionMap))) continue;
                    return;
                }
            }
        }
        String propertyValue = propertyCollectionMap.getProperty(this.id, "");
        boolean erased = Boolean.parseBoolean(propertyCollectionMap.getProperty("auxiliary;erased;" + this.id, Boolean.FALSE.toString()));
        if (this.isAttribute) {
            String attributeXmlName;
            String string = attributeXmlName = this.saveAs != null ? this.saveAs : this.id;
            if (!erased) {
                if (node instanceof EndpointNode && this.mode != null) {
                    EndpointNode en = (EndpointNode)node;
                    if (this.mode.equals("inbound") && en.getDirection() == EndpointDirection.OUTBOUND) {
                        return;
                    }
                    if (this.mode.equals("outbound") && en.getDirection() == EndpointDirection.INBOUND) {
                        return;
                    }
                }
                if (this.converter != null) {
                    propertyValue = this.converter.convertModelToXML(propertyValue);
                }
                if (propertyValue.length() > 0) {
                    Object defaultValue2 = this.getDefaultValue();
                    if (defaultValue2 == null) {
                        defaultValue2 = "";
                    }
                    if (!propertyValue.equals(defaultValue2.toString()) || this.alwaysFill() || this.isFillWhenNotEmpty()) {
                        if (!this.attributeNewValueIsSameAsCurrent(el, propertyValue, attributeXmlName)) {
                            el.addAttribute(attributeXmlName, propertyValue);
                        }
                    } else {
                        el.removeAttribute(attributeXmlName);
                    }
                } else if (this.alwaysFill() && this.getDefaultValue() != null && !propertyCollectionMap.hasProperty(this.id)) {
                    el.addAttribute(attributeXmlName, this.getDefaultValue().toString());
                } else if (this.isRequired() && !this.isFillWhenNotEmpty() || this.isAlwaysFillSimple()) {
                    if (this.getDefaultValue() != null && !this.acceptsEmptyValue) {
                        el.addAttribute(attributeXmlName, this.getDefaultValue().toString());
                    } else if (!this.acceptsEmptyValue) {
                        el.removeAttribute(attributeXmlName);
                    } else {
                        el.addAttribute(attributeXmlName, "");
                    }
                } else if (!this.acceptsEmptyValue) {
                    el.removeAttribute(attributeXmlName);
                }
            } else {
                el.removeAttribute(attributeXmlName);
            }
        } else {
            IElementWrapper elementToFill = el;
            boolean isNested = this.nestedTagName != null;
            Object defaultValueNotNull = this.getDefaultValue();
            if (defaultValueNotNull == null) {
                defaultValueNotNull = "";
            }
            if (this.oldContentShouldBeErased(propertyValue, defaultValueNotNull)) {
                this.eraseOldContent(elementToFill, isNested);
            } else {
                if (isNested) {
                    QName elementName = QNameUtils.get((String)this.nestedTagName, (String)elementToFill.getNamespacePrefix(), (String)elementToFill.getNamespaceURI());
                    INodeListWrapper childElements = elementToFill.getChildElements(elementName);
                    if (!childElements.isEmpty()) {
                        elementToFill = (IElementWrapper)childElements.get(0);
                        this.clearTextCdataContents(elementToFill);
                    } else {
                        IElementWrapper createElement = MessageFlowUtils.createElement((IDocumentWrapper)context.getDocumentWrapper(), (QName)elementName, (int)this.getXmlOrder());
                        elementToFill.add((INodeWrapper)createElement);
                        handledElements.add(createElement.getTagName());
                        elementToFill = createElement;
                    }
                } else {
                    this.clearTextCdataContents(elementToFill);
                }
                if (this.isCData) {
                    if (!handledElements.contains("CDATA") || !StringUtils.isBlank((String)propertyValue)) {
                        handledElements.add("CDATA");
                        this.addOrSetNodeWithValue(context, elementToFill, NodeType.CDATA, propertyValue);
                    }
                } else {
                    handledElements.add("TEXT");
                    this.addOrSetNodeWithValue(context, elementToFill, NodeType.TEXT, propertyValue);
                }
            }
        }
    }

    private boolean attributeNewValueIsSameAsCurrent(IElementWrapper el, String currentPropertyValue, String attributeXmlName) {
        IAttributeWrapper currentValue = el.getAttribute(attributeXmlName);
        return currentValue != null && StringUtils.equals((String)currentValue.getText(), (String)currentPropertyValue);
    }

    private void eraseOldContent(IElementWrapper elementToFill, boolean isNested) {
        if (isNested) {
            QName elementName = QNameUtils.get((String)this.nestedTagName, (String)elementToFill.getNamespacePrefix(), (String)elementToFill.getNamespaceURI());
            INodeListWrapper childElements = elementToFill.getChildElements(elementName);
            while (!elementToFill.getChildElements(elementName).isEmpty()) {
                elementToFill.removeChild(childElements.get(0));
                childElements = elementToFill.getChildElements(elementName);
            }
        } else {
            this.clearTextCdataContents(elementToFill);
        }
    }

    private boolean oldContentShouldBeErased(String propertyValue, Object defaultValueNotNull) {
        boolean propertyShouldntBeShown;
        boolean valueIsEmpty = propertyValue.equals("");
        boolean bl = propertyShouldntBeShown = propertyValue.equals(defaultValueNotNull.toString()) && !this.alwaysFill() && !this.isFillWhenNotEmpty();
        return valueIsEmpty || propertyShouldntBeShown;
    }

    private void clearTextCdataContents(IElementWrapper el) {
        INodeListWrapper childNodes = el.getChildNodes();
        for (INodeWrapper childNode : childNodes) {
            boolean isText;
            boolean isCDATA = childNode.getNodeType() == NodeType.CDATA;
            boolean bl = isText = childNode.getNodeType() == NodeType.TEXT;
            if (!isCDATA && !isText || !StringUtils.isNotBlank((String)childNode.getText())) continue;
            el.removeChild(childNode);
        }
    }

    private void addOrSetNodeWithValue(IFlowTransformerContext context, IElementWrapper el, NodeType nodeType, String property) {
        String value;
        INodeListWrapper childNodes = el.getChildNodes();
        INodeWrapper existingNode = null;
        for (INodeWrapper childNode : childNodes) {
            if (childNode.getNodeType() != nodeType) continue;
            existingNode = childNode;
            break;
        }
        String string = value = NodeType.CDATA == nodeType ? this.escapeCdata(property) : property;
        if (existingNode == null) {
            el.add(this.createElement(context, nodeType, value));
        } else {
            existingNode.setNodeValue(value);
        }
    }

    private INodeWrapper createElement(IFlowTransformerContext context, NodeType nodeType, String property) {
        INodeWrapper node = null;
        switch (nodeType) {
            case CDATA: {
                node = context.getDocumentWrapper().createCDATA(property);
                break;
            }
            case TEXT: {
                node = context.getDocumentWrapper().createText(property);
                break;
            }
        }
        return node;
    }

    private String escapeCdata(String property) {
        return property;
    }

    protected boolean alwaysFill() {
        return this.alwaysFill;
    }

    public ITypeHyperlinkProvider getHyperLinkProvider() {
        return this.hyperLinkProvider;
    }

    public void setHyperLinkProvider(ITypeHyperlinkProvider hyperLinkProvider) {
        this.hyperLinkProvider = hyperLinkProvider;
    }

    public void setVisibleInDialog(boolean parseBoolean) {
        this.visibleInDialog = parseBoolean;
    }

    public void setType(String type2) {
        this.typeString = type2;
    }

    public String getTypeString() {
        return this.typeString;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setValuePersistence(IValueConverter newInstance) {
        this.converter = newInstance;
    }

    public IValueConverter getPersistence() {
        return this.converter;
    }

    public IModeUpdater getModeUpdater() {
        return this.updater;
    }

    public void setUpdater(IModeUpdater updater) {
        this.updater = updater;
    }

    public AttributeHelper clone() {
        try {
            return (AttributeHelper)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalArgumentException();
        }
    }

    public void setIndented(boolean indented) {
        this.indented = indented;
    }

    public boolean isIndented() {
        return this.indented;
    }

    public void setSpan(int span) {
        this.span = span;
    }

    public int getSpan() {
        return this.span;
    }

    public boolean isHiddenForUser() {
        return this.hiddenForUser;
    }

    public void setHiddenForUser(boolean hiddenForUser) {
        this.hiddenForUser = hiddenForUser;
    }

    public boolean isAlwaysCombo() {
        return this.alwaysCombo;
    }

    public void setAlwaysCombo(boolean isAlways) {
        this.alwaysCombo = isAlways;
    }

    public void setTransient(boolean parseBoolean) {
        this.transientA = parseBoolean;
    }

    public boolean isTransient() {
        return this.transientA;
    }

    public boolean isStoreInMflow() {
        return this.mflow;
    }

    public void setStoreInMFlow(boolean storeInMflow) {
        this.mflow = storeInMflow;
    }

    public void setIndentation(int indentation) {
        this.indentation = indentation;
    }

    public int getIndentation() {
        return this.indentation;
    }

    public int getSetHeight() {
        return this.setHeight;
    }

    public void setSetHeight(int setHeight) {
        this.setHeight = setHeight;
    }

    public static AttributesPersistenceTransformer createPersistenceTransformer(String classname) {
        try {
            Class<?> cls = Class.forName(classname);
            Class[] parTypes = new Class[]{};
            Object[] arguments = new Object[]{};
            Constructor<?> ct = cls.getConstructor(parTypes);
            return (AttributesPersistenceTransformer)ct.newInstance(arguments);
        }
        catch (Throwable e) {
            System.err.println(e);
            return null;
        }
    }

    private static AttributesPersistenceTransformer createPersistenceTransformer(String classname, Class<?>[] parTypes, Object[] args) {
        try {
            Class<?> cls = Class.forName(classname);
            Constructor<?> ct = cls.getConstructor(parTypes);
            return (AttributesPersistenceTransformer)ct.newInstance(args);
        }
        catch (Throwable e) {
            System.err.println(e);
            return null;
        }
    }

    public void setPersistenceTransformer(String classname) {
        this.persistenceTransformer = AttributeHelper.createPersistenceTransformer(classname);
    }

    public void setPersistenceTransformer(String classname, Class<?>[] parTypes, Object[] args) {
        this.persistenceTransformer = AttributeHelper.createPersistenceTransformer(classname, parTypes, args);
    }

    public boolean hasPersistenceTransformer() {
        return this.persistenceTransformer != null;
    }

    public void transformBeforeSave(IMessageFlowNode node, PropertyCollectionMap props) {
        if (this.persistenceTransformer != null) {
            this.persistenceTransformer.onSave(node, props);
        }
    }

    public void transformBeforeLoad(IMessageFlowNode node, PropertyCollectionMap props) {
        if (this.persistenceTransformer != null) {
            this.persistenceTransformer.onLoad(node, props);
        }
    }

    public boolean hasAfterSaveCorrection() {
        return this.persistenceTransformer instanceof AfterSaveCorrection;
    }

    public boolean hasAfterLoadCorrection() {
        return this.persistenceTransformer instanceof AfterLoadCorrection;
    }

    public void transformAfterSave(IMessageFlowNode node, PropertyCollectionMap props) {
        if (this.persistenceTransformer instanceof AfterSaveCorrection) {
            AfterSaveCorrection correction = (AfterSaveCorrection)((Object)this.persistenceTransformer);
            correction.afterSave(node, props);
        }
    }

    public void transformAfterLoad(IMessageFlowNode node, PropertyCollectionMap props) {
        if (this.persistenceTransformer instanceof AfterLoadCorrection) {
            AfterLoadCorrection correction = (AfterLoadCorrection)((Object)this.persistenceTransformer);
            correction.afterLoad(node, props);
        }
    }

    public String getGroupLabel() {
        return this.groupLabel;
    }

    public void setGroupLabel(String groupLabel) {
        this.groupLabel = groupLabel;
    }

    public boolean isFillWhenNotEmpty() {
        return this.fillWhenNotEmpty;
    }

    public void setFillWhenNotEmpty(boolean fillWhenNotEmpty) {
        this.fillWhenNotEmpty = fillWhenNotEmpty;
    }

    public boolean isAppearsAsRequired() {
        return this.appearsAsRequired;
    }

    public void setAppearsAsRequired(boolean appearsAsRequired) {
        this.appearsAsRequired = appearsAsRequired;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setTiny(boolean tiny) {
        this.tiny = tiny;
    }

    public boolean isTiny() {
        return this.tiny;
    }

    public boolean isUnchangeable() {
        return this.unchangeable;
    }

    public void setUnchangeable(boolean unchangeable) {
        this.unchangeable = unchangeable;
    }

    public void click(IFieldEditor editor, AttributesPropertyPage page, String className) {
        try {
            if (this.muleArtifact == null) {
                IDialogAction ac = (IDialogAction)ButtonAttributeHelper.class.getClassLoader().loadClass(className).newInstance();
                ac.click(editor, page);
            } else {
                IDialogAction ac = (IDialogAction)this.muleArtifact.newInstance(className);
                ac.click(editor, page);
            }
        }
        catch (Exception exception) {}
    }

    public void setAlwaysFillSimple(boolean alwaysFillSimple) {
        this.alwaysFillSimple = alwaysFillSimple;
    }

    public boolean isAlwaysFillSimple() {
        return this.alwaysFillSimple;
    }

    public boolean isShowOnlyInInbound() {
        return this.showOnlyInInbound;
    }

    public void setShowOnlyInInbound(boolean showOnlyInInbound) {
        this.showOnlyInInbound = showOnlyInInbound;
    }

    public boolean isShowOnlyInOutbound() {
        return this.showOnlyInOutbound;
    }

    public void setShowOnlyInOutbound(boolean showOnlyInOutbound) {
        this.showOnlyInOutbound = showOnlyInOutbound;
    }

    public void setRevalidateOnEnablementChange(boolean revalidateOnEnablementChange) {
        this.revalidateOnEnablementChange = revalidateOnEnablementChange;
    }

    public boolean isRevalidateOnEnablementChange() {
        return this.revalidateOnEnablementChange;
    }

    public void setMetaDataStaticKey(String metaDataStaticKey) {
        this.metadataStaticKey = metaDataStaticKey;
    }

    public String getMetaDataStaticKey() {
        return this.metadataStaticKey;
    }

    public ILoadedValueModifier getLoadedValueModifier() {
        return this.loadedValueModifier;
    }

    public void setLoadedValueModifier(ILoadedValueModifier loadedValueModifier) {
        this.loadedValueModifier = loadedValueModifier;
    }

    public boolean isWellKnownAttribute(IAttributeWrapper attribute) {
        return this.getLookupAttributeName().equals(attribute.getTagName());
    }

    public boolean isWellKnownProperty(IReadOnlyProperty property, Version currentVersion) {
        boolean isIncluded = this.getRange() == null || this.getRange().isIncluded(currentVersion);
        boolean isDeprecated = this.isDeprecatedIn(currentVersion.toString());
        boolean showDeprecatedElements = PaletteManager.INSTANCE.showDeprecatedComponents(currentVersion.toString());
        return this.getId().equals(property.getName()) && isIncluded && (!isDeprecated || showDeprecatedElements);
    }

    public IValueCalculator getCalculator() {
        return this.calculator;
    }

    public void setCalculator(IValueCalculator calculator) {
        this.calculator = calculator;
    }

    public void setProposalProvider(IContentProposalProviderFactory proposalProvider) {
        this.proposalProvider = proposalProvider;
    }

    public boolean hasDefaultValue() {
        Object defaultValue = this.getDefaultValue();
        if (defaultValue != null) {
            return defaultValue instanceof String ? StringUtils.isNotEmpty((String)((String)defaultValue)) : true;
        }
        return false;
    }

    public boolean shouldAddEmptyOption() {
        return this.isSupportsExpressions() || !this.isRequired() && !this.hasDefaultValue();
    }

    public TextViewerCreator getCustomTextViewerCreator() {
        return this.customTextViewerCreator;
    }

    public void setCustomTextViewerCreator(TextViewerCreator customTextViewerCreator) {
        this.customTextViewerCreator = customTextViewerCreator;
    }

    public VersionRange getDeprecatedRange() {
        return this.deprecatedRange;
    }

    public void setDeprecatedRange(VersionRange deprecatedRange) {
        this.deprecatedRange = deprecatedRange;
    }

    public String getDeprecatedMessage() {
        return this.deprecatedMessage;
    }

    public void setDeprecatedMessage(String deprecatedMessage) {
        this.deprecatedMessage = deprecatedMessage;
    }

    public boolean isDeprecatedIn(String version) {
        return CoreUtils.isDeprecated((VersionRange)this.deprecatedRange, (String)version);
    }

    public void setRelativeToProject(boolean parseBoolean) {
        this.relativeToProject = parseBoolean;
    }

    public boolean shouldBeRelativeToProject() {
        return this.relativeToProject;
    }

    public boolean isRequiredForDataSense() {
        return this.requiredForDataSense;
    }

    public void setRequiredForDataSense(boolean requiredForDataSense) {
        this.requiredForDataSense = requiredForDataSense;
    }

    public boolean isAcceptsEmptyValue() {
        return this.acceptsEmptyValue;
    }

    public void setAcceptsEmptyValue(boolean acceptsEmptyValue) {
        this.acceptsEmptyValue = acceptsEmptyValue;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public void setWarningMessage(String warningMessage) {
        this.warningMessage = warningMessage;
    }

    public boolean isTextArea() {
        return this.isTextArea;
    }

    public void setTextArea(boolean isTextArea) {
        this.isTextArea = isTextArea;
    }

    public int getTextAreaHeight() {
        return this.textAreaHeight;
    }

    public void setTextAreaHeight(int textAreaHeight) {
        this.textAreaHeight = textAreaHeight;
    }

    public boolean ignoreGroupCaption() {
        return false;
    }

    public Artifact getMuleArtifact() {
        return this.muleArtifact;
    }

    public void setMuleArtifact(Artifact muleArtifact) {
        this.muleArtifact = muleArtifact;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public boolean isCaptionIsUp() {
        return this.captionIsUp;
    }

    public void setCaptionIsUp(boolean captionIsUp) {
        this.captionIsUp = captionIsUp;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public com.google.common.base.Optional<List<String>> getPrerequisites() {
        return com.google.common.base.Optional.fromNullable(this.prerequisites);
    }

    public void setPrerequisites(List<String> prerequisites) {
        this.prerequisites = prerequisites;
    }

    public boolean isTypeChooser() {
        return this.isTypeChooser;
    }

    public void setTypeChooser(boolean isTypeChooser) {
        this.isTypeChooser = isTypeChooser;
    }

    public <T extends AttributeHelperComponent> Optional<T> getComponent(Class<T> clazz) {
        return this.components.getType(clazz);
    }

    public <T extends AttributeHelperComponent> List<T> getAllComponents() {
        ArrayList list = new ArrayList();
        this.components.getRegisteredTypes().stream().forEach(x -> this.components.getType(x).ifPresent(y -> {
            boolean bl = list.add((AttributeHelperComponent)y);
        }));
        return list;
    }

    public <T> void registerComponent(Class<? super T> clazz, T element) {
        this.components.putType(clazz, element);
    }
}

