/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.module.Artifact;
import org.mule.tooling.core.validation.Message;
import org.mule.tooling.core.validation.MessageBuilder;
import org.mule.tooling.core.validation.ValidationConstants;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.BooleanAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.IMessageProvider;
import org.mule.tooling.ui.modules.core.widgets.meta.MultiWayHelper;

public class AttributeGroupRequirement {
    protected List<LinkedHashSet<String>> requiredAttrs = new ArrayList<LinkedHashSet<String>>();
    protected String customClass;
    protected String customMessage;
    private Artifact muleArtifact;
    IMessageProvider provider;
    AbstractComponentMeta meta;
    boolean exclusive = true;
    private boolean requiredForDataSense;
    private boolean required;

    public String getCustomMessage() {
        return this.customMessage;
    }

    public void setCustomMessage(String customMessage) {
        this.customMessage = customMessage;
    }

    public String getCustomClass() {
        return this.customClass;
    }

    public AttributeGroupRequirement(Artifact muleArtifact) {
        this.muleArtifact = muleArtifact;
    }

    public void setCustomClass(String customClass) {
        this.customClass = customClass;
    }

    public void addRequiredAttrsAlternative(String alt) {
        LinkedHashSet<String> toAdd = new LinkedHashSet<String>();
        String[] stringArray = alt.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String trim = s.trim();
            if (trim.length() > 0) {
                toAdd.add(trim);
            }
            ++n2;
        }
        this.requiredAttrs.add(toAdd);
    }

    public AbstractComponentMeta getMeta() {
        return this.meta;
    }

    public void setMeta(AbstractComponentMeta meta) {
        this.meta = meta;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public Message validate(PropertyCollectionMap properties) {
        boolean requiredCompleted;
        if (this.customClass != null) {
            if (this.provider == null) {
                try {
                    this.provider = (IMessageProvider)this.muleArtifact.newInstance(this.customClass);
                }
                catch (Exception e) {
                    MuleCorePlugin.logError((String)("fail loading: " + this.customClass), (Throwable)e);
                }
            }
            return this.provider.getMessage(properties);
        }
        if (this.exclusive) {
            long requiredPresents = this.requiredAttrs.stream().filter(required -> this.validRequired(properties, (Set<String>)required)).count();
            if (requiredPresents == 0L && this.required) {
                return this.getErrorMessage(this.formAtLeastOneErrorMessage());
            }
            if (requiredPresents > 1L) {
                return this.getErrorMessage(this.formTooManyErrorMessage());
            }
        } else if (this.required && !(requiredCompleted = this.requiredAttrs.stream().anyMatch(requiredSet -> requiredSet.stream().allMatch(required -> this.validRequired(properties, Collections.singleton(required)))))) {
            StringBuilder errorMessageBuilder = new StringBuilder();
            this.addMessage(errorMessageBuilder);
            return this.getErrorMessage(errorMessageBuilder.toString());
        }
        return ValidationConstants.MESSAGE_OK;
    }

    private Message getErrorMessage(String message) {
        if (this.customMessage != null) {
            message = this.customMessage;
        }
        return MessageBuilder.newErrorMessage((String)message).build();
    }

    private boolean validRequired(PropertyCollectionMap properties, Set<String> allRequired) {
        return allRequired.stream().flatMap(required -> this.getXMLNames((String)required, properties).stream()).allMatch(xmlName -> this.isAttribute((String)xmlName, properties) || PropertiesUtils.isChildElement((String)xmlName, (PropertyCollectionMap)properties));
    }

    private Collection<String> getXMLNames(String required, PropertyCollectionMap properties) {
        String property;
        String saveAs;
        HashSet<MultiWayHelper> multiwayHelpers = this.meta.getMultiwayHelpers();
        for (MultiWayHelper multiWayHelper : multiwayHelpers) {
            String helperId = multiWayHelper.getId();
            if (!required.equals(helperId) || !MultiWayHelper.isMultiwayInChildMode(properties, helperId)) continue;
            return multiWayHelper.getXmlNames();
        }
        AttributeHelper attribute = this.meta.getAttribute(required);
        if (attribute != null && StringUtils.isNotBlank((String)(saveAs = attribute.getSaveAs())) && StringUtils.isNotBlank((String)(property = properties.getProperty(saveAs, null)))) {
            return Collections.singleton(property);
        }
        return Collections.singleton(required);
    }

    private boolean hasValidValue(String required, String value) {
        AttributeHelper attribute = this.meta.getAttribute(required);
        return attribute != null && attribute.isAcceptsEmptyValue() ? true : StringUtils.isNotBlank((String)value);
    }

    private boolean isAttribute(String required, PropertyCollectionMap properties) {
        String property = properties.getProperty(required, null);
        boolean validValue = this.hasValidValue(required, property);
        boolean booleanWithoutValue = this.isBooleanWithoutValue(required, property);
        boolean enumWithoutValue = this.isEnumWithoutValue(required, property);
        return properties.hasProperty(required) && validValue && !booleanWithoutValue && !enumWithoutValue;
    }

    private boolean isBooleanWithoutValue(String attrName, String currentValue) {
        BooleanAttributeHelper boolAttr;
        AttributeHelper attribute = this.meta.getAttribute(attrName);
        if (attribute instanceof BooleanAttributeHelper && !(boolAttr = (BooleanAttributeHelper)attribute).isAlwaysFillSimple() && !boolAttr.isAlwaysFill()) {
            String defaultValue;
            String string = defaultValue = boolAttr.getDefaultValue() != null ? boolAttr.getDefaultValue().toString() : null;
            return defaultValue != null && defaultValue.equals(currentValue) || StringUtils.isBlank((String)defaultValue) && "false".equalsIgnoreCase(currentValue);
        }
        return false;
    }

    private boolean isEnumWithoutValue(String attrName, String currentValue) {
        EnumHelper enumAttr;
        AttributeHelper attribute = this.meta.getAttribute(attrName);
        if (attribute instanceof EnumHelper && !(enumAttr = (EnumHelper)attribute).isAlwaysFillSimple() && !enumAttr.isAlwaysFill()) {
            return currentValue == null || "".equals(currentValue);
        }
        return false;
    }

    private String formAtLeastOneErrorMessage() {
        StringBuilder bld = new StringBuilder();
        bld.append("One of the following fields must be set ");
        this.addMessageExclusize(bld);
        bld.append(" (all of them are empty)");
        return bld.toString();
    }

    private String formTooManyErrorMessage() {
        StringBuilder bld = new StringBuilder();
        bld.append("Fields sets ");
        this.addMessageExclusize(bld);
        bld.append(" are mutually exclusive.");
        return bld.toString();
    }

    protected void addMessage(StringBuilder errorMessageBuilder) {
        errorMessageBuilder.append(StringUtils.join(this.requiredAttrs, (String)" or "));
    }

    protected void addMessageExclusize(StringBuilder bld) {
        int a = 0;
        for (LinkedHashSet<String> set : this.requiredAttrs) {
            bld.append(set.toString());
            if (a != this.requiredAttrs.size() - 1) {
                bld.append(", ");
            }
            ++a;
        }
    }

    public List<LinkedHashSet<String>> getRequiredAttrs() {
        return this.requiredAttrs;
    }

    public static boolean accepted(AbstractComponentMeta meta, Set<String> set, PropertyCollectionMap properties) {
        for (String s : set) {
            boolean hasDefaultValue;
            String property = properties.getProperty(s, null);
            if (property == null || property.trim().length() == 0) {
                return false;
            }
            AttributeHelper a = meta.getAttribute(s);
            if (a == null) continue;
            Object defaultValue = a.getDefaultValue();
            boolean bl = hasDefaultValue = defaultValue != null && defaultValue.toString().length() > 0;
            if (!hasDefaultValue) continue;
            return false;
        }
        return true;
    }

    public void setRequiredForDataSense(boolean required) {
        this.requiredForDataSense = required;
    }

    public boolean requiredForDataSense() {
        return this.requiredForDataSense;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }
}

